﻿using System;
using System.Collections.Generic;
using System.ComponentModel;
using System.Data;
using System.Drawing;
using System.Linq;
using System.Text;
using System.Threading.Tasks;
using System.Windows.Forms;
using System.Windows.Forms.DataVisualization.Charting;

namespace ChartSample
{
    public partial class frmChart : Form
    {
        public frmChart()
        {
            InitializeComponent();
        }

        private void button1_Click(object sender, EventArgs e)
        {
            // 初期化
            chart1.Series.Clear();

            // Chartコントロールにデータソースを設定
            chart1.DataSource = GetData();

            // Chartコントロールにタイトルを設定
            chart1.Titles.Clear();
            chart1.Titles.Add("チャートテスト");

            // 系列の設定
            chart1.Series.Add("DataY");

            // グラフの種類をポイントにする
            chart1.Series["DataY"].ChartType = SeriesChartType.Point;
            // マーカーをサークルにする
            chart1.Series["DataY"].MarkerStyle = MarkerStyle.Circle;
            // マーカーのサイズを指定する
            chart1.Series["DataY"].MarkerSize = 8;
            // マーカーの内側を透明にする
            chart1.Series["DataY"].MarkerColor = Color.FromArgb(0, 0, 0, 0);
            // マーカーの線を設定する
            chart1.Series["DataY"].MarkerBorderWidth = 1;
            // マーカーの外側の色を設定する
            chart1.Series["DataY"].MarkerBorderColor = Color.Blue;

            chart1.Series["DataY"].LegendText = "データY";

            // 凡例の表示位置を上部の中央に設定する
            Legend led = new Legend();
            led.Name = "legends";
            led.Docking = Docking.Top;
            led.Alignment = StringAlignment.Center;

            // 凡例を設定する
            chart1.Legends.Add(led);
            chart1.Series["DataY"].Legend = "legends";

            // 凡例を表示する
            chart1.Series["DataY"].IsVisibleInLegend = true;

            // X軸を設定
            chart1.Series["DataY"].XValueMember = "DataX";
            // グリッドの線を引く
            chart1.ChartAreas[0].AxisX.MajorGrid.Enabled = true;
            // グリッドの内側の線を引かない
            chart1.ChartAreas[0].AxisX.MinorGrid.Enabled = false;

            // X軸の範囲を指定
            chart1.ChartAreas[0].AxisX.Minimum = 0;
            chart1.ChartAreas[0].AxisX.Maximum = 100;
            // X軸の間隔を設定
            chart1.ChartAreas[0].AxisX.Interval = 20;

            // Y軸の範囲を指定
            chart1.ChartAreas[0].AxisY.Minimum = 0;
            chart1.ChartAreas[0].AxisY.Maximum = 100;
            // Y軸の間隔を設定
            chart1.ChartAreas[0].AxisY.Interval = 20;

            chart1.Series["DataY"].YValueMembers = "DataY";

            // X軸タイトル
            chart1.ChartAreas[0].AxisX.Title = "Xデータ";
            // Y軸タイトル
            chart1.ChartAreas[0].AxisY.Title = "Yデータ";

            // 下限線を引く
            StripLine lineLower = new StripLine();
            lineLower.BorderColor = Color.Red;
            lineLower.IntervalOffset = 20;
            lineLower.Interval = 0;
            lineLower.BorderWidth = 3;

            chart1.ChartAreas[0].AxisY.StripLines.Add(lineLower);

            // 上限線を引く
            StripLine lineUpper = new StripLine();
            lineUpper.BorderColor = Color.Red;
            lineUpper.IntervalOffset = 75;
            lineUpper.Interval = 0;
            lineUpper.BorderWidth = 3;

            chart1.ChartAreas[0].AxisY.StripLines.Add(lineUpper);

            chart1.DataBind();
        }

        private DataTable GetData()
        {
            DataTable dt = new DataTable();
            DataRow dtRow;

            // 列の作成
            dt.Columns.Add("DataX", Type.GetType("System.Decimal"));
            dt.Columns.Add("DataY", Type.GetType("System.Decimal"));
            
            for (int i = 0; i < 100; i++)
            {
                dtRow = dt.NewRow();
                dtRow["DataX"] = i;
                dtRow["DataY"] = i;
                dt.Rows.Add(dtRow);
            }

            return dt;
        }

    }
}
