/*
 * customdate Plugin for jQuery
 *
 * 쐬 S.Yoshino
 *
 * t݂̂͂ł悤ɂvOCł
 * sȓt͂ꂽNA܂
 *
 * p[^
 *  format       : ȉ4̂ꂩw肷
 *               : yyyy/mm/dd
 *               : yy/mm/dd
 *               : yyyy-mm-dd
 *               : yy-mm-dd
 *                 NyŷƂ2000Nȍ~ƂȂ(2000-2099)
 *  separatechar : N؂Zp[g
 *               : /-w
 *  align        : input̔zuwiE񂹁A񂹓j
 *               : left 񂹂ɂ܂
 *               : right E񂹂ɂ܂
 *               : center ɂ܂
 * yrangestart   : datepicker̊JnN
 * yrangeend     : datepickeȑIN
 *               : 'now'w肷ƌ݂̔N
 * yrangeendoffset : yrangeend'now'w肵Ƃ+N
 *
 * ֐
 *  CustomDateSetValue  : lZbg֐(yyyymmdd܂yymmdd`)
 *  CustomDateGetValue  : l擾֐(yyyymmddŎ擾)
 *  CustomDateGetDisplayValue : l擾֐(/-tŎ擾)
 *
 * g
 *  $('#date1').customdate({format: 'yyyy/mm/dd', separatechar: '/'});
 *
 * _
 * 1)NAƂchangeCxg邱Ƃ
 *   if($(this).val() != ''){
 *   }
 *   邽߂ɏL̂悤ȏKvƂȂ
 *
 * 2014/04/13 VK쐬
 * 2014/04/21 ^uړ̕sC
 * 2014/04/22 align̒ǉ
 * 2014/04/22 FirefoxŃJ[\L[Ȃ_C
 * 2014/04/22 FirefoxDELETEL[Ȃ_C
 * 2015/03/01 jqueryuidatepicker𗘗p
 *            GetValue,SetValue,GetDisplayValue֐ǉ
 * 2015/03/01 readyCxgSetValueƓLq
 * 2015/03/04 \bhύX(CustomControlsƖOԂĂ܂Ȃ̂)
 * 2015/03/08 Rg[݂ȂƂɉȂ
 * 2015/03/14 \bhĂяoƂRg[ȂƂ͉Ȃ
 *
 */
(function($) {
    var format = new Object();              // tH[}bgw 
    var separatechar = new Object();        // Zp[g
    var align = new Object();               // zuʒu

    var yrangestart = new Object();        // datepicker̊JnN
    var yrangeend = new Object();          // datepickeȑIN(noww肷ƍN)
    var yrangeendoffset = new Object();    // noww肵Ƃ+offsetNǉ

    // ready֐1łsĂ邩肷֐
    function execReady() {
        if (typeof execReady.ready === 'undefined') {
            execReady.ready = false;
        } else {
            execReady.ready = true;
        }
        return execReady.ready;
    }

    $.fn.customdate = function (options) {
        if (this.length == 0) {
            return;
        }
        var browserName;            // uEU
        var changeEventExecute;       // focusoutchangeCxgstO
        var changeEventExecuteValue;  // ύXO̕i[changeEventExecute̔p

        var firstSelectFlag;        // SelectԂ̃tO
        var firstClickFlag;         // SelectԂ̃tO


        var defaults = $.extend({
            'format': 'yyyy/mm/dd',
            'separatechar': '/',
            'align': 'left',
            'yrangestart': '2000',
            'yrangeend': 'now',
            'yrangeendoffset': 0
        }, options);

        var setting = $.extend(defaults, options);

        format[this[0].id] = setting.format;
        separatechar[this[0].id] = setting.separatechar;
        align[this[0].id] = setting.align;
        yrangestart[this[0].id] = setting.yrangestart;
        yrangeend[this[0].id] = setting.yrangeend;
        yrangeendoffset[this[0].id] = setting.yrangeendoffset;


        // IME[h̐ݒitȂ̂Ŗj
        $(this).css('ime-mode', 'disabled');
        // eLXg̔zuݒ
        $(this).css('text-align', align[this[0].id]);

        $(this).addClass('customdate');

        // uEU̎擾
        var userAgent = window.navigator.userAgent.toLowerCase();

        if (userAgent.indexOf('opera') != -1) {
            browserName = 'opera';
        } else if (userAgent.indexOf('msie') != -1) {
            browserName = 'ie';
        } else if (userAgent.indexOf('trident') != -1) {
            browserName = 'ie11';
        } else if (userAgent.indexOf('chrome') != -1) {
            browserName = 'chrome';
        } else if (userAgent.indexOf('safari') != -1) {
            browserName = 'safari';
        } else if (userAgent.indexOf('firefox') != -1) {
            browserName = 'firefox';
        } else {
            browserName = '';
        }

        //tIJ_[
        var cur = new Date();
        var gyear;
        if (yrangeend[this[0].id] == 'now') {
            gyear = cur.getFullYear() + yrangeendoffset[this[0].id];
        } else {
            gyear = yrangeend[this[0].id];
        }
        var yrange = yrangestart[this[0].id] + ':' + gyear;
        var opt = {
            regional: 'ja',
            prevText: '&#x3c;O',
            nextText: '&#x3e;',
            currentText: '',
            monthNames: ['1', '2', '3', '4', '5', '6', '7', '8', '9', '10', '11', '12'],
            monthNamesShort: ['1', '2', '3', '4', '5', '6', '7', '8', '9', '10', '11', '12'],
            dayNames: ['j', 'j', 'Ηj', 'j', 'ؗj', 'j', 'yj'],
            dayNamesShort: ['', '', '', '', '', '', 'y'],
            dayNamesMin: ['', '', '', '', '', '', 'y'],
            weekHeader: 'T',
            firstDay: 0,
            showMonthAfterYear: true,
            yearSuffix: 'N',
            showOn: 'button',
            buttonImage: 'images/calendar.jpg',
            buttonImageOnly: true,
            buttonText: 'J_[I',
            changeYear: true,
            yearRange: yrange,
            changeMonth: true,
            beforeShowDay: function(date) {
                if (date.getDay() == 0) {   //j
                    return [true, "ui-datepicker-sunday"];
                } else if (date.getDay() == 6) { //yj	
                    return [true, "ui-datepicker-saturday"];
                } else {    //
                    return [true];
                }
            },
            onClose: function(date) {

            },
            beforeShow: function() {
                if ($(this).is(':disabled') == true) {
                    return false;
                }
            },
            onSelect: function(date) {
                var val = date;

                if (val.length == 0) {
                    return;
                }

                val = val.split(separatechar[this.id]).join('');


                if (changeEventExecuteValue != val) {
                    changeEventExecute = true;
                } else {
                    changeEventExecute = false;
                }

                // tH[JXAEgɕύXƂchangeCxg𑖂点
                if (changeEventExecute == true) {
                    $(this).trigger('change', [false]);
                }
            }
        };

        var tmpformat;
        if (format[this[0].id].indexOf('yyyy') > -1) {
            tmpformat = format[this[0].id].replace('yyyy', 'yy');
        } else {
            tmpformat = format[this[0].id].replace('yy', 'y');
        }

        opt.dateFormat = tmpformat;
        $(this).datepicker(opt);

        // SetValue֐
        $.fn.CustomDateSetValue = function(val) {
            if (this.length == 0) {
                return;
            }

            if (val.length == 0) {
                $(this).val('');
                return;
            }

            if (val.length == 6) {
                val = '20' + val;
            }

            val = val.split(separatechar[this[0].id]).join('');


            var ary = format[this[0].id].split(separatechar[this[0].id]);

            var isYearYY = false;

            if (ary[0] == 'yy') {
                isYearYY = true;
            } else if (ary[0] == 'yyyy') {
                isYearYY = false;
            }

            var year;

            check = checkDate(val);
            year = val.substring(0, 4);

            if (Number(year) < Number(yrangestart[this[0].id])) {
                $(this).val('');
                return;
            }

            if (isYearYY == true) {
                if (check == true) {
                    $(this).val(val.substring(2, 4) + separatechar[this[0].id] + val.substring(4, 6) + separatechar[this[0].id] + val.substring(6, 8));
                } else {
                    $(this).val('');
                }
            } else {
                if (check == true) {
                    $(this).val(val.substring(0, 4) + separatechar[this[0].id] + val.substring(4, 6) + separatechar[this[0].id] + val.substring(6, 8));
                } else {
                    $(this).val('');
                }
            }
        }

        // GetValue֐
        $.fn.CustomDateGetValue = function() {
            if (this.length == 0) {
                return '';
            }

            if ($(this).val() == '') {
                return '';
            }

            var ary = format[this[0].id].split(separatechar[this[0].id]);

            var val;

            if (ary[0] == 'yy') {
                val = '20' + $(this).val().split(separatechar[this[0].id]).join('');
            } else if (ary[0] == 'yyyy') {
                val = $(this).val().split(separatechar[this[0].id]).join('');
            }
            return val;
        }

        // GetDisplayValue֐
        $.fn.CustomDateGetDisplayValue = function() {
            if (this.length == 0) {
                return '';
            }

            if ($(this).val() == '') {
                return '';
            }

            var ary = format[this[0].id].split(separatechar[this[0].id]);

            var val;

            if (ary[0] == 'yy') {
                val = $(this).val().split(separatechar[this[0].id]).join('');
                val = val.substring(0, 2) + separatechar[this[0].id] + val.substring(2, 4) + separatechar[this[0].id] + val.substring(4, 6);
            } else if (ary[0] == 'yyyy') {
                val = $(this).val().split(separatechar[this[0].id]).join('');
                val = val.substring(0, 4) + separatechar[this[0].id] + val.substring(4, 6) + separatechar[this[0].id] + val.substring(6, 8);
            }

            return val;
        }

        $.fn.CustomDateOnSubmit = function() {
            if ($(this).val() == '') {
                $(this).val('');
                return;
            }

            var ary = format[this[0].id].split(separatechar[this[0].id]);

            var val;

            if (ary[0] == 'yy') {
                val = '20' + $(this).val().split(separatechar[this[0].id]).join('');
            } else if (ary[0] == 'yyyy') {
                val = $(this).val().split(separatechar[this[0].id]).join('');
            }
            $(this).val(val);
        }

        // readyCxg
        $(this).ready(function() {
            if (execReady() == true) {
                return;
            }
            $('input.customdate').each(function(i) {
                var val = $(this).val();

                if (val.length == 0) {
                    $(this).val('');
                    return;
                }

                if (val.length == 6) {
                    val = '20' + val;
                }

                val = val.split(separatechar[this.id]).join('');


                var ary = format[this.id].split(separatechar[this.id]);

                var isYearYY = false;

                if (ary[0] == 'yy') {
                    isYearYY = true;
                } else if (ary[0] == 'yyyy') {
                    isYearYY = false;
                }

                var year;

                check = checkDate(val);
                year = val.substring(0, 4);

                if (Number(year) < Number(yrangestart[this.id])) {
                    $(this).val('');
                    return;
                }

                if (isYearYY == true) {
                    if (check == true) {
                        $(this).val(val.substring(2, 4) + separatechar[this.id] + val.substring(4, 6) + separatechar[this.id] + val.substring(6, 8));
                    } else {
                        $(this).val('');
                    }
                } else {
                    if (check == true) {
                        $(this).val(val.substring(0, 4) + separatechar[this.id] + val.substring(4, 6) + separatechar[this.id] + val.substring(6, 8));
                    } else {
                        $(this).val('');
                    }
                }
            });
        });

        // clickCxg
        $(this).on('click', function() {
            if (firstSelectFlag == true && firstClickFlag == true) {
                firstSelectFlag = false;
                firstClickFlag = false;
            } else {
                $(this).select();
                firstSelectFlag = true;
                firstClickFlag = true;
            }
        });

        // pasteCxg
        $(this).on('paste', function(e) {
            var _this = this;
            setTimeout(function() {
                $(_this).val('');
            }, 10);
        });

        // keyupCxg
        $(this).on('keyup', function(e) {
            var keyCode = (e.keyCode) ? e.keyCode : e.which;

            if (keyCode == 8) { // BS
                // lXVꂽchangeCxg΃tOZbg
                var val = $(this).val();
                if (changeEventExecuteValue != val) {
                    changeEventExecute = true;
                } else {
                    changeEventExecute = false;
                }
                return true;
            }
        });

        // keydownCxg
        $(this).on('keydown', function(e) {
            var keyCode = (e.keyCode) ? e.keyCode : e.which;

            if (keyCode == 37 || keyCode == 38 || keyCode == 39 || keyCode == 40) {
                firstSelectFlag = false;
            }

        });

        // keypressCxg
        $(this).keypress(function(e) {
            var keyCode = (e.keyCode) ? e.keyCode : e.which;

            if (browserName == 'ie') {
                if (firstSelectFlag == true && getCarretPos(this) == $(this).val().length) {
                    $(this).val('');
                    firstSelectFlag = false;
                }
            } else if (browserName == 'ie11') {
                if (firstSelectFlag == true && getCarretPos(this) == 0 && keyCode != 9) {
                    $(this).val('');
                    firstSelectFlag = false;
                }
            } else {
                if (firstSelectFlag == true && getCarretPos(this) == 0 && keyCode != 9) {
                    $(this).val('');
                    firstSelectFlag = false;
                }
            }

            var ary = format[this.id].split(separatechar[this.id]);

            var isYearYY = false;

            if (ary[0] == 'yy') {
                isYearYY = true;
            } else if (ary[0] == 'yyyy') {
                isYearYY = false;
            }

            var s = String.fromCharCode(keyCode);

            if (browserName == 'firefox' && keyCode >= 37 && keyCode <= 40) {
                return true;
            } else if (browserName == 'firefox' && keyCode == 46) {
                return true;
            } else if (keyCode == 9) {
                return true;
            } else if (keyCode == 8) { // BS
                return true;
            } else if ((keyCode >= 48 && keyCode <= 57)) { // 1-10
                var tmp = $(this).val();

                if (isYearYY == true) {
                    if (tmp.length >= 6) {
                        return false;
                    }
                } else {
                    if (tmp.length >= 8) {
                        return false;
                    }
                }

                // ݂̃Jbg擾
                var pos = getCarretPos(this);

                var val = $(this).val().substring(0, pos) + s + $(this).val().substring(pos, $(this).val().length);
                var check;


                // lXVꂽchangeCxg΃tOZbg
                if (changeEventExecuteValue != val) {
                    changeEventExecute = true;
                } else {
                    changeEventExecute = false;
                }


                $(this).val(val);

                // JbgʒuĐݒ肷
                setCaretPos(this, pos + 1);


                return false;

            } else {
                return false;
            }
        });

        // focusinCxg
        $(this).focusin(function(e) {
            var val = $(this).val().split(separatechar[this.id]).join('');

            $(this).val(val);

            changeEventExecute = false;

            changeEventExecuteValue = val;

            $(this).select();
            firstSelectFlag = true;
            firstClickFlag = false;

        });

        // focusoutCxg
        $(this).focusout(function(e) {
            var val = $(this).val();

            if (val.length == 0) {
                return;
            }

            val = val.split(separatechar[this.id]).join('');


            var ary = format[this.id].split(separatechar[this.id]);

            var isYearYY = false;

            if (ary[0] == 'yy') {
                isYearYY = true;
            } else if (ary[0] == 'yyyy') {
                isYearYY = false;
            }

            var year;

            if (isYearYY == true) {
                check = checkDate('20' + val);
                year = '20' + val.substring(0, 2);
            } else {
                check = checkDate(val);
                year = val.substring(0, 4);
            }

            if (Number(year) < Number(yrangestart[this.id])) {
                $(this).val('');
                return;
            }

            if (changeEventExecuteValue != $(this).val()) {
                changeEventExecute = true;
            } else {
                changeEventExecute = false;
            }

            if (isYearYY == true) {
                if (check == true) {
                    $(this).val(val.substring(0, 2) + separatechar[this.id] + val.substring(2, 4) + separatechar[this.id] + val.substring(4, 6));
                } else {
                    $(this).val('');
                }
            } else {
                if (check == true) {
                    $(this).val(val.substring(0, 4) + separatechar[this.id] + val.substring(4, 6) + separatechar[this.id] + val.substring(6, 8));
                } else {
                    $(this).val('');
                }
            }

            // tH[JXAEgɕύXƂchangeCxg𑖂点
            if (changeEventExecute == true) {
                $(this).trigger('change', [false]);
            }
        });

        $(this).on('change', function(e) {
            if (changeEventExecute == false) {
                e.stopImmediatePropagation();
                return false;
            }

            return true;
        });

        return this;
    };

    /****************************************************************
    * @@\F eLXg{bNX̃Jbg̃|WV擾
    * @F item eLXg{bNX
    * ߂lF Jbg̃|WV
    ****************************************************************/
    function getCarretPos(item) {
        var CaretPos = 0;
        if (document.selection) { // IE
            //item.focus();         // ꂪIME-Mode܂Ȃ̂ŃRgAEg
            var Sel = document.selection.createRange();
            Sel.moveStart("character", -item.value.length);
            CaretPos = Sel.text.length;
        } else if (item.selectionStart || item.selectionStart == "0") { // Firefox, Chrome
            CaretPos = item.selectionStart;
        }
        return CaretPos;
    }

    /****************************************************************
    * @@\F eLXg{bNX̃Jbg̃|WVݒ肷
    * @F item eLXg{bNX
    *          caret_position ݒ肷Jbg̈ʒu
    * ߂lF Ȃ
    ****************************************************************/
    function setCaretPos(item, caret_position) {
        if (item.setSelectionRange) {  // Firefox, Chrome
            item.focus();
            item.setSelectionRange(caret_position, caret_position);
        } else if (item.createTextRange) { // IE
            var range = item.createTextRange();
            range.collapse(true);
            range.moveEnd("character", caret_position);
            range.moveStart("character", caret_position);
            range.select();
        }
    }

    /****************************************************************
    * @@\F ͂ꂽltYYYYMMDD`ɂȂĂ邩ׂ
    * @F datestr@͂ꂽl
    * ߂lF Ftrue@sFfalse
    ****************************************************************/
    function checkDate(datestr) {
        // K\ɂ鏑`FbN
        if (!datestr.match(/^\d{4}\d{2}\d{2}$/)) {
            return false;
        }
        var vYear = datestr.substring(0, 4) - 0;
        var vMonth = datestr.substring(4, 6) - 1; // Javascript́A0-11ŕ\
        var vDay = datestr.substring(6, 8) - 0;
        // ,̑Ó`FbN
        if (vMonth >= 0 && vMonth <= 11 && vDay >= 1 && vDay <= 31) {
            var vDt = new Date(vYear, vMonth, vDay);
            if (isNaN(vDt)) {
                return false;
            } else if (vDt.getFullYear() == vYear && vDt.getMonth() == vMonth && vDt.getDate() == vDay) {
                return true;
            } else {
                return false;
            }
        } else {
            return false;
        }
    }


})(jQuery);
