/*
 * customnumber Plugin for jQuery
 *
 * 쐬 S.Yoshino
 *
 * w肵͈͂̐l݂̂͂ł悤vOCł
 * l͈̔͂Ƀ}CiXw肳ꂽAl͌-͂邱Ƃ
 * }CiXƃvX؂ւ܂
 *
 * p[^
 *  maxformat : l̏l
 *            : 9Ōw
 *            : _ꍇA.Ŏw
 *  minformat : l̉l
 *            : 9Ōw
 *            : _ꍇA.Ŏw
 *            : }CiXłƂ-w
 *  maxformatminformat͓ł邱(0)
 *    1)maxformat=99999, minformat=-99999
 *    2)maxformat=99999.99, minformat=-99999.99
 *    3)maxformat=99999.99, minformat=0.00
 * commasupport : true  : 3؂̃J}T|[g
 *              : false : J}؂sȂ
 * emptysupport : true  : ()̏ԂT|[g
 *              : false : ()̎A0ɂ
 *  align     : input̔zuwiE񂹁A񂹓j
 *            : left 񂹂ɂ܂
 *            : right E񂹂ɂ܂
 *            : center ɂ܂
 * 
 * ֐
 *  CustomNumberSetValue  : lZbg֐
 *  CustomNumberGetValue  : l擾֐(J}؂̎̓J}͏)
 *  CustomNumberGetDisplayValue : l擾֐(J}܂߂Ď擾)
 *
 *
 * g
 *  $('#num1').customnumber({maxformat: '99999', minformat: '0'});
 *  Enum15̐w
 *
 *  $('#num1').customnumber({maxformat: '99999', minformat: '-99999'});
 *  Enum15̐(}CiX܂)w
 *
 *  $('#num1').customnumber({maxformat: '99999.99', minformat: '-99999.99'});
 *  Enum15̐A2̏w(}CiX܂)
 *
 *  $('#num1').CustomNumberSetValue('12345');
 *  Enum112345Zbg
 *  
 *  $('#num1').CustomNumberGetValue();
 *  Enum1ɃZbgĂl擾(J}͏)
 *
 *  $('#num1').CustomNumberGetDisplayValue();
 *  Enum1ɃZbgĂl擾(J}ĂƂ̓J}Ǝ擾)
 *
 * _
 * 1)changeCxgdɑ
 *   if($(this).val() != ''){
 *   }
 *   邽߂ɏL̂悤ȏKvƂȂ
 * 2)͈͂}CiX̎A9͂-90ƂȂĂ܂A-9ɂȂȂ
 *
 * 2014/04/13 VK쐬
 * 2014/04/21 ^uړ̕sC
 * 2014/04/22 FirefoxŃJ[\L[Ȃ_C
 * 2014/04/22 FirefoxDELETEL[Ȃ_C
 * 2015/02/28 3Ƃ̃J}؂̃T|[g
 *            ͂̏ԂT|[g
 *            GetValue,SetValue,GetDisplayValue̊֐ǉ
 * 2015/03/01 readyCxgSetValueƓLq
 * 2015/03/04 \bhύX(CustomControlsƖOԂĂ܂Ȃ̂)
 * 2015/03/08 Rg[݂ȂƂɉȂ
 * 2015/03/14 \bhĂяoƂRg[ȂƂ͉Ȃ
 * 2015/06/06 }CiX[h̕sC
 *            }CiX̎AԎŕ\ĂȂ_C
 *
 */
(function($) {
    var maxformat = new Object();              // tH[}bgw 
    var minformat = new Object();              // tH[}bgw
    var align = new Object();                  // zuʒu
    var commasupport = new Object();           // J}T|[g
    var emptysupport = new Object();           // T|[g

    // ready֐1łsĂ邩肷֐
    function execReady() {
        if (typeof execReady.ready === 'undefined') {
            execReady.ready = false;
        } else {
            execReady.ready = true;
        }
        return execReady.ready;
    }

    $.fn.customnumber = function (options) {
        if (this.length == 0) {
            return;
        }

        var minusmode;              // }CiX̓[hǂ

        var browserName;            // uEU
        var changeEventExecute;       // focusoutchangeCxgstO
        var changeEventExecuteValue;  // ύXO̕i[changeEventExecute̔p

        var firstSelectFlag;        // SelectԂ̃tO
        var firstClickFlag;         // SelectԂ̃tO

        var defaults = $.extend({
            'maxformat': '99999999',
            'minformat': '-99999999',
            'commasupport': false,
            'emptysupport': false,
            'align': 'right'
        }, options);

        var setting = $.extend(defaults, options);

        maxformat[this[0].id] = setting.maxformat;
        minformat[this[0].id] = setting.minformat;
        align[this[0].id] = setting.align;
        commasupport[this[0].id] = setting.commasupport;
        emptysupport[this[0].id] = setting.emptysupport;

        // IME[h̐ݒilȂ̂Ŗj
        $(this).css('ime-mode', 'disabled');
        // eLXg̔zuݒ
        $(this).css('text-align', align[[this[0].id]]);

        $(this).addClass('customnumber');

        // uEU̎擾
        var userAgent = window.navigator.userAgent.toLowerCase();

        if (userAgent.indexOf('opera') != -1) {
            browserName = 'opera';
        } else if (userAgent.indexOf('msie') != -1) {
            browserName = 'ie';
        } else if (userAgent.indexOf('trident') != -1) {
            browserName = 'ie11';
        } else if (userAgent.indexOf('chrome') != -1) {
            browserName = 'chrome';
        } else if (userAgent.indexOf('safari') != -1) {
            browserName = 'safari';
        } else if (userAgent.indexOf('firefox') != -1) {
            browserName = 'firefox';
        } else {
            browserName = '';
        }

        // l0
        if ($(this).val() == '') {
            if (emptysupport[this[0].id] == true) {
                $(this).val('');
            } else {
                $(this).val('0');
            }
        }

        // SetValue֐
        $.fn.CustomNumberSetValue = function(val) {
            if (this.length == 0) {
                return;
            }

            if (isNaN(Number(val)) == true) {
                if (emptysupport[this[0].id] == true) {
                    $(this).val('');
                } else {
                    $(this).val('0');
                }

                return;
            }

            if (Number(maxformat[this[0].id]) < Number(val) && Number(minformat[this[0].id]) > Number(val)) {
                if (emptysupport[this[0].id] == true) {
                    $(this).val('');
                } else {
                    $(this).val('0');
                }
            } else {
                if (commasupport[this[0].id] == true) {
                    $(this).val(CommaFormat(val));
                } else {
                    $(this).val(val);
                }
            }
        }

        // GetValue֐
        $.fn.CustomNumberGetValue = function() {
            if (this.length == 0) {
                return '';
            }

            return RemoveComma($(this).val());
        }

        // GetDisplayValue֐
        $.fn.CustomNumberGetDisplayValue = function() {
            if (this.length == 0) {
                return '';
            }

            var tmp = RemoveComma($(this).val());

            if (commasupport[this[0].id] == true) {
                tmp = CommaFormat(tmp);
            }

            return tmp;
        }

        $.fn.CustomNumberOnSubmit = function() {
            if ($(this).val() == '') {
                return;
            }

            var val = RemoveComma($(this).val());

            $(this).val(val);
        }

        // readyCxg
        $(this).ready(function() {
            if (execReady() == true) {
                return;
            }
            $('input.customnumber').each(function(i) {
                var val = $(this).val();
                if (isNaN(Number(val)) == true) {
                    if (emptysupport[this.id] == true) {
                        $(this).val('');
                    } else {
                        $(this).val('0');
                    }

                    return;
                }

                if (Number(maxformat[this.id]) < Number(val) && Number(minformat[this.id]) > Number(val)) {
                    if (emptysupport[this.id] == true) {
                        $(this).val('');
                    } else {
                        $(this).val('0');
                    }
                } else {
                    if (commasupport[this.id] == true) {
                        $(this).val(CommaFormat(val));
                    } else {
                        $(this).val(val);
                    }
                }

                var num = Number(RemoveComma(val));

                if (num >= 0) {
                    $(this).css('color', 'Black');
                } else {
                    $(this).css('color', 'Red');
                }

            });
        });

        // clickCxg
        $(this).on('click', function() {
            if (firstSelectFlag == true && firstClickFlag == true) {
                firstSelectFlag = false;
                firstClickFlag = false;
            } else {
                $(this).select();
                firstSelectFlag = true;
                firstClickFlag = true;
            }

        });

        // pasteCxg
        $(this).on('paste', function(e) {
            var _this = this;
            setTimeout(function() {
                $(_this).val('');
            }, 10);
        });

        // focusinCxg
        $(this).on('focusin', function(e) {
            var val = $(this).val();

            if (commasupport[this.id] == true) {
                val = RemoveComma(val);
            }

            if (val == '') {
                minusmode = false;
            } else {
                var num = Number(val);
                if (num >= 0) {
                    minusmode = false;
                } else {
                    minusmode = true;
                }
                $(this).val(num.toString())
            }


            changeEventExecute = false;
            changeEventExecuteValue = $(this).val();

            $(this).select();
            firstSelectFlag = true;
            firstClickFlag = false;

        });

        // focusoutCxg
        $(this).on('focusout', function(e) {

            var val = $(this).val();

            var num = Number(val);

            if (emptysupport[this.id] == true) {
                if (val == '') {
                    $(this).val('');
                } else if (isNaN(num) == true) {
                    $(this).val('');
                } else {
                    if (commasupport[this.id] == true) {
                        num = CommaFormat(num.toString());
                    }
                    $(this).val(num);
                }
            } else {
                if (isNaN(num) == true) {
                    $(this).val('');
                } else {
                    if (commasupport[this.id] == true) {
                        num = CommaFormat(num.toString());
                    }
                    $(this).val(num);
                }
            }

            // tH[JXAEgɕύXƂchangeCxg𑖂点
            if (changeEventExecute == true) {
                $(this).trigger('change', [false]);
            }


        });

        // keydownCxg
        $(this).on('keydown', function(e) {
            var keyCode = (e.keyCode) ? e.keyCode : e.which;

            if (keyCode == 37 || keyCode == 38 || keyCode == 39 || keyCode == 40) {
                firstSelectFlag = false;
            }

        });

        // keyupCxg
        $(this).on('keyup', function(e) {
            var keyCode = (e.keyCode) ? e.keyCode : e.which;
            var s = String.fromCharCode(keyCode);

            if (keyCode == 8) { // BS
                var val = $(this).val();
                var num = Number(val);

                if (num < 0) {
                    $(this).css('color', 'Red');
                } else {
                    $(this).css('color', 'Black');
                }

                return true;
            }
        });

        // keypressCxg
        $(this).on('keypress', function(e) {

            var keyCode = (e.keyCode) ? e.keyCode : e.which;
            var s = String.fromCharCode(keyCode);

            if (browserName == 'ie') {
                if (firstSelectFlag == true && getCarretPos(this) == $(this).val().length) {
                    $(this).val('');
                    firstSelectFlag = false;
                }
            } else if (browserName == 'ie11') {
                if (firstSelectFlag == true && getCarretPos(this) == 0 && keyCode != 9) {
                    $(this).val('');
                    firstSelectFlag = false;
                }
            } else {
                if (firstSelectFlag == true && getCarretPos(this) == 0 && keyCode != 9) {
                    $(this).val('');
                    firstSelectFlag = false;
                }
            }

            if (browserName == 'firefox' && keyCode >= 37 && keyCode <= 40) {
                return true;
            } else if (browserName == 'firefox' && keyCode == 46) {
                return true;
            } else if (keyCode == 9) {
                return true;
            } else if (keyCode == 8) { // BS
                return true;
            } else if (keyCode == 45) { // -
                if (!(minformat[this.id].indexOf('-') >= 0)) {
                    return false;
                }
                // }CiX[h𔽓]
                if (minusmode == true) {
                    minusmode = false;
                } else {
                    minusmode = true;
                }

                var val = $(this).val();
                var num = Number(val);

                var minusformat = false;

                // tH[}bg}CiX̎(0ȉ̎)
                if (minformat[this.id].indexOf('-') >= 0 && (maxformat[this.id] == '0' || maxformat[this.id].indexOf('0.') >= 0)) {
                    minusformat = true;
                }

                // 𔽓]
                // }CiXtH[}bg̎vXɂȂƂ0ɒu
                if (minusformat == true) {
                    if (-num >= 0) {
                        $(this).val('0');
                    } else {
                        $(this).val(-num);
                    }
                } else {
                    $(this).val(-num);
                }

                // ]ʂŃvX͍̎A}CiX̎͐ԂɃeLXg̐F
                if (-num >= 0) {
                    $(this).css('color', 'Black');
                } else {
                    $(this).css('color', 'Red');
                }

                return false;
            } else if ((keyCode >= 48 && keyCode <= 57) || keyCode == 46) { // 1-10 or .
                // ݂̃Jbg擾
                var pos = getCarretPos(this);
                // ݂̃Jbg當̑}ʒu`FbN}
                var val2 = $(this).val();

                // ł.܂܂Ă.͂Ƃ̓L[󂯕tȂ
                if (val2.indexOf('.') >= 0 && s == '.') {
                    return false;
                }
                var val = $(this).val().substring(0, pos) + s + $(this).val().substring(pos, $(this).val().length);

                if (maxformat[this.id].indexOf('.') >= 0) {    // _
                    var minusformat = false;
                    // tH[}bg}CiX̎(0ȉ̎)
                    if (minformat[this.id].indexOf('-') >= 0 && (maxformat[this.id] == '0' || maxformat[this.id].indexOf('0.') >= 0)) {
                        minusformat = true;
                    }

                    // ̒擾
                    var int_part_format = 0;
                    if (maxformat[this.id].match(/\-*\d*/)[0].length - 1 > minformat[this.id].match(/\-*\d*/)[0].length - 1) {
                        int_part_format = maxformat[this.id].match(/\-*\d*/)[0].length - 1;
                    } else {
                        int_part_format = minformat[this.id].match(/\-*\d*/)[0].length - 1;
                    }
                    var int_part_val = 0;
                    try {
                        int_part_val = val.match(/\-*\d*/)[0].length - 1;
                    } catch (e) {

                    }

                    if (int_part_val > int_part_format) { // ͂̒`̐̒𒴂Ƃ͓͂Ȃ
                        return false;
                    } else {

                        var num = Number(val);
                        // ̒擾
                        var dec_part_max = maxformat[this.id].match(/\.\d*/)[0].length - 1;
                        var dec_part_min = minformat[this.id].match(/\.\d*/)[0].length - 1;
                        var dec_part_val = 0;
                        try {
                            dec_part_val = val.match(/\.\d*/)[0].length - 1;
                        } catch (e) {

                        }

                        if (dec_part_val > dec_part_min) { // ͂̒`̏̒𒴂Ƃ͓͂Ȃ
                            return false;
                        } else {
                            var tmp = '';
                            // ̕擾
                            try {
                                if (minusmode == true) {
                                    if (val.indexOf('-') >= 0) {
                                        tmp = val.match(/\-\d*/)[0];
                                    } else {
                                        tmp = val.match(/\d*/)[0];
                                    }
                                } else {
                                    tmp = val.match(/\d*/)[0];
                                }
                            } catch (e) { }

                            // ̕擾
                            var tmp2 = '';
                            try {
                                tmp2 = val.match(/\.\d*/)[0];
                            } catch (e) { }

                            // 𐔒l^ɕϊ
                            tmp3 = Number(tmp);

                            // ƏA
                            tmp = tmp3.toString() + tmp2;

                            // }CiX[hŃ}CiXłȂƂ̓}CiXɂ
                            if (minusmode == true && val.indexOf('-') == -1) {
                                tmp = -tmp;
                            }

                            var num = Number(tmp);

                            if (num < Number(minformat[this.id]) || num > Number(maxformat[this.id])) { // ͔͈͂傫܂͏Ƃ
                                return false;
                            }

                            // lXVꂽchangeCxg΃tOZbg
                            if (changeEventExecuteValue != tmp) {
                                changeEventExecute = true;
                            } else {
                                changeEventExecute = false;
                            }


                            if (minusformat == true) {
                                if (tmp <= 0) {
                                    if (tmp >= 0) {
                                        $(this).css('color', 'Black');
                                    } else {
                                        $(this).css('color', 'Red');
                                    }

                                    $(this).val(tmp);
                                } else {
                                    $(this).css('color', 'Black');
                                    $(this).val('0');
                                }
                            } else {
                                if (tmp >= 0) {
                                    $(this).css('color', 'Black');
                                } else {
                                    $(this).css('color', 'Red');
                                }

                                $(this).val(tmp);
                            }
                        }

                        // JbgʒuĐݒ肷
                        setCaretPos(this, pos + 1);

                        return false;
                    }
                } else {   // 
                    if (s == '.') { // sIh͏Ȃ(Ȃ̂)
                        return false;
                    }

                    var minusformat = false;

                    // tH[}bg}CiX̎(0ȉ̎)
                    if (minformat[this.id].indexOf('-') >= 0 && maxformat[this.id] == '0') {
                        minusformat = true;
                    }


                    var num = Number(val);

                    // }CiX[hONŃ}CiXłȂƂ̓}CiXɂ
                    if (minusmode == true && val.indexOf('-') == -1) {
                        num = -num;
                    }

                    if (num < Number(minformat[this.id]) || num > Number(maxformat[this.id])) { // ͔͈͂傫܂͏Ƃ
                        return false;
                    }

                    // lXVꂽchangeCxg΃tOZbg
                    if (changeEventExecuteValue != num) {
                        changeEventExecute = true;
                    } else {
                        changeEventExecute = false;
                    }

                    if (minusformat == true) {
                        if (num <= 0) {
                            if (num >= 0) {
                                $(this).css('color', 'Black');
                            } else {
                                $(this).css('color', 'Red');
                            }

                            $(this).val(num);
                        } else {
                            $(this).css('color', 'Black');
                            $(this).val('0');
                        }
                    } else {
                        if (num >= 0) {
                            $(this).css('color', 'Black');
                        } else {
                            $(this).css('color', 'Red');
                        }
                        $(this).val(num);
                    }



                    // JbgʒuĐݒ肷
                    setCaretPos(this, pos + 1);

                    return false;
                }

            } else {
                //͕s
                return false;
            }

        });

        return this;
    };

    /***************************************************************
    * @@\F J}؂ɂ
    * @F J}؂ɂ鐔l
    * ߂lF Ȃ
    ****************************************************************/
    function CommaFormat(str) {
        if (str == '') {
            return '';
        }
        var num = new String(str).replace(/,/g, "");
        while (num != (num = num.replace(/^(-?\d+)(\d{3})/, "$1,$2")));
        return num;
    }

    /***************************************************************
    * @@\F J}؂̃J}菜
    * @F J}菜l
    * ߂lF Ȃ
    ****************************************************************/
    function RemoveComma(val) {
        if (val == '') {
            return '';
        }

        return val.split(",").join("");
    }

    /****************************************************************
    * @@\F eLXg{bNX̃Jbg̃|WV擾
    * @F item eLXg{bNX
    * ߂lF Jbg̃|WV
    ****************************************************************/
    function getCarretPos(item) {
        var CaretPos = 0;
        if (document.selection) { // IE
            //item.focus();         // ꂪIME-Mode܂Ȃ̂ŃRgAEg
            var Sel = document.selection.createRange();
            Sel.moveStart("character", -item.value.length);
            CaretPos = Sel.text.length;
        } else if (item.selectionStart || item.selectionStart == "0") { // Firefox, Chrome
            CaretPos = item.selectionStart;
        }
        return CaretPos;
    }

    /****************************************************************
    * @@\F eLXg{bNX̃Jbg̃|WVݒ肷
    * @F item eLXg{bNX
    *          caret_position ݒ肷Jbg̈ʒu
    * ߂lF Ȃ
    ****************************************************************/
    function setCaretPos(item, caret_position) {
        if (item.setSelectionRange) {  // Firefox, Chrome
            item.focus();
            item.setSelectionRange(caret_position, caret_position);
        } else if (item.createTextRange) { // IE
            var range = item.createTextRange();
            range.collapse(true);
            range.moveEnd("character", caret_position);
            range.moveStart("character", caret_position);
            range.select();
        }
    }
})(jQuery);
