/*!
 * customtextbox Plugin for jQuery
 *
 * 쐬 S.Yoshino
 *
 * w肵̃eLXĝݓ͂ł悤ɂvOCł
 * p[^
 *  format    : ͕̎w
 *            : A(pp啶)
 *            : a(pp)
 *            : 9(p)
 *            : @(L)
 *            : S(pXy[X)
 *            : K(pJ^Ji)
 *            : y(Sp)
 *            : r(SpXy[X)
 *  maxlength : ͕(byteŃJEg)
 *  imemode   : ime[h̎w
 *            : auto
 *            : disabled
 *            : active
 *            : inactive
 *  align     : input̔zuwiE񂹁A񂹓j
 *            : left 񂹂ɂ܂
 *            : right E񂹂ɂ܂
 *            : center ɂ܂
 *
 * ֐
 *  CustomTextBoxSetValue  : lZbg֐i͂łȂAĂƂĂ镪j
 *  CustomTextBoxGetValue  : l擾֐
 *
 *
 * g
 *  $('#text1').customtextbox({format: 'A9@', maxlength: '20'});
 *  Etext1ɔpp啶ApApL̓͐s
 *  Ebyte20byte̐
 *
 *  $('#text2').customtextbox({format: 'yr', maxlength: '36'});
 *  Etext2ɑSpASpXy[X̓͐s
 *  Ebyte36byte̐
 *
 *  $('#text3').CustomTextBoxSetValue('ABCDEF');
 *  Etext3ABCDEFZbg
 *    ͂łȂ̂Ƃ͏
 *  
 *  $('#text4').CustomTextBoxGetValue();
 *  Etext4ɃZbgĂl擾 
 *
 *
 * _
 * 1)pƈꏏɔpJ^Jiw肵ƂɊ[h͂̂тIME-ModeOFFɂȂ(IE)
 * 
 * 2014/04/05 VK쐬
 * 2014/04/06 IME-MODEp[^Ŏw肷悤ɕύX
 * 2014/04/21 ^uړ̕sC
 * 2014/04/22 align̒ǉ
 * 2014/04/22 FirefoxŃJ[\L[Ȃ_C
 * 2015/02/19 SetValue,GetValue֐̒ǉ
 * 2015/03/01 readyCxgSetValueƓLq
 * 2015/03/04 \bhύX(CustomControlsƖOԂĂ܂Ȃ̂)
 * 2015/03/08 Rg[݂ȂƂɉȂ
 * 2015/03/14 \bhĂяoƂRg[ȂƂ͉Ȃ
 * 2015/08/01 pasteCxgjsG[ɂȂĂ_C
 */
(function($) {
    var isAlphaUpper = new Object();   // p啶
    var isAlphaLower = new Object();   // p
    var isNumeric = new Object();      // p
    var isSign = new Object();         // L
    var isSpace = new Object();        // pXy[X
    var isHanKatakana = new Object();  // pJ^Ji
    var isZenkaku = new Object();      // Sp
    var isZenSpace = new Object();     // SpXy[X

    var format = new Object();     // 
    var maxlength = new Object();  // ő啶byte
    var align = new Object();      // zuʒu

    // ready֐1łsĂ邩肷֐
    function execReady() {
        if (typeof execReady.ready === 'undefined') {
            execReady.ready = false;
        } else {
            execReady.ready = true;
        }
        return execReady.ready;
    }

    $.fn.customtextbox = function (options) {
        if (this.length == 0) {
            return;
        }
        // O[oϐ
        var imemode;  // IME-ModeOn肷tO(true:ON)
        var chromeInputText; // ChromeIMEEntermFpϐ
        var chromeIMEArrowKeyEvent; // Chrome̕ϊ̖L[
        var chromeIMEMojiHenkan; // Chrome̕ϊ̕ϊ
        var CheckStringFunc = GetCheckString();     // `FbN̊֐
        var convertZenHiraganaToZenKatakanaFunc = convertZenHiraganaToZenKatakana();    // SpЂ炪ȑSpJ^Jiϊ̊֐
        var convertZenKatakanaToHanKatakanaFunc = convertZenKatakanaToHanKatakana();    // SpJ^JipJ^Jiϊ̊֐
        var changeEventExecute;       // focusoutchangeCxgstO
        var changeEventExecuteValue;  // ύXO̕i[changeEventExecute̔p
        var firstSelectFlag;        // SelectԂ̃tO
        var firstClickFlag;         // SelectԂ̃tO
        var firefoxCursorKey;

        var browserName;    // uEU

        // formatw肵̃tO
        isAlphaUpper[this[0].id] = false;   // p啶
        isAlphaLower[this[0].id] = false;   // p
        isNumeric[this[0].id] = false;      // p
        isSign[this[0].id] = false;         // L
        isSpace[this[0].id] = false;        // pXy[X
        isHanKatakana[this[0].id] = false;  // pJ^Ji
        isZenkaku[this[0].id] = false;      // Sp
        isZenSpace[this[0].id] = false;     // SpXy[X

        // 萔
        var CONST_KEY_ENTER = 13;
        var CONST_KEY_ZENKAKU_SPACE = 32;

        var defaults = $.extend({
            'format': 'A9@',
            'maxlength': '20',
            'imemode': '',
            'align': 'left'
        }, options);

        var setting = $.extend(defaults, options);

        format[this[0].id] = setting.format;
        maxlength[this[0].id] = setting.maxlength;
        align[this[0].id] = setting.align;

        // IME[h̐ݒ
        $(this).css('ime-mode', setting.imemode);
        // eLXg̔zuݒ
        $(this).css('text-align', align[this[0].id]);

        $(this).addClass('customtextbox');

        var userAgent = window.navigator.userAgent.toLowerCase();

        if (userAgent.indexOf('opera') != -1) {
            browserName = 'opera';
        } else if (userAgent.indexOf('msie') != -1) {
            browserName = 'ie';
        } else if (userAgent.indexOf('trident') != -1) {
            browserName = 'ie11';
        } else if (userAgent.indexOf('chrome') != -1) {
            browserName = 'chrome';
        } else if (userAgent.indexOf('safari') != -1) {
            browserName = 'safari';
        } else if (userAgent.indexOf('firefox') != -1) {
            browserName = 'firefox';
        } else {
            browserName = '';
        }


        if (format[this[0].id] == '') {
            format[this[0].id] = 'aA9@KSyr';
        }

        for (var i = 0; i < format[this[0].id].length; i++) {
            switch (format[this[0].id].charAt(i)) {
                case 'A':
                    isAlphaUpper[this[0].id] = true;
                    break;
                case 'a':
                    isAlphaLower[this[0].id] = true;
                    break;
                case '9':
                    isNumeric[this[0].id] = true;
                    break;
                case '@':
                    isSign[this[0].id] = true;
                    break;
                case 'S':
                    isSpace[this[0].id] = true;
                    break;
                case 'K':
                    isHanKatakana[this[0].id] = true;
                    break;
                case 'y':
                    isZenkaku[this[0].id] = true;
                    break;
                case 'r':
                    isZenSpace[this[0].id] = true;
                    break;
            }
        }

        // SetValue֐
        $.fn.CustomTextBoxSetValue = function (val) {
            if (this.length == 0) {
                return;
            }
            // pJ^Ji[htrue,Sp[hfalsêƂ
            // Ђ炪ȁAJ^Ji𔼊pJ^Jiɕϊ
            if (isHanKatakana[this[0].id] == true && isZenkaku[this[0].id] == false) {
                val = convertZenHiraganaToZenKatakanaFunc(val);
                val = convertZenKatakanaToHanKatakanaFunc(val);
            }

            // `FbNp̎擾
            var check_string = CheckStringFunc(format[this[0].id]);

            var tmp = '';
            var len = 0;
            for (var i = 0; i < val.length; i++) {
                var c = val.charCodeAt(i);

                if (check_string.indexOf(val.charAt(i)) >= 0 || (isZenSpace[this[0].id] == true && val.charAt(i) == '@') || (isZenkaku[this[0].id] == true && IsHankaku(c) == false)) {
                    // ȉp̂ƂLEN + 1ASp̂ƂLEN + 2Ƃ
                    // c >= 0xff61 && c < 0xffa0 pJ^Ji
                    // c >= 0x0 && c < 0x81 p
                    if (IsHankaku(c) == false) {
                        len = len + 2;
                    } else {
                        len = len + 1;
                    }
                    if (maxlength[this[0].id] >= len) {
                        tmp = tmp + val.charAt(i);
                    }
                }
            }

            $(this).val(tmp);
        }

        // GetValue֐
        $.fn.CustomTextBoxGetValue = function() {
            if (this.length == 0) {
                return '';
            }

            return $(this).val();
        }

        // readyCxg
        $(this).ready(function () {
            if(execReady() == true){
                return;
            }
            $('input.customtextbox').each(function (i) {                
                var val = $(this).val();
                // pJ^Ji[htrue,Sp[hfalsêƂ
                // Ђ炪ȁAJ^Ji𔼊pJ^Jiɕϊ
                if (isHanKatakana[this.id] == true && isZenkaku[this.id] == false) {
                    val = convertZenHiraganaToZenKatakanaFunc(val);
                    val = convertZenKatakanaToHanKatakanaFunc(val);
                }

                // `FbNp̎擾
                var check_string = CheckStringFunc(format[this.id]);

                var tmp = '';
                var len = 0;
                for (var i = 0; i < val.length; i++) {
                    var c = val.charCodeAt(i);

                    if (check_string.indexOf(val.charAt(i)) >= 0 || (isZenSpace[this.id] == true && val.charAt(i) == '@') || (isZenkaku[this.id] == true && IsHankaku(c) == false)) {
                        // ȉp̂ƂLEN + 1ASp̂ƂLEN + 2Ƃ
                        // c >= 0xff61 && c < 0xffa0 pJ^Ji
                        // c >= 0x0 && c < 0x81 p
                        if (IsHankaku(c) == false) {
                            len = len + 2;
                        } else {
                            len = len + 1;
                        }
                        if (maxlength[this.id] >= len) {
                            tmp = tmp + val.charAt(i);
                        }
                    }
                }

                $(this).val(tmp);
            });
        });

        // focusinCxg
        $(this).on('focusin', function() {
            imemode = false;
            chromeIMEArrowKeyEvent = false;
            chromeIMEMojiHenkan = false;
            changeEventExecute = false;

            changeEventExecuteValue = $(this).val();

            $(this).select();
            firstSelectFlag = true;
            firstClickFlag = false;
        });

        // clickCxg
        $(this).on('click', function() {
            if (firstSelectFlag == true && firstClickFlag == true) {
                firstSelectFlag = false;
                firstClickFlag = false;
            } else {
                $(this).select();
                firstSelectFlag = true;
                firstClickFlag = true;
            }

        });

        // keydownCxg
        $(this).on('keydown', function(e) {
            var keyCode = (e.keyCode) ? e.keyCode : e.which;

            chromeInputText = $(this).val();

            if (keyCode == 229) {
                imemode = true;
            }

            if (keyCode == 37 || keyCode == 38 || keyCode == 39 || keyCode == 40) {
                firstSelectFlag = false;
                firefoxCursorKey = true;
            } else {
                firefoxCursorKey = false;
            }

            chromeIMEArrowKeyEvent = false;
            chromeIMEMojiHenkan = false;

        });

        // inputCxg
        $(this).on('input', function(e) {
            if (browserName != 'chrome') {
                return;
            }

            if (chromeInputText == $(this).val() && imemode == true) {
                var _this = this;
                setTimeout(function() {
                    if (chromeIMEArrowKeyEvent == true) {
                        return;
                    }
                    if (chromeIMEMojiHenkan == true) {
                        return;
                    }

                    var val = $(_this).val();

                    // pJ^Ji[htrue,Sp[hfalsêƂ
                    // Ђ炪ȁAJ^Ji𔼊pJ^Jiɕϊ
                    if (isHanKatakana[_this.id] == true && isZenkaku[_this.id] == false) {
                        val = convertZenHiraganaToZenKatakanaFunc(val);
                        val = convertZenKatakanaToHanKatakanaFunc(val);
                    }

                    // `FbNp̎擾
                    var check_string = CheckStringFunc(format[_this.id]);

                    var tmp = '';
                    var len = 0;
                    for (var i = 0; i < val.length; i++) {
                        var c = val.charCodeAt(i);


                        if (check_string.indexOf(val.charAt(i)) >= 0 || (isZenSpace[_this.id] == true && val.charAt(i) == '@') || (isZenkaku[_this.id] == true && IsHankaku(c) == false)) {
                            if (IsHankaku(c) == false) {
                                len = len + 2;
                            } else {
                                len = len + 1;
                            }

                            if (maxlength[_this.id] >= len) {
                                tmp = tmp + val.charAt(i);
                            }
                        }
                    }


                    // ݂̃Jbg擾
                    var pos = getCarretPos(_this);
                    $(_this).val(tmp);
                    // JbgʒuĐݒ肷
                    setCaretPos(_this, pos);
                    chromeIMEArrowKeyEvent = false;
                    chromeIMEMojiHenkan = false;

                    if (changeEventExecuteValue != tmp) {
                        changeEventExecute = true;
                    } else {
                        changeEventExecute = false;
                    }

                }, 100);
            }

        });

        // focusoutCxg
        $(this).on('focusout', function(e) {
            var val = $(this).val();

            // pJ^Ji[htrue,Sp[hfalsêƂ
            // Ђ炪ȁAJ^Ji𔼊pJ^Jiɕϊ
            if (isHanKatakana == true && isZenkaku == false) {
                val = convertZenHiraganaToZenKatakanaFunc(val);
                val = convertZenKatakanaToHanKatakanaFunc(val);
            }

            // `FbNp̎擾
            var check_string = CheckStringFunc(format[this.id]);

            var tmp = '';
            var len = 0;
            for (var i = 0; i < val.length; i++) {
                var c = val.charCodeAt(i);

                if (IsHankaku(c) == false) {
                    len = len + 2;
                } else {
                    len = len + 1;
                }

                if (check_string.indexOf(val.charAt(i)) >= 0 || (isZenSpace[this.id] == true && val.charAt(i) == '@') || (isZenkaku[this.id] == true && IsHankaku(c) == false)) {
                    if (maxlength[this.id] >= len) {
                        tmp = tmp + val.charAt(i);
                    }
                }
            }

            $(this).val(tmp);

            if (changeEventExecute == true) {
                $(this).trigger('change', [false]);
            }

        });

        // pasteCxg
        $(this).on('paste', function() {
            var _this = this;
            setTimeout(function() {
                var val = $(_this).val();

                // pJ^Ji[htrue,Sp[hfalsêƂ
                // Ђ炪ȁAJ^Ji𔼊pJ^Jiɕϊ
                if (isHanKatakana == true && isZenkaku == false) {
                    val = convertZenHiraganaToZenKatakanaFunc(val);
                    val = convertZenKatakanaToHanKatakanaFunc(val);
                }

                // `FbNp̎擾
                var check_string = CheckStringFunc(format[_this.id]);

                var tmp = '';
                var len = 0;
                for (var i = 0; i < val.length; i++) {
                    var c = val.charCodeAt(i);

                    // ȉp̂ƂLEN + 1ASp̂ƂLEN + 2Ƃ
                    // c >= 0xff61 && c < 0xffa0 pJ^Ji
                    // c >= 0x0 && c < 0x81 p
                    if (IsHankaku(c) == false) {
                        len = len + 2;
                    } else {
                        len = len + 1;
                    }

                    if (check_string.indexOf(val.charAt(i)) >= 0 || (isZenSpace == true && val.charAt(i) == '@') || (isZenkaku == true && IsHankaku(c) == false)) {
                        if (maxlength[_this.id] >= len) {
                            tmp = tmp + val.charAt(i);
                        }
                    }
                }

                $(_this).val(tmp);
            }, 10);

        });

        // keyupCxg
        $(this).on('keyup', function(e) {
            var keyCode = (e.keyCode) ? e.keyCode : e.which;
            if (browserName == 'chrome' && imemode == true) {
                if (keyCode >= 37 && keyCode <= 40) { // L[
                    chromeIMEArrowKeyEvent = true;
                } else {
                    chromeIMEArrowKeyEvent = false;
                }

                if (keyCode == 229) {           // ϊ
                    chromeIMEMojiHenkan = true;
                } else {
                    chromeIMEMojiHenkan = false;
                }
            }
            // ݂̃Jbg擾
            var pos = getCarretPos(this);
            // ݂̃Jbg̕擾
            // SpXy[X̂Ƃ͎if
            var s = $(this).val().charAt(pos - 1);

            if (browserName == 'firefox') {
                imemode = true;
            }

            if (imemode == true && keyCode == CONST_KEY_ZENKAKU_SPACE && s == '@') {   // SpXy[X
                var val = $(this).val();
                var tmp = '';
                var flagSpace = false;
                var len = 0;
                for (var i = 0; i < val.length; i++) {
                    var c = val.charCodeAt(i);
                    if (IsHankaku(c) == false) {
                        len = len + 2;
                    } else {
                        len = len + 1;
                    }

                    if ((isZenSpace[this.id] == false && val.charAt(i) == '@')) {
                        flagSpace = true;
                    } else {
                        if (maxlength[this.id] >= len) {
                            tmp = tmp + val.charAt(i);
                        }
                    }

                }
                // ݂̃Jbg擾
                var pos = getCarretPos(this);
                $(this).val(tmp);
                // JbgʒuĐݒ肷
                if (flagSpace == true) {
                    setCaretPos(this, pos - 1);
                } else {
                    setCaretPos(this, pos);
                }

                if (changeEventExecuteValue != val) {
                    changeEventExecute = true;
                } else {
                    changeEventExecute = false;
                }

            } else if (imemode == true && keyCode == CONST_KEY_ENTER) {    // IME-ModeIŊm肵Ƃ̏
                imemode = false;

                var val = $(this).val();

                // pJ^Ji[htrue,Sp[hfalsêƂ
                // Ђ炪ȁAJ^Ji𔼊pJ^Jiɕϊ
                if (isHanKatakana[this.id] == true && isZenkaku[this.id] == false) {
                    val = convertZenHiraganaToZenKatakanaFunc(val);
                    val = convertZenKatakanaToHanKatakanaFunc(val);
                }

                // `FbNp̎擾
                var check_string = CheckStringFunc(format[this.id]);

                var tmp = '';
                var len = 0;
                for (var i = 0; i < val.length; i++) {
                    var c = val.charCodeAt(i);
                    if (IsHankaku(c) == false) {
                        len = len + 2;
                    } else {
                        len = len + 1;
                    }


                    if (check_string.indexOf(val.charAt(i)) >= 0 || (isZenSpace[this.id] == true && val.charAt(i) == '@') || (isZenkaku[this.id] == true && IsHankaku(c) == false)) {
                        if (maxlength[this.id] >= len) {
                            tmp = tmp + val.charAt(i);
                        }
                    }
                }


                // ݂̃Jbg擾
                var pos = getCarretPos(this);
                $(this).val(tmp);
                // JbgʒuĐݒ肷
                setCaretPos(this, pos);

                if (changeEventExecuteValue != val) {
                    changeEventExecute = true;
                } else {
                    changeEventExecute = false;
                }
            }
        });

        // keypressCxg
        $(this).on('keypress', function(e) {
            var keyCode = (e.keyCode) ? e.keyCode : e.which;
            var shiftKey = e.shiftKey;
            var s = String.fromCharCode(keyCode);

            var val = $(this).val();

            // `FbNp̎擾
            var check_string = CheckStringFunc(format[this.id]);

            var len = 0;
            for (var i = 0; i < val.length; i++) {
                var c = val.charCodeAt(i);
                if (IsHankaku(c) == false) {
                    len = len + 2;
                } else {
                    len = len + 1;
                }
            }
            if (browserName == 'ie') { // ie10܂
                if (firstSelectFlag == true && getCarretPos(this) == $(this).val().length) {
                    $(this).val('');
                    firstSelectFlag = false;
                }
            } else if (browserName == 'ie11') { // ie11ȍ~
                if (firstSelectFlag == true && getCarretPos(this) == 0 && keyCode != 9) {
                    $(this).val('');
                    firstSelectFlag = false;
                }
            } else {
                if (firstSelectFlag == true && getCarretPos(this) == 0 && keyCode != 9) {
                    $(this).val('');
                    firstSelectFlag = false;
                }
            }

            if (browserName == 'firefox' && firefoxCursorKey == true && (keyCode >= 37 && keyCode <= 40)) {
                return true;
            } else if (keyCode == 9) {
                return true;
            } else if (keyCode == 8) { // BS
                return true;
            } else if ((keyCode == 33
                || keyCode == 34
                || keyCode == 35
                || keyCode == 36
                || keyCode == 41
                || keyCode == 45
                || keyCode == 37
                || keyCode == 38
                || keyCode == 39
                || keyCode == 40
                || keyCode == 61
                || keyCode == 94
                || keyCode == 126
                || keyCode == 92
                || keyCode == 124
                || keyCode == 64
                || keyCode == 96
                || keyCode == 91
                || keyCode == 123
                || keyCode == 59
                || keyCode == 43
                || keyCode == 58
                || keyCode == 42
                || keyCode == 93
                || keyCode == 125
                || keyCode == 44
                || keyCode == 60
                || keyCode == 46
                || keyCode == 62
                || keyCode == 47
                || keyCode == 63
                || keyCode == 92
                || keyCode == 95)
               && isSign[this.id] == true) { // L
                if (maxlength[this.id] < (len + s.length)) {
                    return false;
                }
                //͉
                return true;
            } else if ((keyCode == 32) && isSpace[this.id] == true) { // Xy[X
                if (maxlength[this.id] < (len + s.length)) {
                    return false;
                }

                //͉
                return true;
            } else if ((keyCode >= 48 && keyCode <= 57) && isNumeric[this.id] == true) { // 1-10
                if (maxlength[this.id] < (len + s.length)) {
                    return false;
                }
                //͉
                return true;
            } else if ((keyCode >= 65 && keyCode <= 90) && isAlphaUpper[this.id] == true) { // A-Z
                if (maxlength[this.id] < (len + s.length)) {
                    return false;
                }
                //͉
                return true;
            } else if ((keyCode >= 65 && keyCode <= 90) && isAlphaLower[this.id] == true) { // A-Z (pq̂Ƃ啶ł͂)
                if (maxlength[this.id] < (len + s.length)) {
                    return false;
                }
                // ݂̃Jbg擾
                var pos = getCarretPos(this);
                // ݂̃Jbg當̑}ʒu`FbN}
                var val = $(this).val().substring(0, pos) + s.toLowerCase() + $(this).val().substring(pos, $(this).val().length);
                $(this).val(val);
                // JbgʒuĐݒ肷
                setCaretPos(this, pos + 1);
                // keypressł͓͂Ȃ
                if (changeEventExecuteValue != val) {
                    changeEventExecute = true;
                } else {
                    changeEventExecute = false;
                }


                return false;
            } else if ((keyCode >= 97 && keyCode <= 122) && isAlphaLower[this.id] == true) { // a-z
                if (maxlength[this.id] < (len + s.length)) {
                    return false;
                }
                //͉
                return true;
            } else if ((keyCode >= 97 && keyCode <= 122) && isAlphaUpper[this.id] == true) { // a-z(p啶̂Ƃł͂)
                if (maxlength[this.id] < (len + s.length)) {
                    return false;
                }
                // ݂̃Jbg擾
                var pos = getCarretPos(this);
                // ݂̃Jbg當̑}ʒu`FbN}
                var val = $(this).val().substring(0, pos) + s.toUpperCase() + $(this).val().substring(pos, $(this).val().length);
                $(this).val(val);
                // JbgʒuĐݒ肷
                setCaretPos(this, pos + 1);
                // keypressł͓͂Ȃ
                if (changeEventExecuteValue != val) {
                    changeEventExecute = true;
                } else {
                    changeEventExecute = false;
                }

                return false;
            } else {
                //͕s
                return false;
            }
        });

        return this;
    };

    /****************************************************************
    * @@\F `FbNp擾
    * @F format ͕w̕
    * ߂lF `FbNp
    ****************************************************************/
    function GetCheckString() {
        // 萔
        var CONST_CHECK_STRING_ALPHA_UPPER = 'ABCDEFGHIJKLMNOPQRSTUVWXYZ';
        var CONST_CHECK_STRING_ALPHA_LOWER = 'abcdefghijklmnopqrstuvwxyz';
        var CONST_CHECK_STRING_NUMERIC = '0123456789';
        var CONST_CHECK_STRING_SIGN = '!"#$%&\'()=-^~\\|@`[{;+:*]},<.>/?_';
        var CONST_CHECK_STRING_HAN_SPACE = ' ';
        var CONST_CHECK_STRING_HAN_KANA = 'ܦݧ߰';

        return function(format) {
            var check_string = '';

            if (format.indexOf('A') >= 0) {
                check_string = check_string + CONST_CHECK_STRING_ALPHA_UPPER;
            }
            if (format.indexOf('a') >= 0) {
                check_string = check_string + CONST_CHECK_STRING_ALPHA_LOWER;
            }
            if (format.indexOf('9') >= 0) {
                check_string = check_string + CONST_CHECK_STRING_NUMERIC;
            }
            if (format.indexOf('@') >= 0) {
                check_string = check_string + CONST_CHECK_STRING_SIGN;
            }
            if (format.indexOf('S') >= 0) {
                check_string = check_string + CONST_CHECK_STRING_HAN_SPACE;
            }
            if (format.indexOf('K') >= 0) {
                check_string = check_string + CONST_CHECK_STRING_HAN_KANA;
            }

            return check_string;

        }

    }

    /****************************************************************
    * @@\F w̕pǂԂ
    * @F c 
    * ߂lF pFtrue@SpFfalse
    ****************************************************************/
    function IsHankaku(c) {
        if (((c >= 0x0 && c < 0x81) || (c == 0xf8f0) || (c >= 0xff61 && c < 0xffa0) || (c >= 0xf8f1 && c < 0xf8f4))) {
            return true;
        } else {
            return false;
        }
    }

    /****************************************************************
    * @@\F CapsLockԂ擾
    * @F e@L[{[h̃Cxg
    * ߂lF ONFtrue@OFFFfalse
    ****************************************************************/
    function isCapsLockOn(e) {
        var keyCode = e.keyCode ? e.keyCode : e.which;
        var shiftKey = e.shiftKey ? e.shiftKey : ((keyCode == 16) ? true : false);
        return (((keyCode >= 65 && keyCode <= 90) && !shiftKey) || ((keyCode >= 97 && keyCode <= 122) && shiftKey))
    }

    /****************************************************************
    * @@\F eLXg{bNX̃Jbg̃|WV擾
    * @F item eLXg{bNX
    * ߂lF Jbg̃|WV
    ****************************************************************/
    function getCarretPos(item) {
        var CaretPos = 0;
        if (document.selection) { // IE
            //item.focus();         // ꂪIME-Mode܂Ȃ̂ŃRgAEg
            var Sel = document.selection.createRange();
            Sel.moveStart("character", -item.value.length);
            CaretPos = Sel.text.length;
        } else if (item.selectionStart || item.selectionStart == "0") { // Firefox, Chrome
            CaretPos = item.selectionStart;
        }
        return CaretPos;
    }

    /****************************************************************
    * @@\F eLXg{bNX̃Jbg̃|WVݒ肷
    * @F item eLXg{bNX
    *          caret_position ݒ肷Jbg̈ʒu
    * ߂lF Ȃ
    ****************************************************************/
    function setCaretPos(item, caret_position) {
        if (item.setSelectionRange) {  // Firefox, Chrome
            item.focus();
            item.setSelectionRange(caret_position, caret_position);
        } else if (item.createTextRange) { // IE
            var range = item.createTextRange();
            range.collapse(true);
            range.moveEnd("character", caret_position);
            range.moveStart("character", caret_position);
            range.select();
        }
    }

    /****************************************************************
    * @@\F SpЂ炪ȂSpJ^Jiɕϊ
    * @F moto@͂ꂽl
    * ߂lF ϊꂽl
    ****************************************************************/
    function convertZenHiraganaToZenKatakana() {
        var fullHira = new Array("", "", "", "", "", "", "", "", "", "", "", "", "", "", "", "", "", "", "", "", "", "", "", "", "", "", "", "", "", "", "", "", "", "", "", "", "", "", "", "", "", "", "", "", "", "", "", "", "", "", "", "", "", "", "", "", "", "", "", "", "", "", "", "", "", "", "", "", "", "", "", "", "", "", "", "", "", "", "", "");
        var fullKana = new Array("K", "M", "O", "Q", "S", "U", "W", "Y", "[", "]", "_", "a", "d", "f", "h", "o", "r", "u", "x", "{", "p", "s", "v", "y", "|", "", "@", "B", "D", "F", "H", "", "", "", "b", "A", "C", "E", "G", "I", "J", "L", "N", "P", "R", "T", "V", "X", "Z", "\", "^", "`", "c", "e", "g", "i", "j", "k", "l", "m", "n", "q", "t", "w", "z", "}", "~", "", "", "", "", "", "", "", "", "", "", "", "", "");

        return function(moto) {
            for (i = 0; i < fullHira.length; i++) {
                re = new RegExp(fullHira[i], "g")
                moto = moto.replace(re, fullKana[i]);
            }

            return moto;
        }
    }


    /****************************************************************
    * @@\F SpJ^Ji𔼊pJ^Jiɕϊ
    * @F moto@͂ꂽl
    * ߂lF ϊꂽl
    ****************************************************************/
    function convertZenKatakanaToHanKatakana() {
        var fullKana = new Array("", "K", "M", "O", "Q", "S", "U", "W", "Y", "[", "]", "_", "a", "d", "f", "h", "o", "r", "u", "x", "{", "p", "s", "v", "y", "|", "J", "B", "u", "v", "A", "E", "", "@", "B", "D", "F", "H", "", "", "", "b", "[", "A", "C", "E", "G", "I", "J", "L", "N", "P", "R", "T", "V", "X", "Z", "\", "^", "`", "c", "e", "g", "i", "j", "k", "l", "m", "n", "q", "t", "w", "z", "}", "~", "", "", "", "", "", "", "", "", "", "", "", "", "", "K");
        var halfKana = new Array("", "", "", "", "", "", "", "", "", "", "", "", "", "", "", "", "", "", "", "", "", "", "", "", "", "", "", "", "", "", "", "", "", "", "", "", "", "", "", "", "", "", "", "", "", "", "", "", "", "", "", "", "", "", "", "", "", "", "", "", "", "", "", "", "", "", "", "", "", "", "", "", "", "", "", "", "", "", "", "", "", "", "", "", "", "", "", "", "");

        return function(moto) {
            for (i = 0; i < fullKana.length; i++) {
                re = new RegExp(fullKana[i], "g")
                moto = moto.replace(re, halfKana[i]);
            }

            return moto;
        }
    }


})(jQuery);
