﻿Public Class frmConfirm
    Private infoDB As DBInfo

    Public Sub SetDBInfo(ByVal DbInfo As DBInfo)
        infoDB = DbInfo
    End Sub

    Private Sub frmConfirm_Load(sender As System.Object, e As System.EventArgs) Handles MyBase.Load
        ' DBコネクション情報の表示
        Me.tbMessage.Text = "[Registry Key]" & vbCrLf & "HKEY_LOCAL_MACHINE\" & DBInfo.PrefixRegKey & infoDB.RegKey & vbCrLf & vbCrLf _
                    & "[SQL Server]" & vbCrLf & CStr(infoDB.Values("DBServer")) _
                    & CStr(IIf(CStr(infoDB.Values("DBPort")) = "", "", "," & CStr(infoDB.Values("DBPort")))) & vbCrLf & vbCrLf _
                    & "[DB Name]" & vbCrLf & CStr(infoDB.Values("DBName")) & vbCrLf & vbCrLf _
                    & "[SQL Server User Name]" & vbCrLf & CStr(infoDB.Values("DBUser")) & vbCrLf & vbCrLf _
                    & "[Encrypted SQL Server User Password]" & vbCrLf & CStr(infoDB.Values("DBEncryptedPassword")) & vbCrLf & vbCrLf _
                    & "[Encrypted DB Password Seed Key]" & vbCrLf & CStr(infoDB.Values("DBEncryptedSeedKey"))
    End Sub

    Private Sub btCancel_Click(sender As System.Object, e As System.EventArgs) Handles btCancel.Click
        Me.Close()
    End Sub

    Private Sub btWriteToRedistry_Click(sender As System.Object, e As System.EventArgs) Handles btWriteToRedistry.Click

        If infoDB.existKey() Then
            If MsgBox("レジストリキーが存在します。上書きしますか？", MsgBoxStyle.OkCancel) = MsgBoxResult.Cancel Then
                Exit Sub
            End If
        End If

        Try
            ' レジストリ登録処理
            infoDB.Save()
            MsgBox("レジストリ書き込み成功")
        Catch ex As Exception
            MsgBox("レジストリ書き込み失敗" & vbCrLf & ex.Message)
        End Try
        Me.Close()

    End Sub
End Class