﻿Imports System.Data.Linq

<HandleError()> _
Public Class HomeController
    Inherits System.Web.Mvc.Controller

    Function Index() As ActionResult
        Return View()
    End Function

    Function ReservationRoom() As ActionResult
        Dim obj As ReservationData = TryCast(Session("ReservationData"), ReservationData)

        ' ビル用プルダウンメニューの生成
        Dim buildingItems As List(Of SelectListItem) = New List(Of SelectListItem)()

        Dim connStr As String = Util.GetConnectionString
        Dim dc As MeetingRoomDBDataContext = New MeetingRoomDBDataContext(connStr)

        Dim buildingInfo As BuildingInfo = New BuildingInfo
        buildingInfo.Building = From t In dc.GetTable(Of Building)() Where t.DISABLED = False Order By t.SEQ_ID Ascending
        Dim SelectBuildingValue As Integer = buildingInfo.Building.First.SEQ_ID

        For Each item In buildingInfo.Building
            buildingItems.Add(New SelectListItem() With {.Text = item.BUILDING_NAME, .Value = item.SEQ_ID})

        Next

        Dim building As SelectList

        If obj Is Nothing Then
            building = New SelectList(buildingItems, "Value", "Text", SelectBuildingValue)
        Else
            SelectBuildingValue = obj.Building
            building = New SelectList(buildingItems, "Value", "Text", obj.Building)
        End If


        ViewData("building") = building

        ' 部屋用プルダウンメニューの設定
        Dim roomItems As List(Of SelectListItem) = New List(Of SelectListItem)()

        Dim roomInfo As RoomInfo = New RoomInfo
        roomInfo.Room = From t In dc.GetTable(Of Room)() Where t.BUILDING_ID = SelectBuildingValue AndAlso t.DISABLED = False Order By t.SEQ_ID Ascending
        Dim SelectRoomValue As Room
        If obj Is Nothing Then
            SelectRoomValue = roomInfo.Room.First
        Else
            SelectRoomValue = (From t In roomInfo.Room Where t.SEQ_ID = obj.Room).First
        End If


        For Each item In roomInfo.Room
            roomItems.Add(New SelectListItem() With {.Text = item.ROOM_NAME, .Value = item.SEQ_ID})
        Next

        Dim room As SelectList

        If obj Is Nothing Then
            room = New SelectList(roomItems, "Value", "Text")
        Else
            room = New SelectList(roomItems, "Value", "Text", obj.Room)
        End If

        ViewData("room") = room
        ViewData("comment") = Util.GetHtmlEncode(SelectRoomValue.COMMENT)

        ' 予約時間プルダウンメニューの設定
        Dim reserveStartTimeItems As List(Of SelectListItem) = New List(Of SelectListItem)()
        Dim reserveEndTimeItems As List(Of SelectListItem) = New List(Of SelectListItem)()

        ' 予約可能時間を取得
        Dim MinTime As String = SelectRoomValue.START_TIME
        Dim MaxTime As String = SelectRoomValue.END_TIME

        ' 予約可能時間を設定(30分おき)
        For i As Integer = 0 To 24
            For j As Integer = 0 To 59 Step 30
                Dim Time As String = String.Format("{0:00}{1:00}", i, j)
                Dim Time2 As String = String.Format("{0:00}:{1:00}", i, j)
                If Time >= MinTime AndAlso Time < MaxTime Then
                    reserveStartTimeItems.Add(New SelectListItem() With {.Text = Time2, .Value = Time})
                End If

                If Time > MinTime AndAlso Time <= MaxTime Then
                    reserveEndTimeItems.Add(New SelectListItem() With {.Text = Time2, .Value = Time})
                End If

            Next
        Next

        Dim reserveStartTime As SelectList

        If obj Is Nothing Then
            reserveStartTime = New SelectList(reserveStartTimeItems, "Value", "Text")
        Else
            reserveStartTime = New SelectList(reserveStartTimeItems, "Value", "Text", obj.ReserveStartTime)
        End If

        ViewData("reserve_time_start") = reserveStartTime

        Dim reserveEndTime As SelectList

        If obj Is Nothing Then
            reserveEndTime = New SelectList(reserveEndTimeItems, "Value", "Text")
        Else
            reserveEndTime = New SelectList(reserveEndTimeItems, "Value", "Text", obj.ReserveEndTime)
        End If
        
        ViewData("reserve_time_end") = reserveEndTime

        If Not obj Is Nothing Then
            ViewData("person_value") = obj.Person
            ViewData("reserve_date_value") = obj.ReserveDate
        End If

        Return View()
    End Function

    <HttpPost()>
    Function ReservationRoom(ByVal collection As FormCollection) As ActionResult
        Dim connStr As String = Util.GetConnectionString
        Dim dc As MeetingRoomDBDataContext = New MeetingRoomDBDataContext(connStr)

        If collection.Item("button") = "確認" Then    ' 確認ボタンが押されてとき
            ' Trim
            collection.Item("person") = collection.Item("person").Trim
            collection.Item("reserve_date") = collection.Item("reserve_date").Trim

            Dim obj As ReservationData = New ReservationData
            obj.Building = collection.Item("building")
            obj.Room = collection.Item("room")
            obj.Person = collection.Item("person")
            obj.ReserveDate = collection.Item("reserve_date")
            obj.ReserveStartTime = collection.Item("reserve_time_start")
            obj.ReserveEndTime = collection.Item("reserve_time_end")

            ' バリデーション
            If obj.Person = "" Then
                ModelState.AddModelError("", "予約者は必須項目です")
            End If

            If Util.IncludeSpecialCharacter(obj.Person) Then
                ModelState.AddModelError("", "予約者に機種依存文字は使えません")
            End If

            If Not IsDate(obj.ReserveDate) Then
                ModelState.AddModelError("", "予約日付が無効です")
            End If

            If obj.ReserveStartTime >= obj.ReserveEndTime Then
                ModelState.AddModelError("", "予約時間が無効です")
            End If

            Session("ReservationData") = obj

            ' バリデーションエラーが発生したとき再表示を行う
            If Not ModelState.IsValid Then
                Return ReservationRoom()
            Else
                Dim reservationInfo As ReservationInfo = New ReservationInfo
                reservationInfo.Reservation = From t In dc.GetTable(Of Reservation)() Where t.BUILDING_ID = obj.Building AndAlso t.ROOM_ID = obj.Room AndAlso t.RESERVE_DATE = obj.ReserveDate.Replace("/", "")

                For Each item In reservationInfo.Reservation
                    Dim reserveStartTime As String = item.RESERVE_START_TIME
                    Dim reserveEndTime As String = item.RESERVE_END_TIME

                    Dim hash As Hashtable = New Hashtable
                    ' 現在予約されているデータの予約開始時間から予約終了時間までフラグを立てる
                    For i As Integer = 0 To 24
                        For j As Integer = 0 To 59 Step 30
                            Dim tmp As String = String.Format("{0:00}{1:00}", i, j)

                            If tmp >= reserveStartTime AndAlso tmp < reserveEndTime Then
                                hash.Item(tmp) = 1
                            Else
                                hash.Item(tmp) = 0
                            End If
                        Next
                    Next

                    Dim hash2 As Hashtable = New Hashtable

                    ' 予約しようとしているデータの予約開始時間から予約終了時間までフラグを立てる
                    For i As Integer = 0 To 24
                        For j As Integer = 0 To 59 Step 30
                            Dim tmp As String = String.Format("{0:00}{1:00}", i, j)

                            If tmp >= obj.ReserveStartTime AndAlso tmp < obj.ReserveEndTime Then
                                hash2.Item(tmp) = 1
                            Else
                                hash2.Item(tmp) = 0
                            End If
                        Next
                    Next

                    ' 予約されているがどうか判定する
                    For Each key In hash.Keys
                        If hash.Item(key) = 1 AndAlso hash2.Item(key) = 1 Then
                            ModelState.AddModelError("", "指定の時間帯は予約済みです")
                            Return ReservationRoom()
                        End If
                    Next
                Next

            End If

            ' 確認画面へ遷移する
            Return RedirectToAction("ReservationRoomConfirm", "Home")
        Else        ' プルダウンメニューが更新されたとき


            ' ビル用プルダウンメニューの生成
            Dim buildingItems As List(Of SelectListItem) = New List(Of SelectListItem)()

            Dim buildingInfo As BuildingInfo = New BuildingInfo
            buildingInfo.Building = From t In dc.GetTable(Of Building)() Where t.DISABLED = False Order By t.SEQ_ID Ascending

            For Each item In buildingInfo.Building
                buildingItems.Add(New SelectListItem() With {.Text = item.BUILDING_NAME, .Value = item.SEQ_ID})
            Next

            Dim building As SelectList

            building = New SelectList(buildingItems, "Value", "Text", collection("building"))

            ViewData("building") = building

            ' 会議室用プルダウンメニューの設定
            Dim roomItems As List(Of SelectListItem) = New List(Of SelectListItem)()

            Dim roomInfo As RoomInfo = New RoomInfo
            roomInfo.Room = From t In dc.GetTable(Of Room)() Where t.BUILDING_ID = collection.Item("building") AndAlso t.DISABLED = False Order By t.SEQ_ID Ascending
            Dim SelectRoomValue As Room

            ' プルダウンメニューのうちbuildingが更新されたときは先頭のroomを取り出す
            ' roomが更新されたときは更新されたroomを取得する
            If collection.Item("hdPostBack") = "building" Then ' buildingが更新されたとき
                SelectRoomValue = (From t In roomInfo.Room Order By t.SEQ_ID Ascending).First
            ElseIf collection.Item("hdPostBack") = "room" Then 'roomが更新されたとき
                SelectRoomValue = (From t In dc.GetTable(Of Room)() Where t.SEQ_ID = collection.Item("room")).First
            Else ' それ以外のときはエラー
                Return RedirectToAction("Maintenance", "Home")
            End If


            For Each item In roomInfo.Room
                roomItems.Add(New SelectListItem() With {.Text = item.ROOM_NAME, .Value = item.SEQ_ID})
            Next

            Dim room As SelectList

            room = New SelectList(roomItems, "Value", "Text", collection("room"))

            ViewData("room") = room

            ViewData("comment") = Util.GetHtmlEncode(SelectRoomValue.COMMENT)

            ' 予約時間プルダウンメニューの設定
            Dim reserveStartTimeItems As List(Of SelectListItem) = New List(Of SelectListItem)()
            Dim reserveEndTimeItems As List(Of SelectListItem) = New List(Of SelectListItem)()

            ' 予約可能時間を取得
            Dim MinTime As String = SelectRoomValue.START_TIME
            Dim MaxTime As String = SelectRoomValue.END_TIME

            ' 予約可能時間を設定(30分おき)
            For i As Integer = 0 To 24
                For j As Integer = 0 To 59 Step 30
                    Dim Time As String = String.Format("{0:00}{1:00}", i, j)
                    Dim Time2 As String = String.Format("{0:00}:{1:00}", i, j)
                    If Time >= MinTime AndAlso Time < MaxTime Then
                        reserveStartTimeItems.Add(New SelectListItem() With {.Text = Time2, .Value = Time})
                    End If

                    If Time > MinTime AndAlso Time <= MaxTime Then
                        reserveEndTimeItems.Add(New SelectListItem() With {.Text = Time2, .Value = Time})
                    End If

                Next
            Next

            Dim reserveStartTime As SelectList

            reserveStartTime = New SelectList(reserveStartTimeItems, "Value", "Text")

            ViewData("reserve_time_start") = reserveStartTime

            Dim reserveEndTime As SelectList

            reserveEndTime = New SelectList(reserveEndTimeItems, "Value", "Text")

            ViewData("reserve_time_end") = reserveEndTime

            Return View()

           
        End If
    End Function

    Function ReservationRoomConfirm() As ActionResult
        Dim obj As ReservationData = TryCast(Session("ReservationData"), ReservationData)

        ' セッションがないときはエラー
        If obj Is Nothing Then
            Return RedirectToAction("Maintenance", "Home")
        End If
        ' 表示データを生成する
        Dim connStr As String = Util.GetConnectionString
        Dim dc As MeetingRoomDBDataContext = New MeetingRoomDBDataContext(connStr)

        Dim BuildingName As String = (From t In dc.GetTable(Of Building)() Where t.SEQ_ID = obj.Building).First.BUILDING_NAME

        ViewData("building") = BuildingName

        Dim RoomName As String = (From t In dc.GetTable(Of Room)() Where t.SEQ_ID = obj.Room).First.ROOM_NAME

        ViewData("room") = RoomName

        ViewData("person") = obj.Person
        ViewData("reserve_date") = obj.ReserveDate
        ViewData("reserve_time_start") = obj.ReserveStartTime.Substring(0, 2) & ":" & obj.ReserveStartTime.Substring(2, 2)
        ViewData("reserve_time_end") = obj.ReserveEndTime.Substring(0, 2) & ":" & obj.ReserveEndTime.Substring(2, 2)

        Return View()
    End Function

    <HttpPost()>
    Function ReservationRoomConfirm(ByVal collection As FormCollection) As ActionResult
        If collection.Item("button") = "保存" Then ' 保存ボタンが押されたとき
            Dim obj As ReservationData = TryCast(Session("ReservationData"), ReservationData)

            ' セッションがないときはエラー
            If obj Is Nothing Then
                Return RedirectToAction("Maintenance", "Home")
            End If

            Dim connStr As String = Util.GetConnectionString
            Dim dc As MeetingRoomDBDataContext = New MeetingRoomDBDataContext(connStr)

            ' すでに予約データがあるときはエラーを表示する
            ' 確認画面でも再度確認する
            ' 本当はストアドで判定したほうがよい
            ' もしくは同時に予約できないようにしたほうがよい
            Dim reservationInfo As ReservationInfo = New ReservationInfo
            reservationInfo.Reservation = From t In dc.GetTable(Of Reservation)() Where t.BUILDING_ID = obj.Building AndAlso t.ROOM_ID = obj.Room AndAlso t.RESERVE_DATE = obj.ReserveDate.Replace("/", "")

            For Each item In reservationInfo.Reservation
                Dim reserveStartTime As String = item.RESERVE_START_TIME
                Dim reserveEndTime As String = item.RESERVE_END_TIME

                Dim hash As Hashtable = New Hashtable
                ' 現在予約されているデータの予約開始時間から予約終了時間までフラグを立てる
                For i As Integer = 0 To 24
                    For j As Integer = 0 To 59 Step 30
                        Dim tmp As String = String.Format("{0:00}{1:00}", i, j)

                        If tmp >= reserveStartTime AndAlso tmp < reserveEndTime Then
                            hash.Item(tmp) = 1
                        Else
                            hash.Item(tmp) = 0
                        End If
                    Next
                Next

                Dim hash2 As Hashtable = New Hashtable

                ' 予約しようとしているデータの予約開始時間から予約終了時間までフラグを立てる
                For i As Integer = 0 To 24
                    For j As Integer = 0 To 59 Step 30
                        Dim tmp As String = String.Format("{0:00}{1:00}", i, j)

                        If tmp >= obj.ReserveStartTime AndAlso tmp < obj.ReserveEndTime Then
                            hash2.Item(tmp) = 1
                        Else
                            hash2.Item(tmp) = 0
                        End If
                    Next
                Next

                ' 判定
                For Each key In hash.Keys
                    If hash.Item(key) = 1 AndAlso hash2.Item(key) = 1 Then
                        ModelState.AddModelError("", "指定の時間帯は予約済みです")
                        Return ReservationRoom()
                    End If
                Next
            Next

            ' 予約データをテーブルにインサート
            Try
                dc.InsertReservation(obj.Building, obj.Room, obj.Person, obj.ReserveDate.Replace("/", ""), obj.ReserveStartTime, obj.ReserveEndTime)
            Catch ex As Exception
                Return RedirectToAction("Maintenance", "Home")
            End Try

            ' セッションをクリア
            Session("ReservationData") = Nothing
            ' メッセージボックスの表示
            Session("MessageBoxTitle") = "会議室予約完了"
            Session("MessageBoxMessage") = "会議室の予約が完了しました"
            Return RedirectToAction("MessageBox", "Home")
        ElseIf collection.Item("button") = "戻る" Then
            ' 予約画面へ戻る
            Return RedirectToAction("ReservationRoom", "Home")
        Else
            ' ここにくるはずがないのでメインテナンス画面へ
            Return RedirectToAction("Maintenance", "Home")
        End If
    End Function

    Function ReservationConfirm() As ActionResult
        ' ビル用プルダウンメニューの生成
        Dim buildingItems As List(Of SelectListItem) = New List(Of SelectListItem)()

        Dim connStr As String = Util.GetConnectionString
        Dim dc As MeetingRoomDBDataContext = New MeetingRoomDBDataContext(connStr)

        Dim buildingInfo As BuildingInfo = New BuildingInfo
        buildingInfo.Building = From t In dc.GetTable(Of Building)() Order By t.SEQ_ID Ascending
        Dim SelectBuildingValue As Integer = buildingInfo.Building.First.SEQ_ID

        For Each item In buildingInfo.Building
            buildingItems.Add(New SelectListItem() With {.Text = item.BUILDING_NAME, .Value = item.SEQ_ID})

        Next

        Dim building As SelectList

        building = New SelectList(buildingItems, "Value", "Text", SelectBuildingValue)
        ViewData("building") = building

        Return View()
    End Function

    <HttpPost()>
    Function ReservationConfirm(ByVal collection As FormCollection) As ActionResult
        ' Trim
        collection.Item("reserve_date") = collection.Item("reserve_date").Trim

        ' 再設定
        ViewData("reserve_date_value") = collection.Item("reserve_date")
        ' ビル用プルダウンメニューの生成
        Dim buildingItems As List(Of SelectListItem) = New List(Of SelectListItem)()

        Dim connStr As String = Util.GetConnectionString
        Dim dc As MeetingRoomDBDataContext = New MeetingRoomDBDataContext(connStr)

        Dim buildingInfo As BuildingInfo = New BuildingInfo
        buildingInfo.Building = From t In dc.GetTable(Of Building)() Order By t.SEQ_ID Ascending
        Dim SelectBuildingValue As Integer = buildingInfo.Building.First.SEQ_ID

        For Each item In buildingInfo.Building
            buildingItems.Add(New SelectListItem() With {.Text = item.BUILDING_NAME, .Value = item.SEQ_ID})

        Next

        Dim building As SelectList
        building = New SelectList(buildingItems, "Value", "Text", collection.Item("building"))
        
        ViewData("building") = building

        ' Validation
        If Not IsDate(collection.Item("reserve_date")) Then
            ModelState.AddModelError("", "日付の指定が無効です")
        End If

        ' バリデーションエラーが発生したとき再表示を行う
        If Not ModelState.IsValid Then
            Return View()
        End If

        ' 表示データの生成
        Dim room = From t In dc.GetTable(Of Room)() Where t.BUILDING_ID = collection.Item("building") AndAlso t.DISABLED = False

        Dim list = From t In dc.GetTable(Of Reservation)()
                   Join t2 In dc.GetTable(Of Building)() On t.BUILDING_ID Equals t2.SEQ_ID
                   Join t3 In dc.GetTable(Of Room)() On t.ROOM_ID Equals t3.SEQ_ID
                   Where t.BUILDING_ID = collection.Item("building") AndAlso t.RESERVE_DATE = collection.Item("reserve_date").Replace("/", "") AndAlso t2.DISABLED = False AndAlso t3.DISABLED = False

        Dim ary As ArrayList = New ArrayList

        ' 会議室ごとに処理を行う
        ' 予約時間帯の計算
        ' 予約されているかフラグのセット
        For Each item In room
            Dim roomID As Integer = item.SEQ_ID
            Dim list2 = From t In list Where t.t.ROOM_ID = roomID

            Dim obj As ReservedInfo = New ReservedInfo

            obj.RoomID = roomID
            obj.RoomName = item.ROOM_NAME
            obj.ReserveDate = collection.Item("reserve_date").Replace("/", "")

            ' 予約済みの時間帯を計算
            For Each item2 In list2
                Dim reserveStartTime As String = item2.t.RESERVE_START_TIME
                Dim reserveEndTime As String = item2.t.RESERVE_END_TIME

                For i As Integer = 0 To 24
                    For j As Integer = 0 To 59 Step 30
                        Dim tmp As String = String.Format("{0:00}{1:00}", i, j)

                        If tmp >= reserveStartTime AndAlso tmp < reserveEndTime Then
                            obj.ReservedState.Item(tmp) = 1
                        Else
                            If obj.ReservedState.Item(tmp) <> 1 Then
                                obj.ReservedState.Item(tmp) = 0
                            End If
                        End If
                    Next
                Next
            Next

            ' 予約済みが一箇所でもあればフラグをセットする
            obj.IsReserved = False
            For Each key As String In obj.ReservedState.Keys
                If obj.ReservedState.Item(key) = 1 Then
                    obj.IsReserved = True
                End If
            Next
            ary.Add(obj)
        Next

        Return View(ary)
    End Function

    Function EditReservation(ByVal id As String, ByVal d As String) As ActionResult
        Dim connStr As String = Util.GetConnectionString
        Dim dc As MeetingRoomDBDataContext = New MeetingRoomDBDataContext(connStr)
        ' 予約の一覧を取得
        Dim list = From t In dc.GetTable(Of Reservation)()
                   Join t2 In dc.GetTable(Of Building)() On t.BUILDING_ID Equals t2.SEQ_ID
                   Join t3 In dc.GetTable(Of Room)() On t.ROOM_ID Equals t3.SEQ_ID
                   Where t.ROOM_ID = id AndAlso t.RESERVE_DATE = d Order By t.RESERVE_START_TIME Ascending

        ' 予約がひとつもなければエラー画面に遷移
        If list.Count = 0 Then
            Return RedirectToAction("Maintenance", "Home")
        End If

        Return View(list)
    End Function

    <HttpPost()>
    Function EditReservation(ByVal collection As FormCollection) As ActionResult
        If collection.Item("button") = "戻る" Then
            Return RedirectToAction("ReservationConfirm", "Home")
        Else
            Dim DeleteButtonNo As Integer
            ' 押された削除ボタンを判定
            For Each keys In collection.Keys
                If keys.ToString.StartsWith("remove") Then
                    DeleteButtonNo = CInt(keys.ToString.Replace("remove", ""))
                End If
            Next

            Dim connStr As String = Util.GetConnectionString
            Dim dc As MeetingRoomDBDataContext = New MeetingRoomDBDataContext(connStr)

            ' 予約データの削除
            Try
                dc.DeleteReservation(DeleteButtonNo)
            Catch ex As Exception
                Return RedirectToAction("Maintenance", "Home")
            End Try

            ' メッセージボックスの表示
            Session("MessageBoxTitle") = "予約取消"
            Session("MessageBoxMessage") = "予約を取り消しました"


            Return RedirectToAction("MessageBox", "Home")
        End If
 
    End Function

    Function EditMeetingRoom() As ActionResult
        Return View()
    End Function

    Function ListBuilding() As ActionResult
        Return View()
    End Function

    <HttpPost()>
    Function ListBuilding(ByVal collection As FormCollection) As ActionResult
        If collection.Item("button") = "検索" Then ' 検索ボタンが押されたとき
            Dim connStr As String = Util.GetConnectionString
            Dim dc As MeetingRoomDBDataContext = New MeetingRoomDBDataContext(connStr)

            ' ビルの一覧を取得
            Dim list = From t In dc.GetTable(Of Building)() Order By t.SEQ_ID

            Return View(list)

        ElseIf collection.Item("button") = "新規登録" Then ' 新規登録ボタンが押されたとき
            Return RedirectToAction("NewBuilding", "Home")
        Else ' それ以外のときはエラー
            Return RedirectToAction("Maintenance", "Home")
        End If
    End Function

    Function EditBuilding(ByVal id As String) As ActionResult

        Dim connStr As String = Util.GetConnectionString
        Dim dc As MeetingRoomDBDataContext = New MeetingRoomDBDataContext(connStr)

        Dim obj As EditBuilding = TryCast(Session("EditBuilding"), EditBuilding)

        If obj Is Nothing Then
            Dim items = From t In dc.GetTable(Of Building)() Where t.SEQ_ID = id

            ' 該当するデータがないときはエラー
            If items.Count = 0 Then
                Return RedirectToAction("Maintenance", "Home")
            End If

            Dim item = (From t In items).First

            ViewData("seq_id") = id
            ViewData("building_value") = item.BUILDING_NAME

            obj = New EditBuilding
            obj.SeqID = id
            obj.BuildingName = item.BUILDING_NAME
            obj.Disabled = item.DISABLED
        Else
            ViewData("seq_id") = obj.SeqID
            ViewData("building_value") = obj.BuildingName
        End If


        Return View(obj)
    End Function

    <HttpPost()>
    Function EditBuilding(ByVal id As String, ByVal collection As FormCollection) As ActionResult
        If collection.Item("button") = "戻る" Then ' 戻るボタンが押されたとき
            Session("EditBuilding") = Nothing
            Return RedirectToAction("ListBuilding", "Home")
        ElseIf collection.Item("button") = "確認" Then ' 確認ボタンが押されたとき
            Dim connStr As String = Util.GetConnectionString
            Dim dc As MeetingRoomDBDataContext = New MeetingRoomDBDataContext(connStr)

            Dim items = From t In dc.GetTable(Of Building)() Where t.SEQ_ID = id

            ' 該当するデータがないときはエラー
            If items.Count = 0 Then
                Return RedirectToAction("Maintenance", "Home")
            End If

            'Trim
            collection.Item("building") = collection.Item("building").Trim

            ' オブジェクトに設定
            Dim obj As EditBuilding = New EditBuilding
            obj.SeqID = id
            obj.BuildingName = collection.Item("building")
            obj.Disabled = Request.Form.GetValues("disabled")(0)

            ' バリデーション
            If obj.BuildingName = "" Then
                ModelState.AddModelError("", "ビル名は必須です")
            End If

            If obj.BuildingName.Length > 40 Then
                ModelState.AddModelError("", "ビル名は４０文字以内で入力してください")
            End If

            If Util.IncludeSpecialCharacter(obj.BuildingName) Then
                ModelState.AddModelError("", "ビル名に機種依存文字は使えません")
            End If

            Session("EditBuilding") = obj

            ' バリデーションエラーが発生したとき再表示を行う
            If Not ModelState.IsValid Then
                Return EditBuilding(id)
            End If

            ' 確認画面に遷移
            Return RedirectToAction("EditBuildingConfirm", "Home")

        Else ' それ以外のときエラー画面に遷移
            Return RedirectToAction("Maintenance", "Home")
        End If

        Return View()
    End Function

    Function EditBuildingConfirm() As ActionResult
        Dim obj As EditBuilding = TryCast(Session("EditBuilding"), EditBuilding)

        ' セッションが見つからないときはエラー画面
        If obj Is Nothing Then
            Return RedirectToAction("Maintenance", "Home")
        End If

        ' 表示データを生成
        ViewData("seq_id") = obj.SeqID.ToString
        ViewData("building") = Util.GetHtmlEncode(obj.BuildingName)
        ViewData("disabled") = obj.Disabled

        Return View()
    End Function

    <HttpPost()>
    Function EditBuildingConfirm(ByVal collection As FormCollection) As ActionResult
        Dim obj As EditBuilding = TryCast(Session("EditBuilding"), EditBuilding)

        ' セッションが見つからないときはエラー
        If obj Is Nothing Then
            Return RedirectToAction("Maintenance", "Home")
        End If

        If collection.Item("button") = "戻る" Then ' 戻るボタンが押されたとき
            Return RedirectToAction("EditBuilding/" & obj.SeqID, "Home")
        ElseIf collection.Item("button") = "保存" Then ' 保存ボタンが押されたとき

            Dim connStr As String = Util.GetConnectionString
            Dim dc As MeetingRoomDBDataContext = New MeetingRoomDBDataContext(connStr)

            ' ビル情報を更新
            Try
                dc.UpdateBuilding(obj.SeqID, obj.BuildingName, obj.Disabled)
                dc.SubmitChanges()
            Catch ex As Exception
                Return RedirectToAction("Maintenance", "Home")
            End Try


            Session("EditBuilding") = Nothing
            Session("MessageBoxTitle") = "ビルの更新"
            Session("MessageBoxMessage") = "ビルの更新が終了しました"
            Return RedirectToAction("MessageBox", "Home")
        Else ' それ以外のとき
            Return RedirectToAction("Maintenance", "Home")
        End If
    End Function

    Function NewBuilding() As ActionResult

        Dim connStr As String = Util.GetConnectionString
        Dim dc As MeetingRoomDBDataContext = New MeetingRoomDBDataContext(connStr)

        ' セッションの取得
        Dim obj As NewBuilding = TryCast(Session("NewBuilding"), NewBuilding)

        ' セッションがないとき
        If obj Is Nothing Then       
            obj = New NewBuilding
            obj.BuildingName = ""
            obj.Disabled = False
        End If

        ' 再描画処理
        ViewData("building_value") = obj.BuildingName

        Return View(obj)
    End Function

    <HttpPost()>
    Function NewBuilding(ByVal collection As FormCollection) As ActionResult
        If collection.Item("button") = "戻る" Then ' 戻るボタンが押されたとき
            Session("NewBuilding") = Nothing
            Return RedirectToAction("ListBuilding", "Home")
        ElseIf collection.Item("button") = "確認" Then '　確認ボタンが押されたとき
            'Trim
            collection.Item("building") = collection.Item("building").Trim

            ' オブジェクトの生成
            Dim obj As NewBuilding = New NewBuilding
            obj.BuildingName = collection.Item("building")
            obj.Disabled = Request.Form.GetValues("disabled")(0)

            ' バリデーション
            If obj.BuildingName = "" Then
                ModelState.AddModelError("", "ビル名は必須です")
            End If

            If obj.BuildingName.Length > 40 Then
                ModelState.AddModelError("", "ビル名は４０文字以内で入力してください")
            End If

            If Util.IncludeSpecialCharacter(obj.BuildingName) Then
                ModelState.AddModelError("", "ビル名に機種依存文字は使えません")
            End If

            Session("NewBuilding") = obj

            ' バリデーションエラーが発生したとき再表示を行う
            If Not ModelState.IsValid Then
                Return NewBuilding()
            End If

            ' 確認画面へ遷移
            Return RedirectToAction("NewBuildingConfirm", "Home")

        Else ' それ以外のときはエラー画面へ

            Return RedirectToAction("Maintenance", "Home")
        End If

        Return View()
    End Function

    Function NewBuildingConfirm() As ActionResult
        Dim obj As NewBuilding = TryCast(Session("NewBuilding"), NewBuilding)

        ' セッションがないときはエラー画面へ
        If obj Is Nothing Then
            Return RedirectToAction("Maintenance", "Home")
        End If

        ' 表示データをセット
        ViewData("building") = Util.GetHtmlEncode(obj.BuildingName)
        ViewData("disabled") = obj.Disabled

        Return View()
    End Function

    <HttpPost()>
    Function NewBuildingConfirm(ByVal collection As FormCollection) As ActionResult
        If collection.Item("button") = "戻る" Then ' 戻るボタンが押されたとき
            Return RedirectToAction("NewBuilding", "Home")
        ElseIf collection.Item("button") = "保存" Then ' 保存ボタンが押されたとき
            Dim obj As NewBuilding = TryCast(Session("NewBuilding"), NewBuilding)
            ' セッションが見つからないときはエラー
            If obj Is Nothing Then
                Return RedirectToAction("Maintenance", "Home")
            End If

            Dim connStr As String = Util.GetConnectionString
            Dim dc As MeetingRoomDBDataContext = New MeetingRoomDBDataContext(connStr)

            ' ビル情報をインサート
            Try
                dc.InsertBuilding(obj.BuildingName, obj.Disabled)
                dc.SubmitChanges()
            Catch ex As Exception
                Return RedirectToAction("Maintenance", "Home")
            End Try

            ' セッションをクリア
            Session("EditBuilding") = Nothing
            ' メッセージボックスの表示
            Session("MessageBoxTitle") = "ビルの登録"
            Session("MessageBoxMessage") = "ビルの登録が終了しました"
            Return RedirectToAction("MessageBox", "Home")
        Else ' それ以外のときはエラー画面
            Return RedirectToAction("Maintenance", "Home")
        End If
    End Function

    Function ListRoom() As ActionResult
        ' ビル用プルダウンメニューの生成
        Dim buildingItems As List(Of SelectListItem) = New List(Of SelectListItem)()

        Dim connStr As String = Util.GetConnectionString
        Dim dc As MeetingRoomDBDataContext = New MeetingRoomDBDataContext(connStr)

        ' ビルのプルダウンメニューを表示
        Dim buildingInfo As BuildingInfo = New BuildingInfo
        buildingInfo.Building = From t In dc.GetTable(Of Building)() Where t.DISABLED = False Order By t.SEQ_ID Ascending
        Dim SelectBuildingValue As Integer = buildingInfo.Building.First.SEQ_ID

        For Each item In buildingInfo.Building
            buildingItems.Add(New SelectListItem() With {.Text = item.BUILDING_NAME, .Value = item.SEQ_ID})
        Next

        Dim building As SelectList


        building = New SelectList(buildingItems, "Value", "Text", SelectBuildingValue)
        


        ViewData("building") = building

        Return View()
    End Function

    <HttpPost()>
    Function ListRoom(ByVal collection As FormCollection) As ActionResult
        If collection.Item("button") = "検索" Then ' 検索ボタンが押されたとき
            Dim connStr As String = Util.GetConnectionString
            Dim dc As MeetingRoomDBDataContext = New MeetingRoomDBDataContext(connStr)

            Dim list = From t In dc.GetTable(Of Room)() Where t.BUILDING_ID = collection.Item("building") Order By t.SEQ_ID

            ' ビル用プルダウンメニューの生成
            Dim buildingItems As List(Of SelectListItem) = New List(Of SelectListItem)()


            Dim buildingInfo As BuildingInfo = New BuildingInfo
            buildingInfo.Building = From t In dc.GetTable(Of Building)() Where t.DISABLED = False Order By t.SEQ_ID Ascending
            Dim SelectBuildingValue As Integer = buildingInfo.Building.First.SEQ_ID

            For Each item In buildingInfo.Building
                buildingItems.Add(New SelectListItem() With {.Text = item.BUILDING_NAME, .Value = item.SEQ_ID})
            Next

            Dim building As SelectList

            building = New SelectList(buildingItems, "Value", "Text", collection.Item("building"))


            ViewData("building") = building

            Return View(list)

        ElseIf collection.Item("button") = "新規登録" Then ' 新規登録ボタンが押されたとき
            Return RedirectToAction("NewRoom", "Home")
        Else ' それ以外のとき
            Return RedirectToAction("Maintenance", "Home")
        End If

    End Function

    Function EditRoom(ByVal id As String) As ActionResult
        Dim connStr As String = Util.GetConnectionString
        Dim dc As MeetingRoomDBDataContext = New MeetingRoomDBDataContext(connStr)

        Dim obj As EditRoom = TryCast(Session("EditRoom"), EditRoom)

        If obj Is Nothing Then
            Dim items = From t In dc.GetTable(Of Room)() Where t.SEQ_ID = id

            ' 該当するデータが見つからないとき
            If items.Count = 0 Then
                Return RedirectToAction("Maintenance", "Home")
            End If

            Dim item = (From t In items).First

            obj = New EditRoom
            obj.SeqID = id
            obj.RoomName = item.ROOM_NAME
            obj.Comment = item.COMMENT
            obj.BuildingID = item.BUILDING_ID
            obj.StartTime = item.START_TIME
            obj.EndTime = item.END_TIME
            obj.Disabled = item.DISABLED
        End If

        ' ビル用プルダウンメニューの生成
        Dim buildingItems As List(Of SelectListItem) = New List(Of SelectListItem)()

        Dim buildingInfo As BuildingInfo = New BuildingInfo
        buildingInfo.Building = From t In dc.GetTable(Of Building)() Where t.DISABLED = False Order By t.SEQ_ID Ascending
        Dim SelectBuildingValue As Integer = buildingInfo.Building.First.SEQ_ID

        For Each item In buildingInfo.Building
            buildingItems.Add(New SelectListItem() With {.Text = item.BUILDING_NAME, .Value = item.SEQ_ID})

        Next

        Dim building As SelectList


        building = New SelectList(buildingItems, "Value", "Text", obj.BuildingID)


        ViewData("building") = building

        ' 予約時間プルダウンメニューの設定
        Dim reserveStartTimeItems As List(Of SelectListItem) = New List(Of SelectListItem)()
        Dim reserveEndTimeItems As List(Of SelectListItem) = New List(Of SelectListItem)()

        ' 予約可能時間を設定(30分おき)
        For i As Integer = 0 To 24
            For j As Integer = 0 To 59 Step 30
                Dim Time As String = String.Format("{0:00}{1:00}", i, j)
                Dim Time2 As String = String.Format("{0:00}:{1:00}", i, j)

                reserveStartTimeItems.Add(New SelectListItem() With {.Text = Time2, .Value = Time})

                reserveEndTimeItems.Add(New SelectListItem() With {.Text = Time2, .Value = Time})

                If i = 24 AndAlso j = 0 Then
                    j = 100
                End If
            Next
        Next

        Dim reserveStartTime As SelectList

        reserveStartTime = New SelectList(reserveStartTimeItems, "Value", "Text", obj.StartTime)

        ViewData("start_time") = reserveStartTime

        Dim reserveEndTime As SelectList

        reserveEndTime = New SelectList(reserveEndTimeItems, "Value", "Text", obj.EndTime)

        ViewData("end_time") = reserveEndTime

        ' 表示データのセット
        ViewData("seq_id") = obj.SeqID
        ViewData("room_value") = obj.RoomName
        ViewData("comment_value") = obj.Comment

        Return View(obj)
    End Function

    <HttpPost()>
    Function EditRoom(ByVal id As String, ByVal collection As FormCollection) As ActionResult
        If collection.Item("button") = "戻る" Then ' 戻るボタンが押されたとき
            Session("EditRoom") = Nothing
            Return RedirectToAction("ListRoom", "Home")
        ElseIf collection.Item("button") = "確認" Then    ' 確認ボタンが押されたとき
            Dim connStr As String = Util.GetConnectionString
            Dim dc As MeetingRoomDBDataContext = New MeetingRoomDBDataContext(connStr)

            Dim items = From t In dc.GetTable(Of Room)()
                        Join t2 In dc.GetTable(Of Building)() On t.BUILDING_ID Equals t2.SEQ_ID Where t.SEQ_ID = id

            If items.Count = 0 Then
                Return RedirectToAction("Maintenance", "Home")
            End If

            Dim item = (From t In items).First

            'Trim
            collection.Item("room") = collection.Item("room").Trim
            collection.Item("comment") = collection.Item("comment").Trim

            ' オブジェクトの生成
            Dim obj As EditRoom = New EditRoom
            obj.SeqID = id
            obj.RoomName = collection.Item("room")
            obj.Comment = collection.Item("comment")
            obj.BuildingID = collection.Item("building")
            obj.BuildingName = item.t2.BUILDING_NAME
            obj.StartTime = collection.Item("start_time")
            obj.EndTime = collection.Item("end_time")
            obj.Disabled = Request.Form.GetValues("disabled")(0)

            ' バリデーション
            If obj.RoomName = "" Then
                ModelState.AddModelError("", "会議室名は必須です")
            End If

            If obj.RoomName.Length > 40 Then
                ModelState.AddModelError("", "会議室名は４０文字以内で入力してください")
            End If

            If Util.IncludeSpecialCharacter(obj.RoomName) Then
                ModelState.AddModelError("", "会議室名に機種依存文字は使えません")
            End If

            If obj.Comment.Length > 256 Then
                ModelState.AddModelError("", "コメントは256文字以内で入力してください")
            End If

            If Util.IncludeSpecialCharacter(obj.Comment) Then
                ModelState.AddModelError("", "コメントに機種依存文字は使えません")
            End If

            If obj.StartTime >= obj.EndTime Then
                ModelState.AddModelError("", "予約可能時間帯の指定が不正です")
            End If

            Session("EditRoom") = obj

            ' バリデーションエラーが発生したとき再表示を行う
            If Not ModelState.IsValid Then
                Return EditRoom(id)
            End If

            ' 確認画面へ遷移
            Return RedirectToAction("EditRoomConfirm", "Home")
        Else ' それ以外のとき
            Return RedirectToAction("Maintenance", "Home")
        End If

    End Function

    Function EditRoomConfirm() As ActionResult
        Dim obj As EditRoom = TryCast(Session("EditRoom"), EditRoom)

        ' セッションが見つからないとき
        If obj Is Nothing Then
            Return RedirectToAction("Maintenance", "Home")
        End If

        ' 表示データのセット
        ViewData("seq_id") = obj.SeqID.ToString
        ViewData("room") = Util.GetHtmlEncode(obj.RoomName)
        ViewData("comment") = Util.GetHtmlEncode(obj.Comment)
        ViewData("building") = Util.GetHtmlEncode(obj.BuildingName)
        ViewData("start_time") = obj.StartTime.Substring(0, 2) & ":" & obj.StartTime.Substring(2, 2)
        ViewData("end_time") = obj.EndTime.Substring(0, 2) & ":" & obj.EndTime.Substring(2, 2)
        ViewData("disabled") = obj.Disabled

        Return View()
    End Function

    <HttpPost()>
    Function EditRoomConfirm(ByVal collection As FormCollection) As ActionResult
        Dim obj As EditRoom = TryCast(Session("EditRoom"), EditRoom)

        ' セッションが見つからないとき
        If obj Is Nothing Then
            Return RedirectToAction("Maintenance", "Home")
        End If

        If collection.Item("button") = "戻る" Then ' 戻るボタンが押されたとき
            Return RedirectToAction("EditRoom/" & obj.SeqID, "Home")
        ElseIf collection.Item("button") = "保存" Then ' 保存ボタンが押されたとき

            Dim connStr As String = Util.GetConnectionString
            Dim dc As MeetingRoomDBDataContext = New MeetingRoomDBDataContext(connStr)

            ' 会議室情報を保存
            Try
                dc.UpdateRoom(obj.SeqID, obj.RoomName, obj.Comment, obj.BuildingID, obj.StartTime, obj.EndTime, obj.Disabled)
                dc.SubmitChanges()
            Catch ex As Exception
                Return RedirectToAction("Maintenance", "Home")
            End Try

            ' セッションのクリア
            Session("EditRoom") = Nothing
            ' メッセージボックスの表示
            Session("MessageBoxTitle") = "会議室の更新"
            Session("MessageBoxMessage") = "会議室の更新が完了しました"
            Return RedirectToAction("MessageBox", "Home")
        Else ' それ以外のとき
            Return RedirectToAction("Maintenance", "Home")
        End If
    End Function


    Function NewRoom() As ActionResult

        Dim connStr As String = Util.GetConnectionString
        Dim dc As MeetingRoomDBDataContext = New MeetingRoomDBDataContext(connStr)

        Dim obj As NewRoom = TryCast(Session("NewRoom"), NewRoom)


        ' ビル用プルダウンメニューの生成
        Dim buildingItems As List(Of SelectListItem) = New List(Of SelectListItem)()

        Dim buildingInfo As BuildingInfo = New BuildingInfo
        buildingInfo.Building = From t In dc.GetTable(Of Building)() Where t.DISABLED = False Order By t.SEQ_ID Ascending
        Dim SelectBuildingValue As Integer = buildingInfo.Building.First.SEQ_ID

        For Each item In buildingInfo.Building
            buildingItems.Add(New SelectListItem() With {.Text = item.BUILDING_NAME, .Value = item.SEQ_ID})

        Next

        Dim building As SelectList


        If obj Is Nothing Then
            building = New SelectList(buildingItems, "Value", "Text", SelectBuildingValue)
        Else
            building = New SelectList(buildingItems, "Value", "Text", obj.BuildingID)
        End If

        ViewData("building") = building

        ' 予約時間プルダウンメニューの設定
        Dim reserveStartTimeItems As List(Of SelectListItem) = New List(Of SelectListItem)()
        Dim reserveEndTimeItems As List(Of SelectListItem) = New List(Of SelectListItem)()

        ' 予約可能時間を設定(30分おき)
        For i As Integer = 0 To 24
            For j As Integer = 0 To 59 Step 30
                Dim Time As String = String.Format("{0:00}{1:00}", i, j)
                Dim Time2 As String = String.Format("{0:00}:{1:00}", i, j)

                reserveStartTimeItems.Add(New SelectListItem() With {.Text = Time2, .Value = Time})

                reserveEndTimeItems.Add(New SelectListItem() With {.Text = Time2, .Value = Time})

                If i = 24 And j = 0 Then
                    Exit For
                End If
            Next
        Next

        Dim reserveStartTime As SelectList

        If obj Is Nothing Then
            reserveStartTime = New SelectList(reserveStartTimeItems, "Value", "Text", "0000")
        Else
            reserveStartTime = New SelectList(reserveStartTimeItems, "Value", "Text", obj.StartTime)
        End If


        ViewData("start_time") = reserveStartTime

        Dim reserveEndTime As SelectList

        If obj Is Nothing Then
            reserveEndTime = New SelectList(reserveEndTimeItems, "Value", "Text", "0000")
        Else
            reserveEndTime = New SelectList(reserveEndTimeItems, "Value", "Text", obj.EndTime)
        End If


        ViewData("end_time") = reserveEndTime

        If Not obj Is Nothing Then
            ViewData("room_value") = obj.RoomName
            ViewData("comment_value") = obj.Comment
        Else
            obj = New NewRoom
            obj.Disabled = False
        End If

        
        Return View(obj)
    End Function

    <HttpPost()>
    Function NewRoom(ByVal collection As FormCollection) As ActionResult
        If collection.Item("button") = "戻る" Then ' 戻るボタンが押されたとき
            Session("NewRoom") = Nothing
            Return RedirectToAction("ListRoom", "Home")
        ElseIf collection.Item("button") = "確認" Then ' 確認ボタンが押されたとき
            'Trim
            collection.Item("room") = collection.Item("room").Trim
            collection.Item("comment") = collection.Item("comment").Trim

            ' オブジェクトの生成
            Dim obj As NewRoom = New NewRoom
            obj.RoomName = collection.Item("room")
            obj.Comment = collection.Item("comment")
            obj.BuildingID = collection.Item("building")
            obj.StartTime = collection.Item("start_time")
            obj.EndTime = collection.Item("end_time")
            obj.Disabled = Request.Form.GetValues("disabled")(0)

            ' バリデーション
            If obj.RoomName = "" Then
                ModelState.AddModelError("", "会議室名は必須です")
            End If

            If obj.RoomName.Length > 40 Then
                ModelState.AddModelError("", "会議室名は４０文字以内で入力してください")
            End If

            If Util.IncludeSpecialCharacter(obj.RoomName) Then
                ModelState.AddModelError("", "会議室名に機種依存文字は使えません")
            End If

            If obj.Comment.Length > 256 Then
                ModelState.AddModelError("", "コメントは256文字以内で入力してください")
            End If

            If Util.IncludeSpecialCharacter(obj.Comment) Then
                ModelState.AddModelError("", "コメントに機種依存文字は使えません")
            End If

            If obj.StartTime >= obj.EndTime Then
                ModelState.AddModelError("", "予約可能時間帯の指定が不正です")
            End If

            Session("NewRoom") = obj

            ' バリデーションエラーが発生したとき再表示を行う
            If Not ModelState.IsValid Then
                Return NewRoom()
            End If

            ' 確認画面へ遷移
            Return RedirectToAction("NewRoomConfirm", "Home")

        Else ' それ以外のとき
            Return RedirectToAction("Maintenance", "Home")
        End If

        Return View()
    End Function

    Function NewRoomConfirm() As ActionResult
        Dim obj As NewRoom = TryCast(Session("NewRoom"), NewRoom)

        ' セッションが見つからないとき
        If obj Is Nothing Then
            Return RedirectToAction("Maintenance", "Home")
        End If

        Dim connStr As String = Util.GetConnectionString
        Dim dc As MeetingRoomDBDataContext = New MeetingRoomDBDataContext(connStr)

        Dim item As String = (From t In dc.GetTable(Of Building)() Where t.SEQ_ID = obj.BuildingID Select t.BUILDING_NAME).First

        obj.BuildingName = item

        ' 表示データの生成
        ViewData("room") = Util.GetHtmlEncode(obj.RoomName)
        ViewData("comment") = Util.GetHtmlEncode(obj.Comment)
        ViewData("building") = Util.GetHtmlEncode(obj.BuildingName)
        ViewData("start_time") = obj.StartTime.Substring(0, 2) & ":" & obj.StartTime.Substring(2, 2)
        ViewData("end_time") = obj.EndTime.Substring(0, 2) & ":" & obj.EndTime.Substring(2, 2)
        ViewData("disabled") = obj.Disabled

        Return View()
    End Function

    <HttpPost()>
    Function NewRoomConfirm(ByVal collection As FormCollection) As ActionResult
        If collection.Item("button") = "戻る" Then ' 戻るボタンが押されたとき
            Return RedirectToAction("NewRoom", "Home")
        ElseIf collection.Item("button") = "保存" Then ' 保存ボタンが押されたとき
            Dim obj As NewRoom = TryCast(Session("NewRoom"), NewRoom)

            ' セッションが見つからないとき
            If obj Is Nothing Then
                Return RedirectToAction("Maintenance", "Home")
            End If

            Dim connStr As String = Util.GetConnectionString
            Dim dc As MeetingRoomDBDataContext = New MeetingRoomDBDataContext(connStr)

            ' 会議室情報をインサート
            Try
                dc.InsertRoom(obj.RoomName, obj.Comment, obj.BuildingID, obj.StartTime, obj.EndTime, obj.Disabled)
                dc.SubmitChanges()
            Catch ex As Exception
                Return RedirectToAction("Maintenance", "Home")
            End Try

            ' セッションのクリア
            Session("NewRoom") = Nothing
            ' メッセージボックスの表示
            Session("MessageBoxTitle") = "会議室の登録"
            Session("MessageBoxMessage") = "会議室の登録が完了しました"
            Return RedirectToAction("MessageBox", "Home")
        Else ' それ以外のとき
            Return RedirectToAction("Maintenance", "Home")
        End If
    End Function


    Function MessageBox() As ActionResult
        ViewData("MessageBoxTitle") = Session("MessageBoxTitle")
        ViewData("MessageBoxMessage") = Session("MessageBoxMessage")

        Return View()
    End Function

    <HttpPost()>
    Function MessageBox(ByVal collection As FormCollection) As ActionResult
        Session("MessageBoxTitle") = Nothing
        Session("MessageBoxMessage") = Nothing

        Return RedirectToAction("Index", "Home")
    End Function

    Function Maintenance() As ActionResult
        Return View()
    End Function

    Function About() As ActionResult
        Return View()
    End Function
End Class
