﻿Imports MeetingRoom
Imports System.Transactions

Public Class UserController
    Inherits System.Web.Mvc.Controller

    Function UserManager() As ActionResult
        Dim acc As AccountInfo = TryCast(Session("AccountInfo"), AccountInfo)

        If acc Is Nothing Then
            Return RedirectToAction("Maintenance", "Home")
        End If

        Return View()
    End Function

    <HttpPost()>
    Function UserManager(ByVal collection As FormCollection) As ActionResult
        Dim acc As AccountInfo = TryCast(Session("AccountInfo"), AccountInfo)

        If acc Is Nothing Then
            Return RedirectToAction("Maintenance", "Home")
        End If

        If collection("button") = "検索" OrElse collection("button") = "前頁" OrElse collection("button") = "次頁" Then
            collection.Item("operator_id") = collection.Item("operator_id").Trim
            ViewData("operator_id_value") = collection.Item("operator_id")

            Dim connStr As String = Util.GetConnectionString
            Dim dc As MeetingRoomDBDataContext = New MeetingRoomDBDataContext(connStr)
            Dim model As DBModelMstUser = New DBModelMstUser

            Dim page As Integer = If(Session("user_page"), 0)
            If collection("button") = "前頁" Then
                page = page - 1
            ElseIf collection("button") = "次頁" Then
                page = page + 1
            Else
                page = page
            End If
            Session("user_page") = page
            Dim MaxItem As Integer = CInt(Util.GetAppSetting("PageSizeUserList"))
            Dim curPage As Integer = page
            Dim max As Integer = 0

            Try

                ' データを読み込む
                max = (From u In dc.GetTable(Of MstUser)()
                           Where u.OPERATOR_ID.Contains(collection.Item("operator_id"))
                           Order By u.OPERATOR_ID
                           Select New UserData With {
                               .OPERATOR_ID = u.OPERATOR_ID,
                               .OPERATOR_NAME = u.OPERATOR_NAME,
                               .DATE_CREATED = u.DATE_CREATED,
                                .DISABLED = u.DISABLED,
                               .LOCK = u.LOCK
                           }).Count

                model.UserData = (From u In dc.GetTable(Of MstUser)()
                           Where u.OPERATOR_ID.Contains(collection.Item("operator_id"))
                           Order By u.OPERATOR_ID
                           Select New UserData With {
                               .OPERATOR_ID = u.OPERATOR_ID,
                               .OPERATOR_NAME = u.OPERATOR_NAME,
                               .DATE_CREATED = u.DATE_CREATED,
                                .DISABLED = u.DISABLED,
                               .LOCK = u.LOCK
                           }).Skip(curPage * MaxItem).Take(MaxItem)
            Catch ex As Exception
                Return RedirectToAction("Maintenance", "Home")
            End Try
            model.CurrentPage = curPage
            ' 前頁があるとき
            If curPage = 0 Then
                model.HasPrevPage = False
            Else
                model.HasPrevPage = True
            End If
            ' 次頁があるとき
            If curPage * MaxItem + MaxItem < max Then
                model.HasNextPage = True
            Else
                model.HasNextPage = False
            End If

            Return View(model)
        ElseIf collection("button") = "新規登録" Then
            Return RedirectToAction("NewUser", "User")
        Else
            Return View()
        End If

    End Function

    Function EditUser(ByVal id As String) As ActionResult
        Dim acc As AccountInfo = TryCast(Session("AccountInfo"), AccountInfo)

        If acc Is Nothing Then
            Return RedirectToAction("Maintenance", "Home")
        End If

        Dim data As EditUserData = TryCast(Session("EditUserData"), EditUserData)
        Dim connStr As String = Util.GetConnectionString
        Dim dc As MeetingRoomDBDataContext = New MeetingRoomDBDataContext(connStr)

        If data Is Nothing Then

            ' データを読み込む
            Dim userMst = (From r In dc.GetTable(Of MstUser)() Where r.OPERATOR_ID = id).First

            ' オブジェクトに値をセット
            data = New EditUserData
            data.OPERATOR_ID = userMst.OPERATOR_ID
            data.OPERATOR_NAME = userMst.OPERATOR_NAME
            data.DISABLED = userMst.DISABLED
            data.LOCK = userMst.LOCK

            ' ロールに値をセット
            Dim items As List(Of SelectListItem) = New List(Of SelectListItem)()


        End If

        ' データの表示
        ViewData("operator_id_value") = data.OPERATOR_ID
        ViewData("operator_name_value") = data.OPERATOR_NAME

        Return View(data)
    End Function

    <HttpPost()>
    Function EditUser(ByVal id As String, ByVal collection As FormCollection) As ActionResult
        Dim acc As AccountInfo = TryCast(Session("AccountInfo"), AccountInfo)

        If acc Is Nothing Then
            Return RedirectToAction("Maintenance", "Home")
        End If

        If collection("button") = "戻る" Then ' 戻るボタンを押したとき
            Session("EditUserData") = Nothing
            Return RedirectToAction("UserManager", "User")
        Else ' 確認ボタンを押したとき
        

            'Trim
            collection("operator_name") = collection("operator_name").Trim

            ' 再表示
            ViewData("operator_id_value") = id
            ViewData("operator_name") = collection("operator_name")
            Dim data As New EditUserData
            data.OPERATOR_ID = id
            data.OPERATOR_NAME = collection("operator_name")
            ' バリデーション
            Dim hashRole As Hashtable = New Hashtable
            

            data.DISABLED = Request.Form.GetValues("disabled")(0)
            data.LOCK = Request.Form.GetValues("lock")(0)

            If collection("operator_name") = "" Then
                ModelState.AddModelError("", "オペレータ名は必須項目です")
            End If

            If collection("operator_name").Length > 20 Then
                ModelState.AddModelError("", "オペレータ名は20文字以内で入力してください")
            End If

            If Util.IncludeSpecialCharacter(collection("operator_name")) Then
                ModelState.AddModelError("", "オペレータ名に機種依存文字は使えません")
            End If

            If Not ModelState.IsValid Then
                Return View(data)
            End If

            Session("EditUserData") = data

            Return RedirectToAction("EditUserConfirm", "User")
        End If
    End Function

    Function EditUserConfirm() As ActionResult
        Dim acc As AccountInfo = TryCast(Session("AccountInfo"), AccountInfo)

        If acc Is Nothing Then
            Return RedirectToAction("Maintenance", "Home")
        End If



        Dim data As EditUserData = TryCast(Session("EditUserData"), EditUserData)

        If data Is Nothing Then
            Return RedirectToAction("Maintenance", "Home")
        End If

        Dim role As String = ""

        ' データの表示
        ViewData("operator_id") = data.OPERATOR_ID
        ViewData("operator_name") = data.OPERATOR_NAME

        ViewData("lock") = data.LOCK
        ViewData("disabled") = data.DISABLED

        Return View()
    End Function

    <HttpPost()>
    Function EditUserConfirm(ByVal collection As FormCollection) As ActionResult
        Dim acc As AccountInfo = TryCast(Session("AccountInfo"), AccountInfo)

        If acc Is Nothing Then
            Return RedirectToAction("Maintenance", "Home")
        End If

        Dim data As EditUserData = TryCast(Session("EditUserData"), EditUserData)


        If data Is Nothing Then
            Return RedirectToAction("Maintenance", "Home")
        End If

        If collection("button") = "戻る" Then ' 戻るボタンを押したとき
            Return RedirectToAction("EditUser/" & data.OPERATOR_ID, "User")
        Else ' 保存ボタンを押したとき
            Dim connStr As String = Util.GetConnectionString
            Dim dc As MeetingRoomDBDataContext = New MeetingRoomDBDataContext(connStr)

            Using ts = New TransactionScope
                Try
                    ' ユーザマスタの更新
                    dc.updateUserMst(data.OPERATOR_ID, data.OPERATOR_NAME, data.LOCK, data.DISABLED)
                    dc.SubmitChanges()
                    ts.Complete()
                Catch ex As Exception
                    Return RedirectToAction("Maintenance", "Home")
                End Try
            End Using

            ' メッセージボックスの表示
            Session("MessageBoxTitle") = "ユーザ更新完了"
            Session("MessageBoxMessage") = "ユーザ更新が完了しました"

            Session("EditUserData") = Nothing


            Return RedirectToAction("MessageBox", "User")
        End If
    End Function

    Function NewUser() As ActionResult
        Dim acc As AccountInfo = TryCast(Session("AccountInfo"), AccountInfo)

        If acc Is Nothing Then
            Return RedirectToAction("Maintenance", "Home")
        End If

        Dim data As NewUserData = TryCast(Session("NewUserData"), NewUserData)

        Dim connStr As String = Util.GetConnectionString
        Dim dc As MeetingRoomDBDataContext = New MeetingRoomDBDataContext(connStr)


        If Not data Is Nothing Then
            ' 表示データのセット
            ViewData("operator_id_value") = data.OPERATOR_ID
            ViewData("operator_name_value") = data.OPERATOR_NAME

        End If

        Return View()
    End Function

    <HttpPost()>
    Function NewUser(ByVal collection As FormCollection) As ActionResult
        Dim acc As AccountInfo = TryCast(Session("AccountInfo"), AccountInfo)

        If acc Is Nothing Then
            Return RedirectToAction("Maintenance", "Home")
        End If



        If collection("button") = "戻る" Then ' 戻るボタンを押したとき
            Return RedirectToAction("UserManager", "User")
        Else ' 確認ボタンを押したとき
            collection("operator_id") = collection("operator_id").Trim
            collection("operator_name") = collection("operator_name").Trim
            collection("password") = collection("password").Trim
            collection("password2") = collection("password2").Trim

            ViewData("operator_id_value") = collection("operator_id")
            ViewData("operator_name_value") = collection("operator_name")

            Dim hashRole As Hashtable = New Hashtable
            Dim connStr As String = Util.GetConnectionString
            Dim dc As MeetingRoomDBDataContext = New MeetingRoomDBDataContext(connStr)


            ' バリデーション
            If collection("operator_id") = "" Then
                ModelState.AddModelError("", "オペレータIDは必須項目です")
            Else
                Dim user = From t In dc.GetTable(Of MstUser)() Where t.OPERATOR_ID = collection("operator_id")
                If user.Count > 0 Then
                    ModelState.AddModelError("", "オペレータID(" & collection("operator_id") & ")はすでに登録されています")
                End If
            End If

            If Not Util.IsAlphaNumeric(collection("operator_id")) Then
                ModelState.AddModelError("", "オペレータIDは半角英数字で入力してください")
            End If

            If collection("operator_id").Length > 10 Then
                ModelState.AddModelError("", "オペレータIDは10文字以内で入力してください")
            End If

            If collection("operator_name") = "" Then
                ModelState.AddModelError("", "オペレータ名は必須項目です")
            End If

            If collection("operator_name").Length > 20 Then
                ModelState.AddModelError("", "オペレータ名は20文字以内で入力してください")
            End If

            If Util.IncludeSpecialCharacter(collection("operator_name")) Then
                ModelState.AddModelError("", "オペレータ名に機種依存文字は使えません")
            End If

            If collection("password") = "" Then
                ModelState.AddModelError("", "パスワードは必須項目です")
            ElseIf Not Util.ValidatePassword(collection("password")) Then
                ModelState.AddModelError("", "パスワードは半角英数字6文字-20文字で入力してください。また、英大文字、英小文字、数字の3種類の文字を含む必要があります。")
            End If


            If collection("password") <> collection("password2") Then
                ModelState.AddModelError("", "パスワードとパスワード(確認)が異なっています")
            End If

            ' バリデーションエラーが発生したとき
            If Not ModelState.IsValid Then
                Return View()
            End If


            Dim data As New NewUserData
            data.OPERATOR_ID = collection("operator_id")
            data.OPERATOR_NAME = collection("operator_name")
            data.PASSWORD = collection("password")


            Session("NewUserData") = data



            Return RedirectToAction("NewUserConfirm", "User")
        End If
    End Function

    Function NewUserConfirm() As ActionResult
        Dim acc As AccountInfo = TryCast(Session("AccountInfo"), AccountInfo)

        If acc Is Nothing Then
            Return RedirectToAction("Maintenance", "Home")
        End If

        Dim data As NewUserData = TryCast(Session("NewUserData"), NewUserData)

        If data Is Nothing Then
            Return RedirectToAction("Maintenance", "Home")
        End If

        Dim role As String = ""
        ' データの表示
        ViewData("operator_id") = data.OPERATOR_ID
        ViewData("operator_name") = data.OPERATOR_NAME
        ViewData("password") = "**********"

        Return View()
    End Function

    <HttpPost()>
    Function NewUserConfirm(ByVal collection As FormCollection) As ActionResult
        Dim acc As AccountInfo = TryCast(Session("AccountInfo"), AccountInfo)

        If acc Is Nothing Then
            Return RedirectToAction("Maintenance", "Home")
        End If

        Dim data As NewUserData = TryCast(Session("NewUserData"), NewUserData)

        If data Is Nothing Then
            Return RedirectToAction("Maintenance", "Home")
        End If



        If collection("button") = "戻る" Then
            Return RedirectToAction("NewUser", "User")
        ElseIf collection("button") = "保存" Then
            Dim encryptPassword As String = Crypt.EncryptSHA256(data.PASSWORD)

            Dim connStr As String = Util.GetConnectionString
            Dim dc As MeetingRoomDBDataContext = New MeetingRoomDBDataContext(connStr)

            Using ts = New TransactionScope
                Try
                    ' ユーザマスタにインサート
                    dc.insertUserMst(data.OPERATOR_ID, encryptPassword, data.OPERATOR_NAME)

                    dc.SubmitChanges()
                    ts.Complete()
                Catch ex As Exception
                    Return RedirectToAction("Maintenance", "Home")
                End Try
            End Using

            ' メッセージボックスの表示
            Session("MessageBoxTitle") = "ユーザ登録完了"
            Session("MessageBoxMessage") = "ユーザ登録が完了しました"

            Session("NewUserData") = Nothing

            Return RedirectToAction("MessageBox", "User")
        End If
        Return View()
    End Function

    Function PasswordChange(ByVal id As String) As ActionResult
        Dim acc As AccountInfo = TryCast(Session("AccountInfo"), AccountInfo)

        If acc Is Nothing Then
            Return RedirectToAction("Maintenance", "Home")
        End If

        Dim data As PasswordChangeData = TryCast(Session("PasswordChangeData"), PasswordChangeData)
        If data Is Nothing Then
            ViewData("operator_id") = id
        Else
            ViewData("operator_id") = data.OPERATOR_ID
        End If

        Return View()
    End Function

    <HttpPost()>
    Function PasswordChange(ByVal id As String, ByVal collection As FormCollection) As ActionResult
        Dim acc As AccountInfo = TryCast(Session("AccountInfo"), AccountInfo)

        If acc Is Nothing Then
            Return RedirectToAction("Maintenance", "Home")
        End If

        If collection("button") = "戻る" Then ' 戻るボタンを押したとき
            Return RedirectToAction("UserManager", "User")
        ElseIf collection("button") = "確認" Then ' 確認ボタンを押したとき
            collection.Item("password") = collection.Item("password")

            ' バリデーション
            If collection("password") = "" Then
                ModelState.AddModelError("", "パスワードは必須項目です")
            ElseIf Not Util.ValidatePassword(collection("password")) Then
                ModelState.AddModelError("", "パスワードは半角英数字6文字-20文字で入力してください。また、英大文字、英小文字、数字の3種類の文字を含む必要があります。")
            End If


            If collection("password") <> collection("password2") Then
                ModelState.AddModelError("", "パスワードとパスワード(確認)が異なっています")
            End If

            Dim data As PasswordChangeData = New PasswordChangeData
            data.OPERATOR_ID = id
            data.PASSWORD = collection.Item("password")

            Session("PasswordChangeData") = data


            ' バリデーションエラーが発生したとき
            If Not ModelState.IsValid Then
                Return PasswordChange(id)
            End If

           
            Return RedirectToAction("PasswordChangeConfirm", "User")
        End If
        Return View()
    End Function

    Function PasswordChangeConfirm() As ActionResult
        Dim acc As AccountInfo = TryCast(Session("AccountInfo"), AccountInfo)

        If acc Is Nothing Then
            Return RedirectToAction("Maintenance", "Home")
        End If

        Dim data As PasswordChangeData = TryCast(Session("PasswordChangeData"), PasswordChangeData)

        If data Is Nothing Then
            Return RedirectToAction("Maintenance", "Home")
        End If

        ' 表示データの準備
        ViewData("operator_id") = data.OPERATOR_ID
        ViewData("password") = "**********"

        Return View()
    End Function

    <HttpPost()>
    Function PasswordChangeConfirm(ByVal collection As FormCollection) As ActionResult
        Dim acc As AccountInfo = TryCast(Session("AccountInfo"), AccountInfo)

        If acc Is Nothing Then
            Return RedirectToAction("Maintenance", "Home")
        End If

        Dim data As PasswordChangeData = TryCast(Session("PasswordChangeData"), PasswordChangeData)

        If data Is Nothing Then
            Return RedirectToAction("Maintenance", "Home")
        End If

        If collection("button") = "戻る" Then ' 戻るボタンを押したとき
            Return RedirectToAction("PasswordChange/" & data.OPERATOR_ID, "User")
        ElseIf collection("button") = "保存" Then ' 保存ボタンを押したとき
            Dim encryptPassword As String = Crypt.EncryptSHA256(data.PASSWORD)
            Dim connStr As String = Util.GetConnectionString
            Dim dc As MeetingRoomDBDataContext = New MeetingRoomDBDataContext(connStr)

            Try
                ' パスワードの更新
                dc.updatePassword(data.OPERATOR_ID, True, encryptPassword)
                dc.SubmitChanges()
            Catch ex As Exception
                Return RedirectToAction("Maintenance", "Home")
            End Try


            ' メッセージボックスの表示
            Session("MessageBoxTitle") = "パスワード変更完了"
            Session("MessageBoxMessage") = "パスワード変更が完了しました"

            Session("PasswordChangeData") = Nothing
            Return RedirectToAction("MessageBox", "User")
        End If
        Return View()
    End Function

    Function MessageBox() As ActionResult
        ViewData("MessagaBoxTitle") = Session("MessageBoxTitle")
        ViewData("MessageBoxMessage") = Session("MessageBoxMessage")

        Return View()
    End Function

    <HttpPost()>
    Function MessageBox(ByVal collection As FormCollection) As ActionResult
        Session("MessageBoxTitle") = Nothing
        Session("MessageBoxMessage") = Nothing

        Return RedirectToAction("UserManager", "User")
    End Function
End Class
