﻿<%@ Page Title="" Language="VB" MasterPageFile="~/Views/Shared/Site.Master" Inherits="System.Web.Mvc.ViewPage" %>
<%@ Import Namespace="MeetingRoom"  %>
<asp:Content ID="Content1" ContentPlaceHolderID="TitleContent" runat="server">
	予約の確認
</asp:Content>

<asp:Content ID="Content2" ContentPlaceHolderID="MainContent" runat="server">
    <h2>予約の確認</h2>
    <p>
        <%= Html.ValidationSummary%>
    </p>
    <% Using Html.BeginForm()%>
    <table>
        <tr>
            <th>ビル名</th>
            <td><%= Html.DropDownList("building")%></td>
        </tr>
        <tr>
            <th>日付</th>
            <td><%= Html.TextBox("reserve_date", ViewData("reserve_date_value"), New With {.maxlength = "10"})%></td>
        </tr>
    </table>
    <input type="submit" name="button" value="検索" /> 
    <hr />
    <table>
        <tr>
            <td></td>
            <%For i As Integer = 0 To 23%>
                    <td colspan="2"><%= i.ToString & ":00</td>" %></td>
            <%Next%>
    
        </tr>
        <%If Not Model Is Nothing Then%>
        <%For Each item As ReservedInfo In Model%>
        <tr>
            <td>
                <%If item.IsReserved = True Then%>
                <%= Html.ActionLink(item.RoomName, "EditReservation", New With {.id = item.RoomID, .d = item.ReserveDate})%>
                <%Else%>
                <%=item.RoomName %>
                <%End If%>
            </td>
            <%For i As Integer = 0 To 23%>
                <% For j As Integer = 0 To 59 Step 30%>
                    <% Dim tmp As String = String.Format("{0:00}{1:00}", i, j)%>
                    <td>
                        <%If item.ReservedState.Item(tmp) = 1 Then%>
                            <img src="../img/reserve.jpg" alt=""/>
                        <%End If%>
                    </td>
                <%Next%>
            <%Next%>
        </tr>
        <%Next%>
        <%End If%>
    </table>
    <% End Using%>
</asp:Content>
