﻿Imports System.Security.Cryptography
Imports System.Text.Encoding
Imports System.Convert
Imports System.Text

' 暗号化／復号クラス
Public Class Crypt
    ' 3DESで暗号化
    Public Shared Function EncryptTripleDES(ByVal sKey As String, ByVal sIn As String) As String
        Dim DES As New TripleDESCryptoServiceProvider
        Dim hashMD5 As New MD5CryptoServiceProvider
        ' キーのMD5の計算
        DES.Key = hashMD5.ComputeHash(System.Text.ASCIIEncoding.ASCII.GetBytes(sKey))
        ' 暗号化モードを設定
        DES.Mode = CipherMode.ECB
        ' Encryptorの生成
        Dim DESEncrypt As ICryptoTransform = DES.CreateEncryptor()
        ' バイト配列の作成
        Dim Buffer As Byte() = System.Text.ASCIIEncoding.ASCII.GetBytes(sIn)
        ' 暗号化とBase64コードの生成
        Return ToBase64String(DESEncrypt.TransformFinalBlock(Buffer, 0, Buffer.Length))
    End Function

    ' 3DESで復号
    Public Shared Function DecryptTripleDES(ByVal sKey As String, ByVal sOut As String) As String
        Dim DES As New TripleDESCryptoServiceProvider
        Dim hashMD5 As New MD5CryptoServiceProvider
        ' キーのMD5の計算
        DES.Key = hashMD5.ComputeHash(System.Text.ASCIIEncoding.ASCII.GetBytes(sKey))
        ' 暗号化モードを設定
        DES.Mode = CipherMode.ECB
        ' Decryptorの生成
        Dim DESDecrypt As ICryptoTransform = DES.CreateDecryptor()
        ' 復号
        Dim Buffer As Byte() = FromBase64String(sOut)
        Return System.Text.ASCIIEncoding.ASCII.GetString(DESDecrypt.TransformFinalBlock(Buffer, 0, Buffer.Length))
    End Function

    ' 暗号用乱数データの取得
    Public Shared Function CreateKey(ByVal bytes As Integer) As String
        Dim rng As RNGCryptoServiceProvider = New RNGCryptoServiceProvider
        Dim buff(bytes - 1) As Byte

        rng.GetBytes(buff)

        Return BytesToHexString(buff)
    End Function

    ' バイトデータを16進数表記
    Private Shared Function BytesToHexString(ByVal bytes As Byte()) As String
        Dim hexString As StringBuilder = New StringBuilder(64)
        Dim counter As Integer

        For counter = 0 To bytes.Length - 1
            hexString.Append(String.Format("{0:X2}", bytes(counter)))
        Next

        Return hexString.ToString()
    End Function

    'MD5の計算を行う
    Public Shared Function EncryptMD5(ByVal PlainText As String) As String
        Dim MD5Data As Byte() = System.Text.Encoding.UTF8.GetBytes(PlainText)
        Dim Md5 As New MD5CryptoServiceProvider
        Dim Result As Byte() = Md5.ComputeHash(MD5Data)
        Return ToBase64String(Result)
    End Function

    'SHA1の計算を行う
    Public Shared Function EncryptSHA1(ByVal PlainText As String) As String
        Dim SHA1Data As Byte() = System.Text.Encoding.UTF8.GetBytes(PlainText)
        Dim SHA1 As New SHA1CryptoServiceProvider
        Dim Result As Byte() = SHA1.ComputeHash(SHA1Data)
        Return ToBase64String(Result)
    End Function

    'SHA256の計算を行う
    Public Shared Function EncryptSHA256(ByVal PlainText As String) As String
        Dim SHA256Data As Byte() = System.Text.Encoding.UTF8.GetBytes(PlainText)
        Dim SHA256 As New SHA256CryptoServiceProvider
        Dim Result As Byte() = SHA256.ComputeHash(SHA256Data)
        Return ToBase64String(Result)
    End Function
End Class
