﻿<HandleError()> _
Public Class HomeController
    Inherits System.Web.Mvc.Controller

    Function Index() As ActionResult
        ' 現在の日時を取得
        Dim now As DateTime = DateTime.Now
        ' テキストボックスに現在の日付をセット
        ViewData("search_date_value") = now.ToString("yyyy/MM/dd")

        ' データベースから読み込む
        Dim connStr As String = Util.GetConnectionString
        Dim dc As VisitorDBDataContext = New VisitorDBDataContext(connStr)

        Dim list = From t In dc.GetTable(Of Visitor)() Where t.VISITOR_DATE >= now.ToString("yyyy/MM/dd 00:00:00") AndAlso t.VISITOR_DATE < now.AddDays(1).ToString("yyyy/MM/dd 00:00:00") Order By t.VISITOR_DATE Ascending

        Return View(list)
    End Function

    <HttpPost()>
    Function Index(ByVal collection As FormCollection) As ActionResult
        Dim SearchDate As DateTime

        If collection.Item("button") = "本日" Then

            SearchDate = DateTime.Now
        ElseIf collection.Item("button") = "検索" Then
            ' バリデーション
            If collection.Item("search_date") = "" Then
                ModelState.AddModelError("", "日付を入力してください")
            End If

            If Not IsDate(collection.Item("search_date")) Then
                ModelState.AddModelError("", "有効な日付を入力してください")
            End If

            ' バリデーションでエラーになったとき
            If Not ModelState.IsValid Then
                Return View()
            End If

            SearchDate = DateTime.Parse(collection.Item("search_date"))
        End If
        

        ' テキストボックスに現在の日付をセット
        ViewData("search_date_value") = SearchDate.ToString("yyyy/MM/dd")

        ' データベースから読み込む
        Dim connStr As String = Util.GetConnectionString
        Dim dc As VisitorDBDataContext = New VisitorDBDataContext(connStr)

        Dim list = From t In dc.GetTable(Of Visitor)() Where t.VISITOR_DATE >= SearchDate.ToString("yyyy/MM/dd 00:00:00") AndAlso t.VISITOR_DATE < SearchDate.AddDays(1).ToString("yyyy/MM/dd 00:00:00") Order By t.VISITOR_DATE Ascending

        Return View(list)
    End Function

    Function Detail(ByVal id As Integer) As ActionResult
        ' データベースから読み込む
        Dim connStr As String = Util.GetConnectionString
        Dim dc As VisitorDBDataContext = New VisitorDBDataContext(connStr)

        Dim list = From t In dc.GetTable(Of Visitor)() Where t.SEQ_ID = id

        ' 該当データがないときはエラー画面
        If list.Count = 0 Then
            Return RedirectToAction("Maintenance", "Home")
        End If

        Dim item = (From t In list).First

        ' 表示データの生成
        ViewData("seq_id") = item.SEQ_ID
        ViewData("visitor_company") = Util.GetHtmlEncode(item.VISITOR_COMPANY)
        ViewData("visitor_name") = Util.GetHtmlEncode(item.VISITOR_NAME)
        ViewData("visitor_date") = item.VISITOR_DATE.ToString("yyyy/MM/dd HH:mm:ss")
        ViewData("comment") = Util.GetHtmlEncode(item.COMMENT)
        If item.START_DATE Is Nothing Then
            ViewData("start_date") = ""
        Else
            ViewData("start_date") = DateTime.Parse(item.START_DATE).ToString("yyyy/MM/dd HH:mm:ss")
        End If

        If item.END_DATE Is Nothing Then
            ViewData("end_date") = ""
        Else
            ViewData("end_date") = DateTime.Parse(item.END_DATE).ToString("yyyy/MM/dd HH:mm:ss")
        End If

        ViewData("registant_unit") = Util.GetHtmlEncode(item.REGISTRANT_UNIT)
        ViewData("registant_name") = Util.GetHtmlEncode(item.REGISTRANT_NAME)
        ViewData("contact_no") = Util.GetHtmlEncode(item.CONTACT_NO)
        ViewData("create_date") = DateTime.Parse(item.CREATE_DATE).ToString("yyyy/MM/dd HH:mm:ss")

        Return View()
    End Function

    <HttpPost()>
    Function Detail(ByVal id As Integer, ByVal collection As FormCollection) As ActionResult
        If collection.Item("button") = "戻る" Then
            Return RedirectToAction("Index", "Home")
        ElseIf collection.Item("button") = "訪問時間をセット" Then
            ' データベースから読み込む
            Dim connStr As String = Util.GetConnectionString
            Dim dc As VisitorDBDataContext = New VisitorDBDataContext(connStr)

            Dim list = From t In dc.GetTable(Of Visitor)() Where t.SEQ_ID = id

            ' 該当データがないときはエラー画面
            If list.Count = 0 Then
                Return RedirectToAction("Maintenance", "Home")
            End If

            Try
                dc.setStartDate(id)
                dc.SubmitChanges()

            Catch ex As Exception
                Return RedirectToAction("Maintenance", "Home")
            End Try

            Return RedirectToAction("Index", "Home")
        ElseIf collection.Item("button") = "退出時間をセット" Then
            ' データベースから読み込む
            Dim connStr As String = Util.GetConnectionString
            Dim dc As VisitorDBDataContext = New VisitorDBDataContext(connStr)

            Dim list = From t In dc.GetTable(Of Visitor)() Where t.SEQ_ID = id

            ' 該当データがないときはエラー画面
            If list.Count = 0 Then
                Return RedirectToAction("Maintenance", "Home")
            End If

            Try
                dc.setEndDate(id)
                dc.SubmitChanges()

            Catch ex As Exception
                Return RedirectToAction("Maintenance", "Home")
            End Try

            Return RedirectToAction("Index", "Home")
        Else
            Return RedirectToAction("Maintenance", "Home")
        End If

        Return View()
    End Function

    Function Visitor() As ActionResult
        Session("VisitorData") = Nothing

        Return View()
    End Function

    <HttpPost()>
    Function Visitor(ByVal collection As FormCollection) As ActionResult
        If collection.Item("button") = "新規登録" Then
            Return RedirectToAction("NewVisitor", "Home")
        ElseIf collection.Item("button") = "検索" Then
            ' trim
            collection.Item("company") = collection.Item("company").Trim
            collection.Item("from_date") = collection.Item("from_date").Trim
            collection.Item("to_date") = collection.Item("to_date").Trim

            ' 再設定
            ViewData("company_value") = collection.Item("company")
            ViewData("from_date") = collection.Item("from_date")
            ViewData("to_date") = collection.Item("to_date")

            If collection.Item("company") = "" OrElse collection.Item("from_date") = "" OrElse collection.Item("to_date") = "" Then
                ModelState.AddModelError("", "全項目必須項目です")
            Else
                If Not IsDate(collection.Item("from_date")) Then
                    ModelState.AddModelError("", "開始日付は有効な日付を入力してください")
                End If

                If Not IsDate(collection.Item("to_date")) Then
                    ModelState.AddModelError("", "終了日付は有効な日付を入力してください")
                End If
            End If
        

            ' バリデーションでエラーになったとき
            If Not ModelState.IsValid Then
                Return View()
            End If

            ' データベースから読み込み
            Dim connStr As String = Util.GetConnectionString
            Dim dc As VisitorDBDataContext = New VisitorDBDataContext(connStr)

            Dim to_date As DateTime = DateTime.Parse(collection.Item("to_date")).AddDays(1)
            Dim from_date As DateTime = DateTime.Parse(collection.Item("from_date"))

            Dim list = From t In dc.GetTable(Of Visitor)() Where t.VISITOR_COMPANY.Contains(collection.Item("company")) AndAlso t.CREATE_DATE >= from_date AndAlso t.CREATE_DATE < to_date

            Return View(list)
        Else
            Return RedirectToAction("Maintenance", "Home")
        End If
    End Function

    Function NewVisitor() As ActionResult
        Dim data As VisitorData = TryCast(Session("VisitorData"), VisitorData)

        If Not data Is Nothing Then
            ViewData("visitor_company_value") = data.VisitorCompany
            ViewData("visitor_name_value") = data.VisitorName
            ViewData("visitor_date_value") = data.VisitorDate
            ViewData("comment_value") = data.Comment
            ViewData("registant_unit_value") = data.RegistantUnit
            ViewData("registant_name_value") = data.RegistantName
            ViewData("contact_no_value") = data.ContactNo

        End If

        Return View()
    End Function

    <HttpPost()>
    Function NewVisitor(ByVal collection As FormCollection) As ActionResult
        If collection.Item("button") = "確認" Then
            ' Trim
            collection.Item("visitor_company") = collection.Item("visitor_company").Trim
            collection.Item("visitor_name") = collection.Item("visitor_name").Trim
            collection.Item("visitor_date") = collection.Item("visitor_date").Trim
            collection.Item("comment") = collection.Item("comment").Trim
            collection.Item("registant_unit") = collection.Item("registant_unit").Trim
            collection.Item("registant_name") = collection.Item("registant_name").Trim
            collection.Item("contact_no") = collection.Item("contact_no").Trim

            ' オブジェクトを生成
            Dim data As VisitorData = New VisitorData
            data.VisitorCompany = collection.Item("visitor_company")
            data.VisitorName = collection.Item("visitor_name")
            data.VisitorDate = collection.Item("visitor_date")
            data.Comment = collection.Item("comment")
            data.RegistantUnit = collection.Item("registant_unit")
            data.RegistantName = collection.Item("registant_name")
            data.ContactNo = collection.Item("contact_no")

            ' セッションに格納
            Session("VisitorData") = data

            ' バリデーション
            If data.VisitorCompany = "" Then
                ModelState.AddModelError("", "訪問者（会社名）は必須項目です")
            End If

            If data.VisitorCompany.Length > 50 Then
                ModelState.AddModelError("", "訪問者（会社名）は５０文字以内で入力してください")
            End If

            If Util.IncludeSpecialCharacter(data.VisitorCompany) Then
                ModelState.AddModelError("", "訪問者（会社名）に機種依存文字は使えません")
            End If

            If data.VisitorName = "" Then
                ModelState.AddModelError("", "訪問者（名前）は必須項目です")
            End If

            If data.VisitorName.Length > 50 Then
                ModelState.AddModelError("", "訪問者（名前）は５０文字以内で入力してください")
            End If

            If Util.IncludeSpecialCharacter(data.VisitorName) Then
                ModelState.AddModelError("", "訪問者（名前）に機種依存文字は使えません")
            End If

            If data.VisitorDate = "" Then
                ModelState.AddModelError("", "訪問日時は必須項目です")
            End If

            If Not Util.IsYYYYMMDDHHMM(data.VisitorDate) Then
                ModelState.AddModelError("", "訪問日時はYYYY/MM/DD HH:MMの形式で入力してください")
            End If

            ' 日付と時間の形式を判定
            Dim IsValidateForVisitorDate As Boolean = True
            Try
                Dim d As DateTime = DateTime.Parse(data.VisitorDate)
            Catch ex As Exception
                IsValidateForVisitorDate = False
            End Try

            If Not IsValidateForVisitorDate Then
                ModelState.AddModelError("", "訪問日時は有効な日時で入力してください")
            End If


            If Util.IncludeSpecialCharacter(data.Comment) Then
                ModelState.AddModelError("", "コメントに機種依存文字は使えません")
            End If

            If data.Comment.Length > 256 Then
                ModelState.AddModelError("", "コメントは２５６文字以内で入力してください")
            End If

            If data.RegistantUnit = "" Then
                ModelState.AddModelError("", "登録者（部署）は必須項目です")
            End If

            If data.RegistantUnit.Length > 50 Then
                ModelState.AddModelError("", "登録者（部署）は５０文字以内で入力してください")
            End If


            If Util.IncludeSpecialCharacter(data.RegistantUnit) Then
                ModelState.AddModelError("", "登録者（部署）に機種依存文字は使えません")
            End If

            If data.RegistantName = "" Then
                ModelState.AddModelError("", "登録者（名前）は必須項目です")
            End If

            If data.RegistantName.Length > 50 Then
                ModelState.AddModelError("", "登録者（名前）は５０文字以内で入力してください")
            End If

            If Util.IncludeSpecialCharacter(data.RegistantName) Then
                ModelState.AddModelError("", "登録者（名前）に機種依存文字は使えません")
            End If

            If data.ContactNo <> "" AndAlso Not Util.IsContactNo(data.ContactNo) Then
                ModelState.AddModelError("", "コンタクト先（内線番号）は数字,(,),-のみ使えます")
            End If

            If data.ContactNo.Length > 20 Then
                ModelState.AddModelError("", "コンタクト先（内線番号）は２０文字以内で入力してください")
            End If

            If Not ModelState.IsValid Then
                Return NewVisitor()
            End If

            Return RedirectToAction("NewVisitorConfirm", "Home")
        Else
            Return RedirectToAction("Maintenance", "Home")
        End If
    End Function

    Function NewVisitorConfirm() As ActionResult
        Dim data As VisitorData = TryCast(Session("VisitorData"), VisitorData)

        ' セッションが見つからないときはエラー
        If data Is Nothing Then
            Return RedirectToAction("Maintenance", "Home")
        End If

        ViewData("visitor_company") = data.VisitorCompany
        ViewData("visitor_name") = data.VisitorName
        ViewData("visitor_date") = data.VisitorDate
        ViewData("comment") = data.Comment
        ViewData("registant_unit") = data.RegistantUnit
        ViewData("registant_name") = data.RegistantName
        ViewData("contact_no") = data.ContactNo

        Return View()
    End Function

    <HttpPost()>
    Function NewVisitorConfirm(ByVal collection As FormCollection) As ActionResult
        Dim data As VisitorData = TryCast(Session("VisitorData"), VisitorData)

        ' セッションが見つからないときはエラー
        If data Is Nothing Then
            Return RedirectToAction("Maintenance", "Home")
        End If

        If collection.Item("button") = "戻る" Then
            Return RedirectToAction("NewVisitor", "Home")
        ElseIf collection.Item("button") = "保存" Then
            ' データベースへの登録
            Dim connStr As String = Util.GetConnectionString
            Dim dc As VisitorDBDataContext = New VisitorDBDataContext(connStr)

            Try
                dc.InsertVisitor(data.VisitorCompany, data.VisitorName, DateTime.Parse(data.VisitorDate), data.Comment, data.RegistantName, data.RegistantUnit, data.ContactNo)
                dc.SubmitChanges()
            Catch ex As Exception
                Return RedirectToAction("Maintenance", "Home")
            End Try

            ' セッションのクリア
            Session("VisitorData") = Nothing

            ' メッセージボックスの表示
            Session("MessageBoxTitle") = "登録完了"
            Session("MessageBoxMessage") = "訪問者の登録が完了しました"
            Return RedirectToAction("MessageBox", "Home")
        Else
            Return RedirectToAction("Maintenance", "Home")
        End If
    End Function

    Function Maintenance() As ActionResult
        Session.Clear()
        Return View()
    End Function

    Function MessageBox() As ActionResult
        ViewData("MessageBoxTitle") = Session("MessageBoxTitle")
        ViewData("MessageBoxMessage") = Session("MessageBoxMessage")

        Return View()
    End Function

    <HttpPost()>
    Function MessageBox(ByVal collection As FormCollection) As ActionResult
        Session("MessageBoxTitle") = Nothing
        Session("MessageBoxMessage") = Nothing

        Return RedirectToAction("Index", "Home")
    End Function

    Function About() As ActionResult
        Return View()
    End Function
End Class
