﻿<%@ Page Language="VB" MasterPageFile="~/Views/Shared/Site.Master" Inherits="System.Web.Mvc.ViewPage" %>
<%@ Import Namespace="VisitorManagementSystem" %>
<asp:Content ID="indexTitle" ContentPlaceHolderID="TitleContent" runat="server">
    ホーム ページ
</asp:Content>

<asp:Content ID="indexContent" ContentPlaceHolderID="MainContent" runat="server">
    <h2>訪問者一覧</h2>
    <p>
        <%= Html.ValidationSummary%>
    </p>
    <% Using Html.BeginForm()%>
    日付：<%= Html.TextBox("search_date", ViewData("search_date_value"), New With {.maxlength = "10"})%><input type="submit" name="button" value="検索" /><input type="submit" name="button" value="本日" />
    <% End Using%>
    <hr />
     <%If Not Model Is Nothing Then%>
    <table>
        <tr>
            <td></td>
            <td>訪問予定時間</td>
            <td>訪問者</td>
            <td>訪問時間</td>
            <td>退出時間</td>
        </tr>
        <%For Each item In Model%>
         <tr>
            <td><%= Html.ActionLink("詳細", "Detail", New With {.id = item.SEQ_ID})%></td>
            <td><%= DateTime.Parse(item.VISITOR_DATE).ToString("HH:mm")%></td>
            <td><%= Util.GetHtmlEncode(item.VISITOR_NAME)%>(<%= Util.GetHtmlEncode(item.VISITOR_COMPANY)%>)</td>
            <td><%= item.START_DATE%></td>
            <td><%= item.END_DATE%></td>
        </tr>
        <%Next%>
    </table>
    <%End If%>
</asp:Content>
