﻿<%@ Page Title="" Language="VB" MasterPageFile="~/Views/Shared/Site.Master" Inherits="System.Web.Mvc.ViewPage" %>
<%@ Import Namespace="VisitorManagementSystem" %>

<asp:Content ID="Content1" ContentPlaceHolderID="TitleContent" runat="server">
	訪問者登録
</asp:Content>

<asp:Content ID="Content2" ContentPlaceHolderID="MainContent" runat="server">

    <h2>訪問者登録</h2>
    <p>
        <%= Html.ValidationSummary%>
    </p>
    <% Using Html.BeginForm()%>
    <p>会社名：<%= Html.TextBox("company", ViewData("company_value"), New With {.maxlength = "50"})%> </p>
    <p>登録日付：<%= Html.TextBox("from_date", ViewData("from_date_value"), New With {.maxlength = "10"})%> ～<%= Html.TextBox("to_date", ViewData("to_date_value"), New With {.maxlength = "10"})%>(YYYY/MM/DD形式) </p>
    <p><input type="submit" name="button" value="検索" /><input type="submit" name="button" value="新規登録" /></p>
    <%End Using%>
     <%If Not Model Is Nothing Then%>
     <hr />
    <table>
        <tr>
            <td>訪問時間</td>
            <td>訪問者</td>
            <td>コメント</td>
            <td>登録者</td>
            <td>登録日時</td>
        </tr>
        <%For Each item In Model%>
         <tr>
            <td><%= DateTime.Parse(item.VISITOR_DATE).ToString("yyyy/MM/dd HH:mm")%></td>
            <td> <%= Util.GetHtmlEncode(item.VISITOR_NAME)%>(<%= Util.GetHtmlEncode(item.VISITOR_COMPANY)%>)</td>
            <td><%= Util.GetHtmlEncode(item.COMMENT)%></td>
            <td> <%= Util.GetHtmlEncode(item.REGISTRANT_NAME)%>(<%= Util.GetHtmlEncode(item.REGISTRANT_UNIT)%>)</td>
            <td><%= DateTime.Parse(item.CREATE_DATE).ToString("yyyy/MM/dd HH:mm:ss")%></td>
        </tr>
        <%Next%>
    </table>
    <%End If%>
</asp:Content>
