﻿Imports System.Transactions

Public Class ApplWebAPI
    Public Function GetSearchResult(ByVal id As Integer?, ByVal kihon1 As String, ByVal kihon2 As String, ByVal kihon3 As String, ByVal kihon4 As String) As List(Of clsSearchResult)
        Using db = New WebAPIEntities()
            Dim q = (From k In db.KIHON_DATA Join m In db.MEISAI_DATA On k.KIHON_SEQ Equals m.KIHON_SEQ Order By m.MEISAI_SEQ)

            If Not id Is Nothing Then
                q = q.Where(Function(f) f.m.MEISAI_SEQ = id)
            End If

            If String.IsNullOrEmpty(kihon1) = False Then
                q = q.Where(Function(f) f.k.KIHON1.Contains(kihon1))
            End If
            If String.IsNullOrEmpty(kihon2) = False Then
                q = q.Where(Function(f) f.k.KIHON2.Contains(kihon2))
            End If
            If String.IsNullOrEmpty(kihon3) = False Then
                q = q.Where(Function(f) f.k.KIHON3.Contains(kihon3))
            End If
            If String.IsNullOrEmpty(kihon4) = False Then
                q = q.Where(Function(f) f.k.KIHON4.Contains(kihon4))
            End If

            Dim result As New List(Of clsSearchResult)
            For Each d In q
                Dim cls As New clsSearchResult

                cls.KIHON_SEQ = d.k.KIHON_SEQ
                cls.MEISAI_SEQ = d.m.MEISAI_SEQ
                cls.KIHON1 = d.k.KIHON1
                cls.KIHON2 = d.k.KIHON2
                cls.KIHON3 = d.k.KIHON3
                cls.KIHON4 = d.k.KIHON4

                result.Add(cls)
            Next

            Return result

        End Using


    End Function

    Public Function GetData(ByVal id As Integer) As clsKihonData
        Using db = New WebAPIEntities()
            Dim q1 = (From k In db.KIHON_DATA Where k.KIHON_SEQ = id).FirstOrDefault

            Dim q2 = (From m In db.MEISAI_DATA Where m.KIHON_SEQ = id Order By m.MEISAI_SEQ)

            Dim kihon As New clsKihonData
            kihon.KIHON_SEQ = q1.KIHON_SEQ
            kihon.KIHON1 = q1.KIHON1
            kihon.KIHON2 = q1.KIHON2
            kihon.KIHON3 = q1.KIHON3
            kihon.KIHON4 = q1.KIHON4
            kihon.MEISAI = New List(Of clsMeisaiData)()
            For Each q In q2
                Dim meisai As New clsMeisaiData
                meisai.KIHON_SEQ = q.KIHON_SEQ
                meisai.MEISAI_SEQ = q.MEISAI_SEQ
                meisai.MEISAI1 = q.MEISAI1
                meisai.MEISAI2 = q.MEISAI2
                meisai.MEISAI3 = q.MEISAI3
                meisai.MEISAI4 = q.MEISAI4

                kihon.MEISAI.Add(meisai)

            Next

            Return kihon
        End Using
    End Function

    Public Sub PostData(ByVal cls As clsKihonData)
        Using ts = New TransactionScope
            Using db = New WebAPIEntities()
                Dim recordKihon As New KIHON_DATA
                recordKihon.KIHON1 = cls.KIHON1
                recordKihon.KIHON2 = cls.KIHON2
                recordKihon.KIHON3 = cls.KIHON3
                recordKihon.KIHON4 = cls.KIHON4
                db.KIHON_DATA.Add(recordKihon)
                db.SaveChanges()
                Dim KIHON_SEQ As Integer = recordKihon.KIHON_SEQ

                For Each meisai As clsMeisaiData In cls.MEISAI
                    Dim recordMeisai As New MEISAI_DATA
                    recordMeisai.KIHON_SEQ = KIHON_SEQ
                    recordMeisai.MEISAI1 = meisai.MEISAI1
                    recordMeisai.MEISAI2 = meisai.MEISAI2
                    recordMeisai.MEISAI3 = meisai.MEISAI3
                    recordMeisai.MEISAI4 = meisai.MEISAI4
                    db.MEISAI_DATA.Add(recordMeisai)
                Next

                db.SaveChanges()
            End Using

            ts.Complete()
        End Using
    End Sub

    Public Sub PutData(ByVal cls As clsKihonData)
        Using ts = New TransactionScope
            Using db = New WebAPIEntities()
                Dim recordKihon As New KIHON_DATA

                recordKihon = (From k In db.KIHON_DATA Where k.KIHON_SEQ = cls.KIHON_SEQ).FirstOrDefault
                recordKihon.KIHON1 = cls.KIHON1
                recordKihon.KIHON2 = cls.KIHON2
                recordKihon.KIHON3 = cls.KIHON3
                recordKihon.KIHON4 = cls.KIHON4

                For Each meisai As clsMeisaiData In cls.MEISAI
                    Dim recordMeisai As New MEISAI_DATA

                    If meisai.STATUS = "ADD" Then
                        recordMeisai = New MEISAI_DATA
                        recordMeisai.KIHON_SEQ = recordKihon.KIHON_SEQ
                        recordMeisai.MEISAI1 = meisai.MEISAI1
                        recordMeisai.MEISAI2 = meisai.MEISAI2
                        recordMeisai.MEISAI3 = meisai.MEISAI3
                        recordMeisai.MEISAI4 = meisai.MEISAI4
                        db.MEISAI_DATA.Add(recordMeisai)
                    ElseIf meisai.STATUS = "MOD" Then
                        recordMeisai = (From m In db.MEISAI_DATA Where m.KIHON_SEQ = meisai.KIHON_SEQ AndAlso m.MEISAI_SEQ = meisai.MEISAI_SEQ).FirstOrDefault
                        recordMeisai.MEISAI1 = meisai.MEISAI1
                        recordMeisai.MEISAI2 = meisai.MEISAI2
                        recordMeisai.MEISAI3 = meisai.MEISAI3
                        recordMeisai.MEISAI4 = meisai.MEISAI4
                    Else
                        recordMeisai = (From m In db.MEISAI_DATA Where m.KIHON_SEQ = meisai.KIHON_SEQ AndAlso m.MEISAI_SEQ = meisai.MEISAI_SEQ).FirstOrDefault
                        db.MEISAI_DATA.Remove(recordMeisai)
                    End If
                Next

                db.SaveChanges()
            End Using
            ts.Complete()
        End Using
    End Sub

    Public Sub DeleteData(ByVal id As Integer)
        Using ts = New TransactionScope
            Using db = New WebAPIEntities()
                Dim q1 = (From k In db.KIHON_DATA Where k.KIHON_SEQ = id).FirstOrDefault

                db.KIHON_DATA.Remove(q1)

                Dim q2 = (From m In db.MEISAI_DATA Where m.KIHON_SEQ = id Order By m.MEISAI_SEQ)

                For Each q In q2
                    db.MEISAI_DATA.Remove(q)
                Next

                db.SaveChanges()
            End Using
            ts.Complete()
        End Using
    End Sub
End Class
