﻿Imports System.IO
Imports System.Text

Public Class frmMain

    Private Sub btClose_Click(sender As System.Object, e As System.EventArgs) Handles btClose.Click
        Me.Close()
    End Sub

    Private Sub btOpenFile_Click(sender As System.Object, e As System.EventArgs) Handles btOpenFile.Click
        Me.OpenFileDialog1.Filter = "CSVファイル(*.csv)|*.csv|すべてのファイル(*.*)|*.*"
        If OpenFileDialog1.ShowDialog() = DialogResult.OK Then
            'OKボタンがクリックされたとき
            Me.tbOpenFile.Text = OpenFileDialog1.FileName
        End If
    End Sub

    Private Sub btSaveFile_Click(sender As System.Object, e As System.EventArgs) Handles btSaveFile.Click
        Me.SaveFileDialog1.Filter = "xmlファイル(*.xml)|*.xml|すべてのファイル(*.*)|*.*"
        If SaveFileDialog1.ShowDialog() = DialogResult.OK Then
            'OKボタンがクリックされたとき
            Me.tbSaveFile.Text = SaveFileDialog1.FileName
        End If
    End Sub

    Private Sub btConvert_Click(sender As System.Object, e As System.EventArgs) Handles btConvert.Click
        Me.btConvert.Enabled = False
        Dim sr As StreamReader
        Dim line As String = ""
        Dim array As Array = Nothing
        Dim PostalCode As ArrayList = New ArrayList

        ' Postalデータを読み込む
        sr = New StreamReader(Me.tbOpenFile.Text, System.Text.Encoding.GetEncoding("Shift_JIS"))

        Try
            ' ファイルの終わりまで
            While Not sr.EndOfStream
                ' １行読み込む
                line = sr.ReadLine
                ' ,で分割する
                array = line.Split(",")

                ' 各カラムの"をはずす
                For i As Integer = 0 To array.Length - 1
                    If array(i).ToString.StartsWith("""") Then
                        array(i) = array(i).ToString.Substring(1)
                    End If
                    If array(i).ToString.EndsWith("""") Then
                        array(i) = array(i).ToString.Substring(0, array(i).ToString.Length - 1)
                    End If

                    array(i) = array(i).ToString.Trim
                Next

                ' アドレスオブジェクトの生成と初期化
                Dim add As Address = New Address
                add.PostalCode = array(2)
                add.KanaPref = array(3)
                add.KanaCity = array(4)
                add.KanaTown = array(5)
                add.KanjiPref = array(6)
                add.KanjiCity = array(7)
                add.KanjiTown = array(8)

                ' (以降を削除する
                If add.KanaTown.IndexOf("(") > 0 Then
                    add.KanaTown = add.KanaTown.Substring(0, add.KanaTown.IndexOf("("))
                End If

                ' （以降を削除する
                If add.KanjiTown.IndexOf("（") > 0 Then
                    add.KanjiTown = add.KanjiTown.Substring(0, add.KanjiTown.IndexOf("（"))
                End If

                ' ｲｶﾆｹｲｻｲｶﾞﾅｲﾊﾞｱｲを削除する
                If add.KanaTown = "ｲｶﾆｹｲｻｲｶﾞﾅｲﾊﾞｱｲ" Then
                    add.KanaTown = ""
                End If

                ' 以下に掲載がない場合を削除する
                If add.KanjiTown = "以下に掲載がない場合" Then
                    add.KanjiTown = ""
                End If

                'add.KanaPref = StrConv(add.KanaPref, VbStrConv.Wide)
                'add.KanaCity = StrConv(add.KanaCity, VbStrConv.Wide)
                'add.KanaTown = StrConv(add.KanaTown, VbStrConv.Wide)

                ' ArrayListにアドレスデータを加える
                PostalCode.Add(add)
            End While

        Catch ex As Exception
        Finally
            Me.btConvert.Enabled = True
            Try
                sr.Close()
            Catch ex As Exception

            End Try
            sr = Nothing
        End Try

        ' XMLに変換する
        Me.btConvert.Enabled = False
        Dim sw As StreamWriter = New StreamWriter(Me.tbSaveFile.Text, False, System.Text.Encoding.GetEncoding("UTF-8"))
        Try

            sw.WriteLine("<?xml version=""1.0"" encoding=""utf-8"" ?>")
            sw.WriteLine("<data>")

            For Each item As Address In PostalCode
                sw.WriteLine("<address>")
                sw.WriteLine("<postalcode>" & item.PostalCode & "</postalcode>")
                sw.WriteLine("<address1>" & item.KanjiPref & "</address1>")
                sw.WriteLine("<address2>" & item.KanjiCity & "</address2>")
                sw.WriteLine("<address3>" & item.KanjiTown & "</address3>")
                sw.WriteLine("</address>")

            Next

            sw.WriteLine("</data>")
        Catch ex As Exception
        Finally
            Try
                sw.Close()
            Catch ex As Exception

            End Try
            sw = Nothing
            Me.btConvert.Enabled = True
        End Try

    End Sub
End Class
