<?php

class WebFormController extends AppController {
	public $name = 'WebForm';
	public $uses = "RequestData";
	public $layout = 'web_form';
	
	var $components = array('RequestHandler');

	function index(){
	}

	function entry(){
		// ライブラリをインポートする
		App::import('Lib', 'EntryData');
		App::import('Lib', 'Util');

		$this->set("errorMessage", "");

		// 確認画面から戻ったときは再表示する
		if($this->Session->check('isBack') && $this->Session->read('isBack') === true){
			$entry = unserialize($this->Session->read('entry'));
			
			$this->data['entry']['sei_kanji'] = $entry->seiKanji;
			$this->data['entry']['mei_kanji'] = $entry->meiKanji;
			$this->data['entry']['sei_kana'] = $entry->seiKana;
			$this->data['entry']['mei_kana'] = $entry->meiKana;
			$this->data['entry']['birth_year'] = $entry->birthDateYear;
			$this->data['entry']['birth_month'] = $entry->birthDateMonth;
			$this->data['entry']['birth_day'] = $entry->birthDateDay;
			$this->data['entry']['gender'] = $entry->gender;
			$this->data['entry']['zip1'] = $entry->zip1;
			$this->data['entry']['zip2'] = $entry->zip2;
			$this->data['entry']['address1'] = $entry->address1;
			$this->data['entry']['address2'] = $entry->address2;
			$this->data['entry']['address3'] = $entry->address3;
			$this->data['entry']['address4'] = $entry->address4;
			$this->data['entry']['tel1'] = $entry->tel1;
			$this->data['entry']['tel2'] = $entry->tel2;
			$this->data['entry']['tel3'] = $entry->tel3;
			$this->data['entry']['m_tel1'] = $entry->mTel1;
			$this->data['entry']['m_tel2'] = $entry->mTel2;
			$this->data['entry']['m_tel3'] = $entry->mTel3;
			$this->data['entry']['e_mail1'] = $entry->email;
			$this->data['entry']['e_mail2'] = $entry->email;
			$this->data['entry']['occupation'] = $entry->occupation;

			$this->Session->write('isBack', false);
		}
		
		if(isset($this->params["form"]["next"])) {
			// EntryDataオブジェクトを生成
			$entry = New EntryData();
			
			// entryデータを取得
			$obj = $this->data['entry'];
			
			// 入力データをオブジェクトにセット
			
			$entry->seiKanji = $obj['sei_kanji'];
			$entry->meiKanji = $obj['mei_kanji'];
			$entry->seiKana = $obj['sei_kana'];
			$entry->meiKana = $obj['mei_kana'];
			
			
			// 0でパディング
			$year = Util::zeroPadding($obj['birth_year'], 4);
			$month = Util::zeroPadding($obj['birth_month'], 2);
			$day = Util::zeroPadding($obj['birth_day'], 2);
			
			$entry->birthDateYear = $year;
			$entry->birthDateMonth = $month;
			$entry->birthDateDay = $day;
			$entry->gender = $obj['gender'];
			// 範囲外の値がPOSTされたときはメインテナンス画面へ
			try {
				$entry->genderText = $entry->convertGender($entry->gender);
			} catch (Exception $e){
				$this->redirect("./maintenance");
			}
			$entry->zip1 = $obj['zip1'];
			$entry->zip2 = $obj['zip2'];
			$entry->address1 = $obj['address1'];
			$entry->address2 = $obj['address2'];
			$entry->address3 = $obj['address3'];
			$entry->address4 = $obj['address4'];
			$entry->tel1 = $obj['tel1'];
			$entry->tel2 = $obj['tel2'];
			$entry->tel3 = $obj['tel3'];
			$entry->mTel1 = $obj['m_tel1'];
			$entry->mTel2 = $obj['m_tel2'];
			$entry->mTel3 = $obj['m_tel3'];
			$entry->email = $obj['e_mail1'];
			$entry->email2 = $obj['e_mail2'];
			$entry->occupation = $obj['occupation'];
			// 範囲外の値がPOSTされたときはメインテナンス画面へ
			try{
				$entry->occupationText = $entry->convertOccupation($entry->occupation);
			} catch (Exception $e){
				$this->redirect("./maintenance");
			}

			$entry->ipAddress = $this->RequestHandler->getClientIP();
			$entry->sessionId = $this->Session->id();

			// バリデーション実行
			$entry->valid();
			
			// バリデーションエラーが発生したら画面にエラーを表示
			if($entry->isValid()){
				$err = "<div class='validation-erros'>";
				for($i = 0; $i < count($entry->errorMessage); $i++){
					$err .= "・ ". $entry->errorMessage[$i] . "<br />";
				}
				$err .= "</div>";
				$this->set("errorMessage", $err);
			} else {
				// セッションにエントリーデータを格納
				$this->Session->write('entry', serialize($entry));

				// 確認画面に遷移
				$this->redirect("./confirm");
			}
		}
	}
	
	function confirm(){
		// ライブラリをインポートする
		App::import('Lib', 'EntryData');

		// オブジェクトにセッションをセット
		$entry = unserialize($this->Session->read('entry'));

		// オブジェクトが見つからないときはエントリ画面へ
		if(!$this->Session->check('entry')){
			$this->redirect("./entry");
		}
		
		// pr($entry);
		$this->set("sei_kanji", htmlspecialchars($entry->seiKanji));
		$this->set("mei_kanji", htmlspecialchars($entry->meiKanji));
		$this->set("sei_kana", htmlspecialchars($entry->seiKana));
		$this->set("mei_kana", htmlspecialchars($entry->meiKana));
		$this->set("birth_year", htmlspecialchars($entry->birthDateYear));
		$this->set("birth_month", htmlspecialchars($entry->birthDateMonth));
		$this->set("birth_day", htmlspecialchars($entry->birthDateDay));
		$this->set("gender", htmlspecialchars($entry->genderText));
		$this->set("zip1", htmlspecialchars($entry->zip1));
		$this->set("zip2", htmlspecialchars($entry->zip2));
		$this->set("address1", htmlspecialchars($entry->address1));
		$this->set("address2", htmlspecialchars($entry-> address2));
		$this->set("address3", htmlspecialchars($entry->address3));
		$this->set("address4", htmlspecialchars($entry->address4));
		if ($entry->tel1 !== ""){
			$this->set("tel", htmlspecialchars($entry->tel1) . "-" . htmlspecialchars($entry->tel2) . "-" . htmlspecialchars($entry->tel3));
		} else {
			$this->set("tel", "");
		}
		if ($entry->mTel1 !== ""){
			$this->set("m_tel", htmlspecialchars($entry->mTel1) . "-" . htmlspecialchars($entry->mTel2) . "-" . htmlspecialchars($entry->mTel3));
		} else {
			$this->set("m_tel", "");
		}
		
		$this->set("e_mail", htmlspecialchars($entry->email));
		$this->set("occupation", htmlspecialchars($entry->occupationText));

		if(isset($this->params["form"]["next"])) {	// 次へボタン
			// データベースへの書き込み
			$this->RequestData->insertRequest($entry);
			
			// 完了画面へ遷移
			$this->redirect("./thankyou");
		} elseif(isset($this->params["form"]["back"])) { // 戻るボタン
			// 確認画面へ遷移
			$this->Session->write('isBack', true); 
			$this->redirect("./entry");
		}
	}

	function thankyou(){
		// ライブラリをインポートする
		App::import('Lib', 'EntryData');

		// オブジェクトにセッションをセット
		$entry = unserialize($this->Session->read('entry'));

		// オブジェクトが見つからないときはエントリ画面へ
		if(!$this->Session->check('entry')){
			$this->redirect("./entry");
		}
		// セッションのクリア
		$this->Session->destroy();
	}

	function maintenance(){
		// セッションのクリア
		$this->Session->destroy();
	}
}

?>