<?php

class EntryData {
	public $seiKanji;
	public $meiKanji;
	public $seiKana;
	public $meiKana;
	public $birthDateYear;
	public $birthDateMonth;
	public $birthDateDay;
	public $gender;
	public $genderText;
	public $zip1;
	public $zip2;
	public $address1;
	public $address2;
	public $address3;
	public $address4;
	public $tel1;
	public $tel2;
	public $tel3;
	public $mTel1;
	public $mTel2;
	public $mTel3;
	public $email;
	public $email2;
	public $occupation;
	public $occupationText;
	public $ipAddress;
	public $sessionId;

	public $isValid = false;
	public $errorMessage = array();
	
	private $constGender = array("" => "", 
								"1" => "男", 
								"2" => "女");
	private $constOccupation = array("" => "", 
									'1' => "会社員", 
									'2' => "公務員",
									'3' => '会社役員',
									'4' => '自営業',
									'5' => '農林水産業',
									'6' => '自由業',
									'7' => 'パートタイマー',
									'8' => '主婦',
									'9' => 'その他',
									'10' => '無職'
									);

	// 性別を文字列にコンバートする
	public function convertGender($value){
		if(isset($this->constGender[$value])){
			$str = $this->constGender[$value];
		} else {
			throw new Exception("配列範囲外エラー");
		}

		return $str;
	}

	// 職業をコンバートする
	public function convertOccupation($value){
		if(isset($this->constOccupation[$value])){
			$str = $this->constOccupation[$value];
		} else {
			throw new Exception("配列範囲外エラー");
		}

		return $str;
	}
	
	// バリデーションを行う
	public function valid(){
		App::import('Lib', 'Util');

		// 姓（漢字） check
		if($this->seiKanji === ""){
			$this->isValid = true;
			$this->errorMessage[] = "姓（漢字）を入力してください。";
		}

		if(strlen($this->seiKanji) > 20){
			$this->isValid = true;
			$this->errorMessage[] = "姓（漢字）は２０文字以内で入力してください。";
		}

		if(Util::includeHarfCharacter($this->seiKanji)){
			$this->isValid = true;
			$this->errorMessage[] = "姓（漢字）に半角文字は使えません。";
		}

		if(Util::includeZenAlphabet($this->seiKanji)){
			$this->isValid = true;
			$this->errorMessage[] = "姓（漢字）に全角アルファベットは使えません。";
		}

		if(Util::includeZenNumeric($this->seiKanji)){
			$this->isValid = true;
			$this->errorMessage[] = "姓（漢字）に全角数字は使えません。";
		}

		if(Util::includeSpecialCharacter($this->seiKanji)){
			$this->isValid = true;
			$this->errorMessage[] = "姓（漢字）に機種依存文字は使えません。";
		}


		// 名（漢字） check
		if($this->meiKanji === ""){
			$this->isValid = true;
			$this->errorMessage[] = "名（漢字）を入力してください。";
		}

		if(strlen($this->meiKanji) > 20){
			$this->isValid = true;
			$this->errorMessage[] = "名（漢字）は２０文字以内で入力してください。";
		}

		if(Util::includeHarfCharacter($this->meiKanji)){
			$this->isValid = true;
			$this->errorMessage[] = "名（漢字）に半角文字は使えません。";
		}

		if(Util::includeZenAlphabet($this->meiKanji)){
			$this->isValid = true;
			$this->errorMessage[] = "名（漢字）に全角アルファベットは使えません。";
		}

		if(Util::includeZenNumeric($this->meiKanji)){
			$this->isValid = true;
			$this->errorMessage[] = "名（漢字）に全角数字は使えません。";
		}

		if(Util::includeSpecialCharacter($this->meiKanji)){
			$this->isValid = true;
			$this->errorMessage[] = "名（漢字）に機種依存文字は使えません。";
		}
		
		// 姓（カナ） check
		if($this->seiKana === ""){
			$this->isValid = true;
			$this->errorMessage[] = "姓（カナ）を入力してください。";
		}
		if(strlen($this->seiKana) > 20){
			$this->isValid = true;
			$this->errorMessage[] = "姓（カナ）は２０文字以内で入力してください。";
		}
		if($this->seiKana !== "" && !Util::isKatakana($this->seiKana)){
			$this->isValid = true;
			$this->errorMessage[] = "姓（カナ）はカタカナで入力してください。";
		}

		// 名（カナ） check
		if($this->meiKana === ""){
			$this->isValid = true;
			$this->errorMessage[] = "名（カナ）を入力してください。";
		}
		if(strlen($this->meiKana) > 20){
			$this->isValid = true;
			$this->errorMessage[] = "名（カナ）は２０文字以内で入力してください。";
		}
		if($this->meiKana !== "" && !Util::isKatakana($this->meiKana)){
			$this->isValid = true;
			$this->errorMessage[] = "名（カナ）はカタカナで入力してください。";
		}

		// 生年月日（年） check
		if($this->birthDateYear === ""){
			$this->isValid = true;
			$this->errorMessage[] = "生年月日（年）を入力してください。";
		}
		
		// 生年月日（月） check
		if($this->birthDateMonth === ""){
			$this->isValid = true;
			$this->errorMessage[] = "生年月日（月）を入力してください。";
		}

		// 生年月日（日） check
		if($this->birthDateDay === ""){
			$this->isValid = true;
			$this->errorMessage[] = "生年月日（日）を入力してください。";
		}

		if(!checkdate($this->birthDateMonth, $this->birthDateDay, $this->birthDateYear)){
			$this->isValid = true;
			$this->errorMessage[] = "有効な生年月日を入力してください。";
		}

		// 性別 check
		if($this->gender === ""){
			$this->isValid = true;
			$this->errorMessage[] = "性別を選択してください。";
		}
		// 郵便番号 check
		if(strlen($this->zip1) !== 3 || !Util::isNumeric($this->zip1)){
			$this->isValid = true;
			$this->errorMessage[] = "郵便番号（前半３桁）は３桁の数字で入力してください。";
		}

		if(strlen($this->zip2) !== 4 || !Util::isNumeric($this->zip2)){
			$this->isValid = true;
			$this->errorMessage[] = "郵便番号（後半４桁）は４桁の数字で入力してください。";
		}

		// 住所 check
		if($this->address1 === ""){
			$this->isValid = true;
			$this->errorMessage[] = "都道府県を入力してください。";
		}

		if(Util::includeHarfCharacter($this->address1)){
			$this->isValid = true;
			$this->errorMessage[] = "都道府県に半角文字は使えません。";
		}

		if(Util::includeSpecialCharacter($this->address1)){
			$this->isValid = true;
			$this->errorMessage[] = "都道府県に機種依存文字は使えません。";
		}

		if($this->address2 === ""){
			$this->isValid = true;
			$this->errorMessage[] = "市区郡を入力してください。";
		}
		if(Util::includeHarfCharacter($this->address2)){
			$this->isValid = true;
			$this->errorMessage[] = "市区郡に半角文字は使えません。";
		}

		if(Util::includeSpecialCharacter($this->address2)){
			$this->isValid = true;
			$this->errorMessage[] = "市区郡に機種依存文字は使えません。";
		}
		
		if($this->address3 === ""){
			$this->isValid = true;
			$this->errorMessage[] = "町名・番地を入力してください。";
		}
		if(Util::includeHarfCharacter($this->address3)){
			$this->isValid = true;
			$this->errorMessage[] = "町名・番地に半角文字は使えません。";
		}

		if(Util::includeSpecialCharacter($this->address3)){
			$this->isValid = true;
			$this->errorMessage[] = "町名・番地に機種依存文字は使えません。";
		}
		if(Util::includeHarfCharacter($this->address4)){
			$this->isValid = true;
			$this->errorMessage[] = "アパート・マンション名に半角文字は使えません。";
		}

		if(Util::includeSpecialCharacter($this->address4)){
			$this->isValid = true;
			$this->errorMessage[] = "アパート・マンション名に機種依存文字は使えません。";
		}

		// 電話番号 check
		if($this->tel1 === "" &&  $this->tel2 === "" && $this->tel3 === "" && $this->mTel1 === "" && $this->mTel2 === "" && $this->mTel3 === ""){
			$this->isValid = true;
			$this->errorMessage[] = "自宅電話番号か携帯電話番号を入力してください。";
		}

		if($this->tel1 !== "" ||  $this->tel2 !== "" || $this->tel3 !== ""){
			if(strlen($this->tel1) > 6){
				$this->isValid = true;
				$this->errorMessage[] = "自宅電話番号（市外局番）は６桁以内で入力してください。";
			}
			if(strlen($this->tel2) > 5){
				$this->isValid = true;
				$this->errorMessage[] = "自宅電話番号（局番）は５桁以内で入力してください。";
			}
			if(strlen($this->tel3) !== 4){
				$this->isValid = true;
				$this->errorMessage[] = "自宅電話番号（枝番）は４桁で入力してください。";
			}
			if($this->tel1 === ""){
				$this->isValid = true;
				$this->errorMessage[] = "自宅電話番号（市外局番）を入力してください。";
			}
			if($this->tel2 === ""){
				$this->isValid = true;
				$this->errorMessage[] = "自宅電話番号（局番）を入力してください。";
			}
			if($this->tel3 === ""){
				$this->isValid = true;
				$this->errorMessage[] = "自宅電話番号（枝番）を入力してください。";
			}
			if(!Util::isNumeric($this->tel1)){
				$this->isValid = true;
				$this->errorMessage[] = "自宅電話番号（市外局番）は数字で入力してください。";
			}
			if(!Util::isNumeric($this->tel2)){
				$this->isValid = true;
				$this->errorMessage[] = "自宅電話番号（局番）は数字で入力してください。";
			}
			if(!Util::isNumeric($this->tel3)){
				$this->isValid = true;
				$this->errorMessage[] = "自宅電話番号（枝番）は数字で入力してください。";
			}
		}

		if($this->mTel1 !== "" ||  $this->mTel2 !== "" || $this->mTel3 !== ""){
			if(strlen($this->mTel1) !== 3){
				$this->isValid = true;
				$this->errorMessage[] = "携帯電話番号（先頭３桁）は３桁で入力してください。";
			}
			if(strlen($this->mTel2) !== 4){
				$this->isValid = true;
				$this->errorMessage[] = "携帯電話番号（中央４桁）は４桁で入力してください。";
			}
			if(strlen($this->mTel3) !== 4){
				$this->isValid = true;
				$this->errorMessage[] = "携帯電話番号（末尾４桁）は４桁で入力してください。";
			}
			if($this->mTel1 === ""){
				$this->isValid = true;
				$this->errorMessage[] = "携帯電話番号（先頭３桁）を入力してください。";
			}
			if($this->mTel2 === ""){
				$this->isValid = true;
				$this->errorMessage[] = "携帯電話番号（中央４桁）を入力してください。";
			}
			if($this->mTel3 === ""){
				$this->isValid = true;
				$this->errorMessage[] = "携帯電話番号（末尾４桁）を入力してください。";
			}
			if(!Util::isNumeric($this->mTel1)){
				$this->isValid = true;
				$this->errorMessage[] = "携帯電話番号（先頭３桁）は数字で入力してください。";
			}
			if(!Util::isNumeric($this->mTel2)){
				$this->isValid = true;
				$this->errorMessage[] = "携帯電話番号（中央４桁）は数字で入力してください。";
			}
			if(!Util::isNumeric($this->mTel3)){
				$this->isValid = true;
				$this->errorMessage[] = "携帯電話番号（末尾４桁）は数字で入力してください。";
			}
		}
		
		// メールアドレス
		if($this->email === ""){
			$this->isValid = true;
			$this->errorMessage[] = "メールアドレスを入力してください。";
		}

		if(strlen($this->email) > 50){
			$this->isValid = true;
			$this->errorMessage[] = "メールアドレスは５０文字以内で入力してください。";
		}

		if(strlen($this->email) > 0){
			if(!Util::isMail($this->email)){
				$this->isValid = true;
				$this->errorMessage[] = "正しいメールアドレスを入力してください。";
			} else if ($this->email !== $this->email2){
				$this->isValid = true;
				$this->errorMessage[] = "メールアドレス（確認）が間違っています";
			}
		}
		
		// 職業
		if($this->occupation === ""){
			$this->isValid = true;
			$this->errorMessage[] = "職業を選択してください。";
		}
		
	}

	// バリデーションが成功か失敗かを返す
	// false : 成功
	// true : 失敗
	public function isValid(){
		return $this->isValid;
	}
}

?>