<?php

class Util {
	public static function zeroPadding($str, $num){
		return sprintf('%0' . $num .'d', $str);
	}

	public static function includeHarfCharacter($str){
		$pattern = '/[ -~｡-ﾟ]+/u';
		return preg_match($pattern, $str);
	}

	public static function includeZenAlphabet($str){
		$pattern = '/[ａ-ｚＡ-Ｚ]+/u';
		
		return preg_match($pattern, $str);
	}

	public static function includeZenNumeric($str){
		$pattern = '/[０-９]+/u';
		
		return preg_match($pattern, $str);
	}

	public static function includeSpecialCharacter($str){
		$pattern = '/[①②③④⑤⑥⑦⑧⑨⑩⑪⑫⑬⑭⑮⑯⑰⑱⑲⑳ⅠⅡⅢⅣⅤ≡∑∫∮√⊥∠∟⊿∵∩∪№㏍℡㊤㊥㊦㊧㊨㈱㈲㈹㍾㍽㍼㍻㍉㎜㎝㎞㎎㎏㏄㍉㌔㌢㍍㌘㌧㌃㌶㍑㍗㌍㌦㌣㌫㍊㌻ⅠⅡⅢⅣⅤⅥⅦⅧⅨⅩ]+/u';
		
		return preg_match($pattern, $str);
	}

	public static function isKatakana($str){
		$pattern = '/[ァ-ヶ|ー]+/u';
		
		return preg_match($pattern, $str);
	}

	public static function isNumeric($str){
		$pattern = '/[0-9]+/u';
		
		return preg_match($pattern, $str);
	}

	public static function isMail($str){
		$pattern = '/^[a-zA-Z_0-9]+([-+.][a-zA-Z_0-9]+)*@[a-zA-Z_0-9]+([-.][a-zA-Z_0-9]+)*\.[a-zA-Z_0-9]+([-.][a-zA-Z_0-9]+)*$/u';
		
		return preg_match($pattern, $str);
	}

}

?>