<?php

class WebFormManagerController extends AppController {
	public $name = 'WebFormManager';
	public $uses = array('RequestData','StatusHistory', 'MstUser', 'LoginLog', 'DownloadLog');
	public $layout = 'web_form_manager';
	
	var $components = array('RequestHandler');
	
	// paginatorパラメータ
	public $paginate = array('RequestData' => 
		array (
		'page' => 1,
		'conditions' => array(),
		'fields' => array('id', 'sei_kanji', 'mei_kanji', 'sei_kana', 'mei_kana', 'birth_date', 'gender_text', 'zip1', 'zip2', 'address1', 'address2', 'address3', 'address4', 'tel1', 'tel2', 'tel3', 'm_tel1', 'm_tel2', 'm_tel3', 'e_mail', 'occupation_text', 'request_date', 'ip_address', 'session_id'),
		'order' => array('request_date desc'),
		'sort' => 'id',
		'limit' => 50,
		'direction' => 'desc',
		'recursive' => 0
		),
		'MstUser' => 
		array (
		'page' => 1,
		'conditions' => array(),
		'fields' => array('id', 'operator_name', 'role_text', 'date_created', 'lock_flag', 'disabled'),
		'sort' => 'id',
		'limit' => 50,
		'direction' => 'desc',
		'recursive' => 0
	),
		'LoginLog' => 
		array (
		'page' => 1,
		'conditions' => array(),
		'fields' => array('operator_id', 'login_successful', 'login_date', 'ip_address', 'session_id'),
		'order' => array('login_date desc'),
		'sort' => 'login_date',
		'limit' => 50,
		'direction' => 'desc',
		'recursive' => 0
	),
		'DownloadLog' => 
		array (
		'page' => 1,
		'conditions' => array(),
		'fields' => array('operator_id', 'download_filename', 'download_count', 'download_date', 'ip_address', 'session_id'),
		'order' => array('download_date desc'),
		'sort' => 'download_date',
		'limit' => 50,
		'direction' => 'desc',
		'recursive' => 0
	)
	);


	// ログイン処理
	function login(){
		// ライブラリをロード
		App::import('Lib', 'LoginData');
		// タイムゾーンの設定
		date_default_timezone_set('Asia/Tokyo');
		// エラーメッセージ初期化
		$this->set("errorMessage", "");
		
		if(isset($this->params["form"]["login"])){	// ログインボタンを押したとき
			$obj = new LoginData();
			// フォームのデータを取得
			$obj->id = $this->data['list']['operator_id'];
			$obj->password = $this->data['list']['password'];
			
			// バリデーション実行
			$obj->valid();
			
			// バリデーションエラーが発生したら画面にエラーを表示
			if($obj->isValid()){
				$err = "<div class='validation-erros'>";
				for($i = 0; $i < count($obj->errorMessage); $i++){
					$err .= "・ ". $obj->errorMessage[$i] . "<br />";
				}
				$err .= "</div>";
				$this->set("errorMessage", $err);
			} else {
				// ユーザ情報の取得
				$data = $this->MstUser->find('all', array('conditions' => array('MstUser.id' => "{$obj->id}")));
				// 入力パスワードの暗号化(SHA1)
				$encryptePassword = Security::hash($obj->password);
				if(count($data) == 0){	// ユーザデータが見つからないとき
					$err = "<div class='validation-erros'>";
					$err .= "・ オペレータIDまたはパスワードがエラーです";
					$err .= "</div>";
					$this->set("errorMessage", $err);
				} else if($data[0]['MstUser']['lock_flag'] === '1'){	// ユーザがロックされているとき
					$err = "<div class='validation-erros'>";
					$err .= "・ オペレータID({$obj->id})はロックされています";
					$err .= "</div>";
					$this->set("errorMessage", $err);
				} else if($data[0]['MstUser']['disabled'] === '1'){	// ユーザが無効化されているとき
					$err = "<div class='validation-erros'>";
					$err .= "・ オペレータID({$obj->id})は無効化されています";
					$err .= "</div>";
					$this->set("errorMessage", $err);
				} else if($encryptePassword !== $data[0]['MstUser']['password']){	// 入力パスワードが間違っていたとき
					$err = "<div class='validation-erros'>";
					$err .= "・ オペレータIDまたはパスワードがエラーです";
					$err .= "</div>";
					$this->set("errorMessage", $err);
					
					$failedCount = $data[0]['MstUser']['failed_count'];
					$failedCount++;
					$lockFlag = 0;
					if($failedCount > 6){
						$lockFlag = 1;
					}
					//　ログイン処理を行う（ログインパラメータの更新、ログの記録）
					$this->MstUser->executeLogin($obj->id, 0, $failedCount, $lockFlag,$this->RequestHandler->getClientIP(),$this->Session->id());
				} else if ($data[0]['MstUser']['initial_password'] === '1'){	// 初期パスワードのとき
					$err = "<div class='validation-erros'>";
					$err .= "・ 初期化されたパスワードです。パスワードを更新してください";
					$err .= "</div>";
					$this->set("errorMessage", $err);
				} else if ($data[0]['MstUser']['last_password_change'] < date('Y-m-d H:i:s', strtotime("-120 day"))){	// パスワードの有効期限が過ぎているとき
					$err = "<div class='validation-erros'>";
					$err .= "・ パスワードの有効期限が過ぎています。パスワードを更新してください";
					$err .= "</div>";
					$this->set("errorMessage", $err);
				} else {	// ログインに成功したとき
					// オブジェクトにログイン情報を設定
					$obj->operatorName = $data[0]['MstUser']['operator_name'];
					$ary = split(',', $data[0]['MstUser']['role']);
					$obj->roleRead = false;
					$obj->roleWrite = false;
					$obj->roleCSVDownload = false;
					$obj->roleUserManager = false;
					for($i = 0; $i < count($ary); $i++){
						if($ary[$i] === "1"){
							$obj->roleRead = true;
						} else if($ary[$i] === "2"){
							$obj->roleWrite = true;
						} else if($ary[$i] === "3"){
							$obj->roleCSVDownload = true;
						} else if($ary[$i] === "4"){
							$obj->roleUserManager = true;
						}
					}
					// ログイン処理を行う（ログインパラメータの更新、ログの記録）
					$this->MstUser->executeLogin($obj->id, 1, 0, 0,$this->RequestHandler->getClientIP(),$this->Session->id());
					// ログイン情報をセッションに記録
					$this->Session->write("loginData", serialize($obj));
					
					// ロールに応じて初期画面へ移動
					if($obj->roleRead){
						$this->redirect("./status");
					} else if($obj->roleWrite){
						$this->redirect("./status");
					} else if($obj->roleCSVDownload){
						$this->redirect("./csvDownload");
					} else if($obj->roleUserManager){
						$this->redirect("./userManager");
					}
				}
			}
		}
	}

	function passwordChange(){
		// ライブラリをロード
		App::import('Lib', 'PasswordChangeData');
		
		// エラーメッセージを初期化
		$this->set("errorMessage", "");

		if(isset($this->params["form"]["back"])) {	// 戻るボタン
			// ログイン画面に戻る
			$this->redirect("./login");
		} else if (isset($this->params["form"]["next"])) {	// 確認ボタン
			// オブジェクトにフォームデータを保存
			$obj = new PasswordChangeData();
			$obj->id = $this->data['list']['id'];
			$obj->oldPassword = $this->data['list']['old_password'];
			$obj->password = $this->data['list']['password'];
			$obj->password2 = $this->data['list']['password2'];

			// バリデーション実行
			$obj->valid();
			
			// バリデーションエラーが発生したら画面にエラーを表示
			if($obj->isValid()){
				$err = "<div class='validation-erros'>";
				for($i = 0; $i < count($obj->errorMessage); $i++){
					$err .= "・ ". $obj->errorMessage[$i] . "<br />";
				}
				$err .= "</div>";
				$this->set("errorMessage", $err);
			} else {
				// ユーザデータを取得
				$data = $this->MstUser->find('all', array('conditions' => array('MstUser.id' => "{$obj->id}")));
				// 入力パスワードの暗号化
				$encryptePassword = Security::hash($obj->oldPassword);
				if(count($data) === 0){	// ユーザが見つからないとき
					$err = "<div class='validation-erros'>";
					$err .= "・ オペレータIDまたは旧パスワードがエラーです";
					$err .= "</div>";
					$this->set("errorMessage", $err);
				} else if($encryptePassword !== $data[0]['MstUser']['password']){	// パスワードが間違っているとき
					$err = "<div class='validation-erros'>";
					$err .= "・ オペレータIDまたは旧パスワードがエラーです";
					$err .= "</div>";
					$this->set("errorMessage", $err);
				} else {	// 成功したとき
					// セッションにパスワード更新データを保存
					$this->Session->write("passwordChangeData", serialize($obj));
					// 確認画面に移動
					$this->redirect("./passwordChangeConfirm");
				}
			}
		}

	}

	function passwordChangeConfirm(){
		// ライブラリをロード
		App::import('Lib', 'Util');
		App::import('Lib', 'PasswordChangeData');
		
		// セッションが見つからないときはエラー画面に移動
		if(!$this->Session->check("passwordChangeData")){
			$this->redirect("./maintenance");
		}

		// オブジェクトを取得
		$obj = unserialize($this->Session->read("passwordChangeData"));

		if(isset($this->params["form"]["back"])) {	// 戻るボタン
			// 入力画面に遷移
			$this->redirect("./passwordChange");
		} else if (isset($this->params["form"]["save"])) {	// 保存ボタン
			// パスワードを暗号化(SHA1)
			$obj->setEncryptedPassword();
			// パスワードを更新
			$this->MstUser->updatePassword($obj);
			// メッセージボックスを表示
			$this->redirect("./messageBox2");
		} else { // ページ表示時
			// Viewに値を渡す
			$this->set('id', $obj->id);
			$this->set('old_password', Util::getMaskPassword($obj->oldPassword));
			$this->set('password', Util::getMaskPassword($obj->password));
		}

	}

	// データ検索
	function status(){
		// ライブラリをロード
		App::import('Lib', 'SearchCondition');
		App::import('Lib', 'LoginData');
		
		// ログイン後かどうかチェック
		if(!$this->Session->check("loginData")){
			$this->redirect("./maintenance");
		}

		// ログインオブジェクトを取得
		$login = unserialize($this->Session->read("loginData"));
		
		// ReadおよびWrite権限以外のときはエラー
		if(!($login->roleRead || $login->roleWrite)){
			$this->redirect("./maintenance");
		}
		
		// Viewに表示用データを渡す
		$this->set("roleRead", $login->roleRead);
		$this->set("roleWrite", $login->roleWrite);
		$this->set("roleCSVDownload", $login->roleCSVDownload);
		$this->set("roleUserManager", $login->roleUserManager);

		// エラーメッセージを初期化
		$this->set("errorMessage", "");
		$isValid = false;
		
		if(isset($this->params["form"]["search"])) {	// 検索ボタン
			$condition = new SearchCondition();
			
			// オブジェクトに値をセット
			$condition->id = $this->data['list']['id'];
			$condition->seiKanji = $this->data['list']['sei_kanji'];
			$condition->meiKanji = $this->data['list']['mei_kanji'];
			$condition->seiKana = $this->data['list']['sei_kana'];
			$condition->meiKana = $this->data['list']['mei_kana'];
			$condition->zip = $this->data['list']['zip'];
			$condition->email = $this->data['list']['email'];
			$condition->fromDate =  $this->data['list']['from_date'];
			$condition->toDate =  $this->data['list']['to_date'];
			
			// バリデーション実行
			$condition->valid();
			
			// バリデーションエラーが発生したら画面にエラーを表示
			if($condition->isValid()){
				$err = "<div class='validation-erros'>";
				for($i = 0; $i < count($condition->errorMessage); $i++){
					$err .= "・ ". $condition->errorMessage[$i] . "<br />";
				}
				$err .= "</div>";
				$this->set("errorMessage", $err);
				$isValid = true;
			}
			
			if(!$isValid){
				// 検索文字列を取得
				$searchString = $condition->getSearchString();
				// 検索条件の設定
				$this->paginate['RequestData']['conditions'] = array($searchString);
				
				$this->Session->write('searchString', $searchString);
				$this->Session->write('searchCondition', serialize($condition));
			}
		} else if(isset($this->params["form"]["clear"])) {	// クリアボタン
			// 検索条件のクリア
			$this->Session->delete('searchCondition');
			$this->data['list']['id'] = "";
		 	$this->data['list']['sei_kanji'] = "";
			$this->data['list']['mei_kanji'] = "";
			$this->data['list']['sei_kana'] = "";
			$this->data['list']['mei_kana'] = "";
			$this->data['list']['zip'] = "";
			$this->data['list']['email'] = "";
			$this->data['list']['from_date'] = "";
			$this->data['list']['to_date'] = "";
		} else { // ページ切り替え時の処理
			$searchString = $this->Session->read('searchString');
			
			// 検索条件の設定
			$this->paginate['RequestData']['conditions'] = array($searchString);
		}
		
		if(!$isValid){
			$data = $this->paginate("RequestData");
			$this->set('data', $data);
		}
		// 検索条件を再設定
		if($this->Session->check('searchCondition')){
			$condition = unserialize($this->Session->read('searchCondition'));
			$this->data['list']['id'] = $condition->id;
		 	$this->data['list']['sei_kanji'] = $condition->seiKanji;
			$this->data['list']['mei_kanji'] = $condition->meiKanji;
			$this->data['list']['sei_kana'] = $condition->seiKana;
			$this->data['list']['mei_kana'] = $condition->meiKana;
			$this->data['list']['zip'] = $condition->zip;
			$this->data['list']['email'] = $condition->email;
			$this->data['list']['from_date'] = $condition->fromDate;
			$this->data['list']['to_date'] = $condition->toDate;
		}

	}
	
	// 詳細画面表示
	function detail(){
		// ライブラリをロード
		App::import('Lib', 'LoginData');

		if(!$this->Session->check("loginData")){
			$this->redirect("./maintenance");
		}

		// ログインオブジェクトを取得
		$login = unserialize($this->Session->read("loginData"));

		// Read/Write権限以外のときエラー画面へ
		if(!($login->roleRead || $login->roleWrite)){
			$this->redirect("./maintenance");
		}
		// Viewに表示判定用データを渡す
		$this->set("roleRead", $login->roleRead);
		$this->set("roleWrite", $login->roleWrite);
		$this->set("roleCSVDownload", $login->roleCSVDownload);
		$this->set("roleUserManager", $login->roleUserManager);

		if(isset($this->params["form"]["back"])){	// 戻るボタン
			// データ検索画面へ戻る
			$this->redirect("./status");
		} else if(isset($this->params["form"]["statusChange"])) {	// ステータス更新ボタン
			// ステータス更新画面へ移動
			$this->redirect("./statusChange");
		} else {
			$id = $this->params["url"]["id"];
			$this->Session->write("statusId", $id);
			// 申込データを取得
			$data = $this->RequestData->find('all', array('conditions' => array('RequestData.id' => "{$id}")));
			// Viewに値をセット
			$this->set('id', htmlspecialchars($data[0]['RequestData']['id']));
			$this->set('status', htmlspecialchars($data[0]['RequestData']['status_text']));
			$this->set('seiKanji', htmlspecialchars($data[0]['RequestData']['sei_kanji']));
			$this->set('meiKanji', htmlspecialchars($data[0]['RequestData']['mei_kanji']));
			$this->set('seiKana', htmlspecialchars($data[0]['RequestData']['sei_kana']));
			$this->set('meiKana', htmlspecialchars($data[0]['RequestData']['mei_kana']));
			$this->set('birthDate', htmlspecialchars($data[0]['RequestData']['birth_date']));
			$this->set('gender', htmlspecialchars($data[0]['RequestData']['gender_text']));
			$this->set('zip', htmlspecialchars($data[0]['RequestData']['zip1']) . "-" . htmlspecialchars($data[0]['RequestData']['zip2']));
			$this->set('address', htmlspecialchars($data[0]['RequestData']['address1']) . htmlspecialchars($data[0]['RequestData']['address2']) . htmlspecialchars($data[0]['RequestData']['address3']) . htmlspecialchars($data[0]['RequestData']['address4']));
			$this->set('tel', htmlspecialchars($data[0]['RequestData']['tel1']) . "-" . htmlspecialchars($data[0]['RequestData']['tel2']) . "-" . htmlspecialchars($data[0]['RequestData']['tel3']));
			$this->set('mTel', htmlspecialchars($data[0]['RequestData']['m_tel1']) . "-" . htmlspecialchars($data[0]['RequestData']['m_tel2']) . "-" . htmlspecialchars($data[0]['RequestData']['m_tel3']));
			$this->set('email', htmlspecialchars($data[0]['RequestData']['e_mail']));
			$this->set('occupation', htmlspecialchars($data[0]['RequestData']['occupation_text']));
			$this->set('requestDate', htmlspecialchars($data[0]['RequestData']['request_date']));
			$this->set('ipAddress', htmlspecialchars($data[0]['RequestData']['ip_address']));
			$this->set('sessionId', htmlspecialchars($data[0]['RequestData']['session_id']));
			// ステータス更新履歴を取得
			$data2 = $this->StatusHistory->find('all', array('conditions' => array('StatusHistory.id' => "{$id}")));
			// Viewに値を渡す
			$this->set('data', $data2);
		}
	}

	// ステータス更新画面
	function statusChange(){
		// ライブラリをロード
		App::import('Lib', 'StatusChangeData');
		App::import('Lib', 'LoginData');
		
		// ログインしていなければエラー画面へ
		if(!$this->Session->check("loginData")){
			$this->redirect("./maintenance");
		}

		// ログインオブジェクトを取得
		$login = unserialize($this->Session->read("loginData"));

		// Write権限以外はエラー画面へ
		if(!$login->roleWrite){
			$this->redirect("./maintenance");
		}
		// Viewに判定用データを渡す
		$this->set("roleRead", $login->roleRead);
		$this->set("roleWrite", $login->roleWrite);
		$this->set("roleCSVDownload", $login->roleCSVDownload);
		$this->set("roleUserManager", $login->roleUserManager);

		$isBack = false;
		// エラーメッセージを初期化
		$this->set("errorMessage", "");
		// セッションからIDを取り出す
		$id = $this->Session->read("statusId");

		// 確認画面から戻ったときは再表示する
		if($this->Session->check('isStatusChangeBack') && $this->Session->read('isStatusChangeBack') === true){
			$view = unserialize($this->Session->read('statusChangeData'));
			
			$this->set('id', $id);
			$this->data['RequestData']['status'] = $view->newStatus;
			$this->data['RequestData']['comment'] = $view->comment;
			
			$this->Session->write('isStatusChangeBack', false);
			$isBack = true;
		}

		if(isset($this->params["form"]["back"])){	// 戻るボタン
			// 詳細画面に戻る
			$this->redirect("./detail?id={$id}");
		} else if(isset($this->params["form"]["next"])) {	// 次へボタン
			// オブジェクトに値をセット
			$obj = new StatusChangeData();
			$obj->id = $id;
			$obj->oldStatus = $this->Session->read("oldStatus");
			$obj->oldStatusText = $obj->convertStatus($obj->oldStatus);
			$obj->newStatus = $this->data['RequestData']['status'];
			$obj->newStatusText = $obj->convertStatus($obj->newStatus);
			$obj->comment = $this->data['RequestData']['comment'];

			// バリデーション実行
			$obj->valid();
			
			// バリデーションエラーが発生したら画面にエラーを表示
			if($obj->isValid()){
				$err = "<div class='validation-erros'>";
				for($i = 0; $i < count($obj->errorMessage); $i++){
					$err .= "・ ". $obj->errorMessage[$i] . "<br />";
				}
				$err .= "</div>";
				$this->set("errorMessage", $err);
				$this->set('id', $id);
			} else {
				// セッションに値をセット
				$this->Session->write("statusChangeData", serialize($obj));
				// 確認画面へ移動
				$this->redirect("./statusChangeConfirm");
			}

		} else { // 初期表示
			// 確認画面から戻ってこなかったとき
			if(!$isBack){
				// データベースから情報を読み取りViewに値をセット
				$data = $this->RequestData->find('all', array('conditions' => array('RequestData.id' => "{$id}")));
				$this->set('id', htmlspecialchars($data[0]['RequestData']['id']));
				$this->data['RequestData']['status'] = $data[0]['RequestData']['status'];
				$this->Session->write("oldStatus", $data[0]['RequestData']['status']);
			}
		}
	}
	
	// ステータス更新画面(確認)
	function statusChangeConfirm(){
		// ライブラリをロード
		App::import('Lib', 'StatusChangeData');
		App::import('Lib', 'LoginData');

		// ログインしていないときエラー画面へ
		if(!$this->Session->check("loginData")){
			$this->redirect("./maintenance");
		}

		// ログインオブジェクトを取得
		$login = unserialize($this->Session->read("loginData"));

		// Write権限でないときエラー画面へ
		if(!$login->roleWrite){
			$this->redirect("./maintenance");
		}
		// Viewに値を渡す
		$this->set("roleRead", $login->roleRead);
		$this->set("roleWrite", $login->roleWrite);
		$this->set("roleCSVDownload", $login->roleCSVDownload);
		$this->set("roleUserManager", $login->roleUserManager);
		
		// セッションが存在しないときエラー画面へ
		if(!$this->Session->check("statusChangeData")){
			$this->redirect("./maintenance");
		}
		// セッションからオブジェクトの取得
		$obj = unserialize($this->Session->read("statusChangeData"));

		if(isset($this->params["form"]["back"])){	// 戻るボタン
			// 入力画面へ戻る
			$this->Session->write('isStatusChangeBack', true); 
			$this->redirect("./statusChange");
		} else if(isset($this->params["form"]["save"])) {	// 保存ボタン
			// データベースの保存する
			$this->StatusHistory->insertStatusHistory($obj, $login->id);
			
			// メッセージボックスを表示
			$this->Session->delete("statusChangeData");
			$this->Session->write("messageBoxTitle", "ステータス更新");
			$this->Session->write("messageBoxContent", "ステータス更新しました");
			
			$this->redirect("./messageBox");
		} else {	// 初期表示
			// Viewに値を渡す
			$this->set('id', $obj->id);
			$this->set('old_status', $obj->oldStatusText);
			$this->set('new_status', $obj->newStatusText);
			$this->set('comment', $obj->comment);
		}
	}

	// ログ検索
	function logSearch(){
		// ライブラリをロード
		App::import('Lib', 'LoginData');
		
		// ログインしていないときはエラー画面へ
		if(!$this->Session->check("loginData")){
			$this->redirect("./maintenance");
		}

		// ログインオブジェクトを取得
		$login = unserialize($this->Session->read("loginData"));

		// UserManager権限がないときはエラー画面へ
		if(!$login->roleUserManager){
			$this->redirect("./maintenance");
		}

		// Viewに値を渡す
		$this->set("roleRead", $login->roleRead);
		$this->set("roleWrite", $login->roleWrite);
		$this->set("roleCSVDownload", $login->roleCSVDownload);
		$this->set("roleUserManager", $login->roleUserManager);

	}

	// ログ検索
	function loginLog(){
		// ライブラリをロード
		App::import('Lib', 'LoginLogSearchCondition');
		App::import('Lib', 'LoginData');

		// ログインしていないときはエラー画面へ
		if(!$this->Session->check("loginData")){
			$this->redirect("./maintenance");
		}

		// ログインオブジェクトを取得
		$login = unserialize($this->Session->read("loginData"));

		// UserManager権限がないときはエラー画面へ
		if(!$login->roleUserManager){
			$this->redirect("./maintenance");
		}

		// Viewに値を渡す
		$this->set("roleRead", $login->roleRead);
		$this->set("roleWrite", $login->roleWrite);
		$this->set("roleCSVDownload", $login->roleCSVDownload);
		$this->set("roleUserManager", $login->roleUserManager);


		// エラーメッセージを初期化
		$this->set("errorMessage", "");
		
		$isValid = false;

		if(isset($this->params["form"]["search"])) {	// 検索ボタン
			$condition = new LoginLogSearchCondition();
			
			// オブジェクトに値をセット
			$condition->id = $this->data['list']['id'];
			$condition->startDate = $this->data['list']['start_date'];
			$condition->endDate = $this->data['list']['end_date'];
			// バリデーション実行
			$condition->valid();
			
			// バリデーションエラーが発生したら画面にエラーを表示
			if($condition->isValid()){
				$err = "<div class='validation-erros'>";
				for($i = 0; $i < count($condition->errorMessage); $i++){
					$err .= "・ ". $condition->errorMessage[$i] . "<br />";
				}
				$err .= "</div>";
				$this->set("errorMessage", $err);
			}
			if(!$isValid){
				// 検索文字列を取得
				$searchString = $condition->getSearchString();
				// 検索条件の設定
				$this->paginate['LoginLog']['conditions'] = array($searchString);
				
				$this->Session->write('loginLogSearchString', $searchString);
				$this->Session->write('loginLogSearchCondition', serialize($condition));
			}

		} else { // ページ切り替え時の処理
			$searchString = $this->Session->read('loginLogSearchString');
			
			// 検索条件の設定
			$this->paginate['LoginLog']['conditions'] = array($searchString);
		}
		
		if(!$isValid){
			// ページ情報を設定しViewに渡す
			$data = $this->paginate("LoginLog");
			$this->set('data', $data);
		}
		
		// 画面が戻ったとき再表示
		if($this->Session->check('loginLogSearchCondition')){
			$condition = unserialize($this->Session->read('loginLogSearchCondition'));
			$this->data['list']['id'] = $condition->id;
			$this->data['list']['start_date'] = $condition->startDate;
			$this->data['list']['end_date'] = $condition->endDate;
		}
	}

	// ログ検索
	function downloadLog(){
		// ライブラリをロード
		App::import('Lib', 'DownloadLogSearchCondition');
		App::import('Lib', 'LoginData');
		
		// ログインしていないときエラー画面へ
		if(!$this->Session->check("loginData")){
			$this->redirect("./maintenance");
		}

		// ログインオブジェクトを取得
		$login = unserialize($this->Session->read("loginData"));

		// UserManager権限がないときエラー画面へ
		if(!$login->roleUserManager){
			$this->redirect("./maintenance");
		}

		// Viewに値をセット
		$this->set("roleRead", $login->roleRead);
		$this->set("roleWrite", $login->roleWrite);
		$this->set("roleCSVDownload", $login->roleCSVDownload);
		$this->set("roleUserManager", $login->roleUserManager);

		// エラーメッセージを初期化
		$this->set("errorMessage", "");
		
		$isValid = false;

		if(isset($this->params["form"]["search"])) {	// 検索ボタン
			$condition = new DownloadLogSearchCondition();
			
			// オブジェクトに値をセット
			$condition->id = $this->data['list']['id'];
			$condition->startDate = $this->data['list']['start_date'];
			$condition->endDate = $this->data['list']['end_date'];
			// バリデーション実行
			$condition->valid();
			
			// バリデーションエラーが発生したら画面にエラーを表示
			if($condition->isValid()){
				$err = "<div class='validation-erros'>";
				for($i = 0; $i < count($condition->errorMessage); $i++){
					$err .= "・ ". $condition->errorMessage[$i] . "<br />";
				}
				$err .= "</div>";
				$this->set("errorMessage", $err);
			}
			if(!$isValid){
				// 検索文字列を取得
				$searchString = $condition->getSearchString();
				// 検索条件の設定
				$this->paginate['LoginLog']['conditions'] = array($searchString);
				
				$this->Session->write('downloadLogSearchString', $searchString);
				$this->Session->write('downloadLogSearchCondition', serialize($condition));
			}

		} else { // ページ切り替え時の処理
			$searchString = $this->Session->read('downloadLogSearchString');
			
			// 検索条件の設定
			$this->paginate['DownloadLog']['conditions'] = array($searchString);
		}
		
		if(!$isValid){
			// ページ情報を設定しViewに値をセット
			$data = $this->paginate("DownloadLog");
			$this->set('data', $data);
		}
		
		// 再表示するときに値をセット
		if($this->Session->check('downloadLogSearchCondition')){
			$condition = unserialize($this->Session->read('downloadLogSearchCondition'));
			$this->data['list']['id'] = $condition->id;
			$this->data['list']['start_date'] = $condition->startDate;
			$this->data['list']['end_date'] = $condition->endDate;
		}
	}

	// CSVダウンロード
	function csvDownload(){
		// ライブラリをロード
		App::import('Lib', 'CsvDownloadData');
		App::import('Lib', 'LoginData');
		
		// ログインしていないときエラー画面へ
		if(!$this->Session->check("loginData")){
			$this->redirect("./maintenance");
		}

		// ログインオブジェクトを取得
		$login = unserialize($this->Session->read("loginData"));

		// CSVDownload権限がないときにエラー画面へ
		if(!$login->roleCSVDownload){
			$this->redirect("./maintenance");
		}

		// Viewに値を渡す
		$this->set("roleRead", $login->roleRead);
		$this->set("roleWrite", $login->roleWrite);
		$this->set("roleCSVDownload", $login->roleCSVDownload);
		$this->set("roleUserManager", $login->roleUserManager);

		// エラーメッセージを初期化
		$this->set("errorMessage", "");
		
		if(isset($this->params["form"]["download"])) {	// ダウンロードボタン
			$obj = new CsvDownloadData();

			$obj->startDate = $this->data['list']['start_date'];
			$obj->endDate = $this->data['list']['end_date'];
			
			// バリデーション実行
			$obj->valid();
			
			// バリデーションエラーが発生したら画面にエラーを表示
			if($obj->isValid()){
				$err = "<div class='validation-erros'>";
				for($i = 0; $i < count($obj->errorMessage); $i++){
					$err .= "・ ". $obj->errorMessage[$i] . "<br />";
				}
				$err .= "</div>";
				$this->set("errorMessage", $err);
			} else {
				// データベースからデータを取得しCSVとして出力
				$data = $this->RequestData->find('all', array('conditions' => array('RequestData.request_date > ' => "{$obj->startDate}", 'RequestData.request_date < ' => "{$obj->endDate}")));
				
				$startDate = str_replace("/", "", $obj->startDate);
				$endDate = str_replace("/", "", $obj->endDate);
				
				$this->autoRender = false; // Viewを使わないように
				Configure::write('debug', 0); // debugコードを出さないように
				$csvFile = sprintf("csv_%s_%s.csv", $startDate, $endDate); // ファイル名を指定
				header ("Content-disposition: attachment; filename=" . $csvFile);
				header ("Content-type: application/octet-stream; name=" . $csvFile);
				// 出力
				foreach($data as $record){
					print($record['RequestData']['id'] . ",");
					print($record['RequestData']['sei_kanji'] . ",");
					print($record['RequestData']['mei_kanji'] . ",");
					print($record['RequestData']['sei_kana'] . ",");
					print($record['RequestData']['mei_kana'] . ",");
					print($record['RequestData']['birth_date'] . ",");
					print($record['RequestData']['gender_text'] . ",");
					print($record['RequestData']['zip1'] . ",");
					print($record['RequestData']['zip2'] . ",");
					print($record['RequestData']['address1'] . ",");
					print($record['RequestData']['address2'] . ",");
					print($record['RequestData']['address3'] . ",");
					print($record['RequestData']['address4'] . ",");
					print($record['RequestData']['tel1'] . ",");
					print($record['RequestData']['tel2'] . ",");
					print($record['RequestData']['tel3'] . ",");
					print($record['RequestData']['m_tel1'] . ",");
					print($record['RequestData']['m_tel2'] . ",");
					print($record['RequestData']['m_tel3'] . ",");
					print($record['RequestData']['email'] . ",");
					print($record['RequestData']['occupation_text'] . ",");
					print($record['RequestData']['request_date'] . ",");
					print($record['RequestData']['ip_address'] . ",");
					print($record['RequestData']['session_id']);
					print("\n");
				}
				// ダウンロードログの書き込み
				$this->DownloadLog->insertDownloadLog($login->id, $csvFile, count($data), $this->RequestHandler->getClientIP(),$this->Session->id());
			}
		}
	}
	
	// ユーザ管理
	function userManager(){
		// ライブラリをロード
		App::import('Lib', 'UserSearchCondition');
		App::import('Lib', 'LoginData');
		
		// ログインしていないときはエラー画面へ
		if(!$this->Session->check("loginData")){
			$this->redirect("./maintenance");
		}

		// ログインオブジェクトを取得
		$login = unserialize($this->Session->read("loginData"));

		// UserManager権限がないときはエラー画面へ
		if(!$login->roleUserManager){
			$this->redirect("./maintenance");
		}

		// Viewに値をセット
		$this->set("roleRead", $login->roleRead);
		$this->set("roleWrite", $login->roleWrite);
		$this->set("roleCSVDownload", $login->roleCSVDownload);
		$this->set("roleUserManager", $login->roleUserManager);

		// エラーメッセージを初期化
		$this->set("errorMessage", "");
		$isValid = false;

		if(isset($this->params["form"]["search"])) {	// 検索ボタン
			$condition = new UserSearchCondition();
			
			// オブジェクトに値をセット
			$condition->id = $this->data['list']['id'];
			// バリデーション実行
			$condition->valid();
			
			// バリデーションエラーが発生したら画面にエラーを表示
			if($condition->isValid()){
				$err = "<div class='validation-erros'>";
				for($i = 0; $i < count($condition->errorMessage); $i++){
					$err .= "・ ". $condition->errorMessage[$i] . "<br />";
				}
				$err .= "</div>";
				$this->set("errorMessage", $err);
			}
			if(!$isValid){
				// 検索文字列を取得
				$searchString = $condition->getSearchString();
				// 検索条件の設定
				$this->paginate['MstUser']['conditions'] = array($searchString);
				
				$this->Session->write('userSearchString', $searchString);
				$this->Session->write('userSearchCondition', serialize($condition));
			}

		} else if(isset($this->params["form"]["newUser"])) {	// 新規ユーザボタン
			// newUser画面に切り替え
			$this->redirect("./newUser");
		} else { // ページ切り替え時の処理
			$searchString = $this->Session->read('userSearchString');
			
			// 検索条件の設定
			$this->paginate['MstUser']['conditions'] = array($searchString);
		}
		
		if(!$isValid){
			// ページ情報を初期化し、Viewに値を渡す
			$data = $this->paginate("MstUser");
			$this->set('data', $data);
		}
		// 再表示時に値をセット
		if($this->Session->check('userSearchCondition')){
			$condition = unserialize($this->Session->read('userSearchCondition'));
			$this->data['list']['id'] = $condition->id;
		}

	}
	
	// ユーザ新規登録
	function newUser(){
		// ライブラリをロード
		App::import('Lib', 'NewUserData');
		App::import('Lib', 'LoginData');

		// ログインしていないときにエラー画面へ
		if(!$this->Session->check("loginData")){
			$this->redirect("./maintenance");
		}

		// ログインオブジェクトを取得
		$login = unserialize($this->Session->read("loginData"));

		// UserManager権限がないときにエラー画面へ
		if(!$login->roleUserManager){
			$this->redirect("./maintenance");
		}
		
		// Viewに値をセット
		$this->set("roleRead", $login->roleRead);
		$this->set("roleWrite", $login->roleWrite);
		$this->set("roleCSVDownload", $login->roleCSVDownload);
		$this->set("roleUserManager", $login->roleUserManager);

		// エラーメッセージを初期化
		$this->set("errorMessage", "");

		// 確認画面から戻ったときは再表示する
		if($this->Session->check('isNewUserBack') && $this->Session->read('isNewUserBack') === true){
			$view = unserialize($this->Session->read('newUserData'));
			
			$this->data['list']['id'] = $view->id;
			$this->data['list']['operator_name'] = $view->operatorName;
			$this->data['list']['read'] = $view->roleRead;
			$this->data['list']['write'] = $view->roleWrite;
			$this->data['list']['csv_download'] = $view->roleCSVDownload;
			$this->data['list']['user_manager'] = $view->roleUserManager;


			$this->Session->write('isNewUserBack', false);
		}

		if(isset($this->params["form"]["next"])) {	// 確認ボタン
			// オブジェクトにフォームデータをセット
			$obj = new NewUserData();
			$obj->id = $this->data['list']['id'];
			$obj->operatorName = $this->data['list']['operator_name'];
			$obj->roleRead = $this->data['list']['read'];
			$obj->roleWrite = $this->data['list']['write'];
			$obj->roleCSVDownload = $this->data['list']['csv_download'];
			$obj->roleUserManager = $this->data['list']['user_manager'];
			$obj->password = $this->data['list']['password'];
			$obj->password2 = $this->data['list']['password2'];

			// バリデーション実行
			$obj->valid();
			
			// バリデーションエラーが発生したら画面にエラーを表示
			if($obj->isValid()){
				$err = "<div class='validation-erros'>";
				for($i = 0; $i < count($obj->errorMessage); $i++){
					$err .= "・ ". $obj->errorMessage[$i] . "<br />";
				}
				$err .= "</div>";
				$this->set("errorMessage", $err);
			} else {
				$data = $this->MstUser->find('all', array('conditions' => array('MstUser.id' => "{$obj->id}")));

				if($obj->id === $data[0]['MstUser']['id']){
					$err = "<div class='validation-erros'>";
					$err .= "・ ご指定のユーザIDはすでに登録されています";
					$err .= "</div>";
					$this->set("errorMessage", $err);
				} else {
 					$this->Session->write("newUserData", serialize($obj));
					$this->redirect("./newUserConfirm");
				}
			}
		} else {
		
		}
	}

	// ユーザ新規登録（確認）
	function newUserConfirm(){
		// ライブラリをロード
		App::import('Lib', 'Util');
		App::import('Lib', 'NewUserData');
		App::import('Lib', 'LoginData');
		
		// ログインしていないときエラー画面へ
		if(!$this->Session->check("loginData")){
			$this->redirect("./maintenance");
		}

		// ログインオブジェクトを取得
		$login = unserialize($this->Session->read("loginData"));

		// UserManager権限がないときにエラー画面へ
		if(!$login->roleUserManager){
			$this->redirect("./maintenance");
		}

		// Viewに値をセット
		$this->set("roleRead", $login->roleRead);
		$this->set("roleWrite", $login->roleWrite);
		$this->set("roleCSVDownload", $login->roleCSVDownload);
		$this->set("roleUserManager", $login->roleUserManager);

		// セッションが見つからないときはエラー画面へ
		if(!$this->Session->check("newUserData")){
			$this->redirect("./maintenance");
		}
		
		$obj = unserialize($this->Session->read("newUserData"));

		if(isset($this->params["form"]["back"])){	// 戻るボタン
			// 入力画面へ戻る
			$this->Session->write('isNewUserBack', true); 
			$this->redirect("./newUser");
		} else if(isset($this->params["form"]["save"])) {	// 保存ボタン
			// パスワードをSHA1で暗号化
			$obj->setEncryptedPassword();
			// データベースに格納
			$ret = $this->MstUser->insertMstUser($obj);
			// メッセージボックスを表示
			$this->Session->delete("newUserData");
			$this->Session->write("messageBoxTitle", "ユーザ新規登録");
			$this->Session->write("messageBoxContent", "ユーザを新規登録しました");

			$this->redirect("./messageBox");

		} else {	// 初期表示
			// Viewに値をセット
			$this->set('id', $obj->id);
			$this->set('operator_name', $obj->operatorName);
			$this->set('role', $obj->getRoleString());
			$this->set('password', Util::getMaskPassword($obj->password));
		}
	}
	
	// ユーザ更新
	function editUser(){
		// ライブラリをロード
		App::import('Lib', 'EditUserData');
		App::import('Lib', 'LoginData');

		// ログインしていないときにエラー画面へ
		if(!$this->Session->check("loginData")){
			$this->redirect("./maintenance");
		}

		// ログインオブジェクトを取得
		$login = unserialize($this->Session->read("loginData"));

		// UserManager権限がないときにエラー画面へ
		if(!$login->roleUserManager){
			$this->redirect("./maintenance");
		}

		// Viewに値をセット
		$this->set("roleRead", $login->roleRead);
		$this->set("roleWrite", $login->roleWrite);
		$this->set("roleCSVDownload", $login->roleCSVDownload);
		$this->set("roleUserManager", $login->roleUserManager);


		$isBack = false;
		// エラーメッセージを初期化
		$this->set("errorMessage", "");
		$id = $this->Session->read("userId");

		// 確認画面から戻ったときは再表示する
		if($this->Session->check('isEditUserBack') && $this->Session->read('isEditUserBack') === true){
			$view = unserialize($this->Session->read('editUserData'));
			
			$this->set('id', $id);
			$this->data['list']['operator_name'] = $view->operatorName;
			$this->data['list']['read'] = $view->roleRead;
			$this->data['list']['write'] = $view->roleWrite;
			$this->data['list']['csv_download'] = $view->roleCSVDownload;
			$this->data['list']['user_manager'] = $view->roleUserManager;
			$this->data['list']['lock'] = $view->lockFlag;
			$this->data['list']['disabled'] = $view->disabled;

			$this->Session->write('isStatusChangeBack', false);
			$isBack = true;
		}

		if(isset($this->params["form"]["next"])) {	// 確認ボタン
			// オブジェクトに値をセット	
			$obj = new EditUserData();
			$obj->id = $this->Session->read("userId");
			$obj->operatorName = $this->data['list']['operator_name'];
			$obj->roleRead = $this->data['list']['read'];
			$obj->roleWrite = $this->data['list']['write'];
			$obj->roleCSVDownload = $this->data['list']['csv_download'];
			$obj->roleUserManager = $this->data['list']['user_manager'];
			$obj->lockFlag = $this->data['list']['lock'];
			$obj->disabled = $this->data['list']['disabled'];
			
			// バリデーション実行
			$obj->valid();
			
			// バリデーションエラーが発生したら画面にエラーを表示
			if($obj->isValid()){
				$err = "<div class='validation-erros'>";
				for($i = 0; $i < count($obj->errorMessage); $i++){
					$err .= "・ ". $obj->errorMessage[$i] . "<br />";
				}
				$err .= "</div>";
				$this->set("errorMessage", $err);
				$this->set('id', $id);
			} else {
				// セッションに値をセットし、確認画面へ移動
				$this->Session->write("editUserData", serialize($obj));

				$this->redirect("./editUserConfirm");
			}
			
		} else {	// 初期表示
			if(!$isBack){
				$id = $this->params["url"]["id"];

				$this->Session->write("userId", $id);
				// データベースからデータを読み込む
				$data = $this->MstUser->find('all', array('conditions' => array('MstUser.id' => "{$id}")));
				// Viewに値をセット
				$this->set('id', htmlspecialchars($data[0]['MstUser']['id']));
				$this->data['list']['operator_name'] = htmlspecialchars($data[0]['MstUser']['operator_name']);
				$roles = $data[0]['MstUser']['role'];
				$ary = split(',', $roles);
				for($i = 0; $i < count($ary); $i++){
					if($ary[$i] === "1"){
						$this->data['list']['read'] = true;
					} else if($ary[$i] === "2"){
						$this->data['list']['write'] = true;
					} else if($ary[$i] === "3"){
						$this->data['list']['csv_download'] = true;
					} else if($ary[$i] === "4"){
						$this->data['list']['user_manager'] = true;
					}
				}
				$this->data['list']['lock'] = $data[0]['MstUser']['lock_flag'];
				$this->data['list']['disabled'] = $data[0]['MstUser']['disabled'];
			}
		}
	}

	// ユーザ更新(確認)
	function editUserConfirm(){
		// ライブラリをロード
		App::import('Lib', 'Util');
		App::import('Lib', 'EditUserData');
		App::import('Lib', 'LoginData');
		
		// ログインしていないときはエラー画面
		if(!$this->Session->check("loginData")){
			$this->redirect("./maintenance");
		}

		// ログインオブジェクトを取得
		$login = unserialize($this->Session->read("loginData"));

		// UserManager権限でないときはエラー画面
		if(!$login->roleUserManager){
			$this->redirect("./maintenance");
		}

		// Viewに値をセット
		$this->set("roleRead", $login->roleRead);
		$this->set("roleWrite", $login->roleWrite);
		$this->set("roleCSVDownload", $login->roleCSVDownload);
		$this->set("roleUserManager", $login->roleUserManager);

		// セッションが見つからないときはエラー画面へ
		if(!$this->Session->check("editUserData")){
			$this->redirect("./maintenance");
		}

		$obj = unserialize($this->Session->read("editUserData"));

		if(isset($this->params["form"]["back"])){	// 戻るボタン
			// 入力画面へ戻る
			$id = $this->Session->read("userId");
			$this->Session->write('isEditUserBack', true);
			$this->redirect("./editUser?id={$id}");
		} else if(isset($this->params["form"]["save"])) {	// 保存ボタン
			// ユーザデータを更新する
			$this->MstUser->updateMstUser($obj);
			// メッセージボックスを表示
			$this->Session->delete("editUserData");
			$this->Session->write("messageBoxTitle", "ユーザ更新");
			$this->Session->write("messageBoxContent", "ユーザを更新しました");

			$this->redirect("./messageBox");
		} else {	// 初期表示
			// Viewに値をセット
			$this->set('id', $obj->id);
			$this->set('operator_name', $obj->operatorName);
			$this->set('role', $obj->getRoleString());
			$this->set('lock', $obj->lockFlag);
			$this->set('disabled', $obj->disabled);
		}
	}

	// パスワード更新
	function editPassword(){
		// ライブラリをロード
		App::import('Lib', 'EditPasswordData');
		App::import('Lib', 'LoginData');

		// ログインしていないときはエラー画面
		if(!$this->Session->check("loginData")){
			$this->redirect("./maintenance");
		}

		// ログインオブジェクトを取得
		$login = unserialize($this->Session->read("loginData"));

		// UserManager権限でないときはエラー画面
		if(!$login->roleUserManager){
			$this->redirect("./maintenance");
		}

		// Viewに値を渡す
		$this->set("roleRead", $login->roleRead);
		$this->set("roleWrite", $login->roleWrite);
		$this->set("roleCSVDownload", $login->roleCSVDownload);
		$this->set("roleUserManager", $login->roleUserManager);


		$id = $this->Session->read("userId");

		// エラーメッセージを初期化
		$this->set("errorMessage", "");
		
		if(isset($this->params["form"]["next"])) {	// 確認ボタン
			// オブジェクトの生成
			$obj = new EditPasswordData();
			$obj->id = $this->Session->read("userId");
			$obj->password = $this->data['list']['password'];
			$obj->password2 = $this->data['list']['password2'];

			// バリデーション実行
			$obj->valid();
			
			// バリデーションエラーが発生したら画面にエラーを表示
			if($obj->isValid()){
				$err = "<div class='validation-erros'>";
				for($i = 0; $i < count($obj->errorMessage); $i++){
					$err .= "・ ". $obj->errorMessage[$i] . "<br />";
				}
				$err .= "</div>";
				$this->set("errorMessage", $err);
				$this->set('id', $id);
			} else {
				$this->Session->write("editPasswordData", serialize($obj));

				$this->redirect("./editPasswordConfirm");
			}

		} else {	// 初期表示
			$id = $this->params["url"]["id"];
			$this->Session->write("userId", $id);

			$this->set('id', $id);
		}
	}

	// パスワード更新(確認)
	function editPasswordConfirm(){
		// ライブラリをロード
		App::import('Lib', 'Util');
		App::import('Lib', 'EditPasswordData');
		App::import('Lib', 'LoginData');
		
		// ログインしていなければエラー画面へ
		if(!$this->Session->check("loginData")){
			$this->redirect("./maintenance");
		}

		// ログインオブジェクトを取得
		$login = unserialize($this->Session->read("loginData"));

		// UserManager権限でなければエラー画面へ
		if(!$login->roleUserManager){
			$this->redirect("./maintenance");
		}

		// Viewに値をセット
		$this->set("roleRead", $login->roleRead);
		$this->set("roleWrite", $login->roleWrite);
		$this->set("roleCSVDownload", $login->roleCSVDownload);
		$this->set("roleUserManager", $login->roleUserManager);
		
		// セッションがなければエラー画面へ
		if(!$this->Session->check("editPasswordData")){
			$this->redirect("./maintenance");
		}

		$obj = unserialize($this->Session->read("editPasswordData"));

		if(isset($this->params["form"]["back"])){	// 戻るボタン
			// 入力画面へ戻る
			$id = $this->Session->read("userId");
			$this->redirect("./editPassword?id={$id}");
		} else if(isset($this->params["form"]["save"])) {	// 保存ボタン
			// パスワードをSHA1で暗号化
			$obj->setEncryptedPassword();
			// ユーザのパスワードを更新
			$this->MstUser->updateEditPassword($obj);
			
			// メッセージボックスの表示
			$this->Session->delete("editPasswordData");
			$this->Session->write("messageBoxTitle", "パスワード更新");
			$this->Session->write("messageBoxContent", "パスワードを更新しました");

			$this->redirect("./messageBox");
		} else {	// 初期表示
			$this->set('id', $obj->id);
			$this->set('password', Util::getMaskPassword($obj->password));
		}
	}

	// メッセージボックス
	function messageBox(){
		// ライブラリをロード
		App::import('Lib', 'LoginData');

		if(!$this->Session->check("loginData")){
			$this->redirect("./maintenance");
		}

		// ログインオブジェクトを取得
		$login = unserialize($this->Session->read("loginData"));

		$this->set("mb_title", $this->Session->read("messageBoxTitle"));
		$this->set("mb_contents", $this->Session->read("messageBoxContent"));
		
		$this->set("roleRead", $login->roleRead);
		$this->set("roleWrite", $login->roleWrite);
		$this->set("roleCSVDownload", $login->roleCSVDownload);
		$this->set("roleUserManager", $login->roleUserManager);

		$this->Session->delete("messageBoxTitle");
		$this->Session->delete("messageBoxContent");
	}

	// メッセージボックス
	function messageBox2(){
		if(isset($this->params["form"]["back"])) {	// 戻るボタン
			$this->redirect("./login");
		} else {
			$this->Session->delete("passwordChangeData");
		}
	}

	function maintenance(){
		// セッションのクリア
		$this->Session->destroy();
	}

	function logout(){
		// セッションのクリア
		$this->Session->destroy();
	}

}

?>