<?php

class CsvDownloadData {
	public $startDate;
	public $endDate;

	public $isValid = false;
	public $errorMessage = array();
	
	// バリデーションを行う
	public function valid(){
		App::import('Lib', 'Util');
		
		// 日付
		if($this->startDate === ""){
			$this->isValid = true;
			$this->errorMessage[] = "開始日付を入力してください。";
		} else if(strlen($this->startDate) !== 10){
			$this->isValid = true;
			$this->errorMessage[] = "有効な開始日付を入力してください。";
		} else {
			$year = substr($this->startDate, 0, 4);
			$month = substr($this->startDate, 5, 2);
			$day = substr($this->startDate, 8, 2);
			
			if(!checkdate($month, $day, $year)){
				$this->isValid = true;
				$this->errorMessage[] = "有効な開始日付を入力してください。";
			}
		}
		
		if($this->endDate === ""){
			$this->isValid = true;
			$this->errorMessage[] = "終了日付を入力してください。";
		} else if(strlen($this->endDate) !== 10){
			$this->isValid = true;
			$this->errorMessage[] = "有効な終了日付を入力してください。";
		} else {
			$year = substr($this->endDate, 0, 4);
			$month = substr($this->endDate, 5, 2);
			$day = substr($this->endDate, 8, 2);
			
			if(!checkdate($month, $day, $year)){
				$this->isValid = true;
				$this->errorMessage[] = "有効な終了日付を入力してください。";
			}
		}

	}

	// バリデーションが成功か失敗かを返す
	// false : 成功
	// true : 失敗
	public function isValid(){
		return $this->isValid;
	}


	// 検索条件文字列を作成
	// 戻り値: 検索文字列
	public function getSearchString(){
		// 検索条件の生成
		$searchString = "";
		$andFlag = false;
		if($this->id !== ""){
			$searchString .= "operator_id = '{$this->id}'";
			$andFlag = true;
		}

		if($this->startDate !== ""){
			if($andFlag){
				$searchString .= " and ";
			}
			$searchString .= "login_date > {$this->startDate}";
			$andFlag = true;
		}
		
		if($this->startDate !== ""){
			if($andFlag){
				$searchString .= " and ";
			}
			$searchString .= "login_date < {$this->endDate}";
			$andFlag = true;
		}
		return $searchString;
	}
}

?>