<?php

class EditPasswordData {
	public $id;
	public $password;
	public $password2;

	public $encryptedPassword;

	public $isValid = false;
	public $errorMessage = array();

	public function setEncryptedPassword(){
		$this->encryptedPassword = Security::hash($this->password);
	}

	// バリデーションを行う
	public function valid(){
		App::import('Lib', 'Util');
		// パスワード
		if($this->password === ""){
			$this->isValid = true;
			$this->errorMessage[] = "パスワードを入力してください";
		}

		if($this->password !== "" && !Util::validatePassword($this->password)){
			$this->isValid = true;
			$this->errorMessage[] = "パスワードは半角英数字6文字-20文字で入力してください。また、英大文字、英小文字、数字の3種類の文字を含む必要があります";
		}

		if($this->password !== $this->password2){
			$this->isValid = true;
			$this->errorMessage[] = "パスワードとパスワード（再入力）が違います";
		}
	}

	// バリデーションが成功か失敗かを返す
	// false : 成功
	// true : 失敗
	public function isValid(){
		return $this->isValid;
	}
	
	
}

?>