<?php

class EditUserData {
	public $id;
	public $operatorName;
	public $roleRead;
	public $roleWrite;
	public $roleCSVDownload;
	public $roleUserManager;
	public $lockFlag;
	public $disabled;

	public $isValid = false;
	public $errorMessage = array();

	// バリデーションを行う
	public function valid(){
		App::import('Lib', 'Util');
		
		// オペレータ名 check
		if($this->operatorName === ""){
			$this->isValid = true;
			$this->errorMessage[] = "オペレータ名を入力してください";
		}

		if(strlen($this->operatorName) > 20){
			$this->isValid = true;
			$this->errorMessage[] = "オペレータ名は20文字以内で入力してください";
		}

		if($this->operatorName !== "" && Util::includeSpecialCharacter($this->operatorName)){
			$this->isValid = true;
			$this->errorMessage[] = "オペレータ名に機種依存文字は使えません";
		}

		// ロール
		if(!$this->roleRead && !$this->roleWrite && !$this->roleCSVDownload && !$this->roleUserManager){
			$this->isValid = true;
			$this->errorMessage[] = "ロールは1つ以上選択してください";
		}

	}

	// バリデーションが成功か失敗かを返す
	// false : 成功
	// true : 失敗
	public function isValid(){
		return $this->isValid;
	}
	
	public function getRole(){
		$ret = "";
		$commaFlag = false;
		if($this->roleRead){
			$ret = "1";
			$commaFlag = true;
		}
		if($this->roleWrite){
			if($commaFlag) {
				$ret .= ",";
			}
			$ret .= "2";
			$commaFlag = true;
		}
		if($this->roleCSVDownload){
			if($commaFlag) {
				$ret .= ",";
			}
			$ret .= "3";
			$commaFlag = true;
		}
		if($this->roleUserManager){
			if($commaFlag) {
				$ret .= ",";
			}
			$ret .= "4";
			$commaFlag = true;
		}

		return $ret;
	}

	public function getRoleString(){
		$ret = "";
		$commaFlag = false;
		if($this->roleRead){
			$ret = "Read";
			$commaFlag = true;
		}
		if($this->roleWrite){
			if($commaFlag) {
				$ret .= ",";
			}
			$ret .= "Write";
			$commaFlag = true;
		}
		if($this->roleCSVDownload){
			if($commaFlag) {
				$ret .= ",";
			}
			$ret .= "CSV Download";
			$commaFlag = true;
		}
		if($this->roleUserManager){
			if($commaFlag) {
				$ret .= ",";
			}
			$ret .= "User Manager";
			$commaFlag = true;
		}

		return $ret;
	}
}

?>