<?php

class LoginData {
	public $id;
	public $operatorName;
	public $roleRead;
	public $roleWrite;
	public $roleCSVDownload;
	public $roleUserManager;
	public $password;

	public $isValid = false;
	public $errorMessage = array();

	// バリデーションを行う
	public function valid(){
		App::import('Lib', 'Util');
		
		// オペレータID check
		if($this->id === ""){
			$this->isValid = true;
			$this->errorMessage[] = "オペレータIDを入力してください";
		}

		// オペレータID check
		if($this->password === ""){
			$this->isValid = true;
			$this->errorMessage[] = "パスワードを入力してください";
		}
	}

	// バリデーションが成功か失敗かを返す
	// false : 成功
	// true : 失敗
	public function isValid(){
		return $this->isValid;
	}
	
	public function getRole(){
		$ret = "";
		$commaFlag = false;
		if($this->roleRead){
			$ret = "1";
			$commaFlag = true;
		}
		if($this->roleWrite){
			if($commaFlag) {
				$ret .= ",";
			}
			$ret .= "2";
			$commaFlag = true;
		}
		if($this->roleCSVDownload){
			if($commaFlag) {
				$ret .= ",";
			}
			$ret .= "3";
			$commaFlag = true;
		}
		if($this->roleUserManager){
			if($commaFlag) {
				$ret .= ",";
			}
			$ret .= "4";
			$commaFlag = true;
		}

		return $ret;
	}

	public function getRoleString(){
		$ret = "";
		$commaFlag = false;
		if($this->roleRead){
			$ret = "Read";
			$commaFlag = true;
		}
		if($this->roleWrite){
			if($commaFlag) {
				$ret .= ",";
			}
			$ret .= "Write";
			$commaFlag = true;
		}
		if($this->roleCSVDownload){
			if($commaFlag) {
				$ret .= ",";
			}
			$ret .= "CSV Download";
			$commaFlag = true;
		}
		if($this->roleUserManager){
			if($commaFlag) {
				$ret .= ",";
			}
			$ret .= "User Manager";
			$commaFlag = true;
		}

		return $ret;
	}
}

?>