<?php

class LoginLogSearchCondition {
	public $id;
	public $startDate;
	public $endDate;

	public $isValid = false;
	public $errorMessage = array();
	
	// バリデーションを行う
	public function valid(){
		App::import('Lib', 'Util');

	}

	// バリデーションが成功か失敗かを返す
	// false : 成功
	// true : 失敗
	public function isValid(){
		return $this->isValid;
	}


	// 検索条件文字列を作成
	// 戻り値: 検索文字列
	public function getSearchString(){
		// 検索条件の生成
		$searchString = "";
		$andFlag = false;
		if($this->id !== ""){
			$searchString .= "operator_id = '{$this->id}'";
			$andFlag = true;
		}

		if($this->startDate !== ""){
			if($andFlag){
				$searchString .= " and ";
			}
			$searchString .= "login_date > {$this->startDate}";
			$andFlag = true;
		}
		
		if($this->startDate !== ""){
			if($andFlag){
				$searchString .= " and ";
			}
			$searchString .= "login_date < {$this->endDate}";
			$andFlag = true;
		}
		return $searchString;
	}
}

?>