<?php

class PasswordChangeData {
	public $id;
	public $oldPassword;
	public $password;
	public $password2;

	public $encryptedPassword;

	public $isValid = false;
	public $errorMessage = array();

	public function setEncryptedPassword(){
		$this->encryptedPassword = Security::hash($this->password);
	}

	// バリデーションを行う
	public function valid(){
		App::import('Lib', 'Util');
		// ユーザID
		if($this->id === ""){
			$this->isValid = true;
			$this->errorMessage[] = "オペレータIDを入力してください";
		}

		if(strlen($this->id) > 20){
			$this->isValid = true;
			$this->errorMessage[] = "オペレータIDは20文字以内で入力してください";
		}
		
		// 旧パスワード
		if($this->oldPassword === ""){
			$this->isValid = true;
			$this->errorMessage[] = "現在のパスワードを入力してください";
		}

		// パスワード
		if($this->password === ""){
			$this->isValid = true;
			$this->errorMessage[] = "新パスワードを入力してください";
		}

		if($this->password !== "" && !Util::validatePassword($this->password)){
			$this->isValid = true;
			$this->errorMessage[] = "新パスワードは半角英数字6文字-20文字で入力してください。また、英大文字、英小文字、数字の3種類の文字を含む必要があります";
		}

		if($this->password !== $this->password2){
			$this->isValid = true;
			$this->errorMessage[] = "新パスワードと新パスワード（再入力）が違います";
		}
	}

	// バリデーションが成功か失敗かを返す
	// false : 成功
	// true : 失敗
	public function isValid(){
		return $this->isValid;
	}
	
	
}

?>