<?php

class SearchCondition {
	public $id;
	public $seiKanji;
	public $meiKanji;
	public $seiKana;
	public $meiKana;
	public $zip;
	public $email;
	public $fromDate;
	public $toDate;

	public $isValid = false;
	public $errorMessage = array();
	
	// バリデーションを行う
	public function valid(){
		App::import('Lib', 'Util');

		// 申込番号 check
		if($this->id !== "" && !Util::isNumeric($this->id)){
			$this->isValid = true;
			$this->errorMessage[] = "申込番号は半角数字で入力してください。";
		}

		// 姓（漢字） check
		if(strlen($this->seiKanji) > 20){
			$this->isValid = true;
			$this->errorMessage[] = "姓（漢字）は２０文字以内で入力してください。";
		}

		// 名（漢字） check
		if(strlen($this->meiKanji) > 20){
			$this->isValid = true;
			$this->errorMessage[] = "名（漢字）は２０文字以内で入力してください。";
		}

		// 姓（カナ） check
		if(strlen($this->seiKana) > 20){
			$this->isValid = true;
			$this->errorMessage[] = "姓（カナ）は２０文字以内で入力してください。";
		}

		// 名（カナ） check
		if(strlen($this->meiKana) > 20){
			$this->isValid = true;
			$this->errorMessage[] = "名（カナ）は２０文字以内で入力してください。";
		}

		// 郵便番号 check
		if($this->zip !== "" && !Util::isNumeric($this->zip)){
			$this->isValid = true;
			$this->errorMessage[] = "郵便番号は半角数字で入力してください。";
		}

		// メールアドレス check
		if(strlen($this->email) > 50){
			$this->isValid = true;
			$this->errorMessage[] = "メールアドレスは５０文字以内で入力してください。";
		}

		if(strlen($this->email) > 0){
			if(!Util::isMail($this->email)){
				$this->isValid = true;
				$this->errorMessage[] = "正しいメールアドレスを入力してください。";
			}
		}
		
		// 申込日付
		if(strlen($this->fromDate) === 0){
		} else if(strlen($this->fromDate) !== 10){
			$this->isValid = true;
			$this->errorMessage[] = "有効な申込日付（開始）を入力してください。";
		} else {
			$year = substr($this->fromDate, 0, 4);
			$month = substr($this->fromDate, 5, 2);
			$day = substr($this->fromDate, 8, 2);
			
			if(!checkdate($month, $day, $year)){
				$this->isValid = true;
				$this->errorMessage[] = "有効な申込日付（開始）を入力してください。";
			}
		}
		
		if(strlen($this->toDate) === 0){
		} else if(strlen($this->toDate) !== 10){
			$this->isValid = true;
			$this->errorMessage[] = "有効な申込日付（終了）を入力してください。";
		} else {
			$year = substr($this->toDate, 0, 4);
			$month = substr($this->toDate, 5, 2);
			$day = substr($this->toDate, 8, 2);
			
			if(!checkdate($month, $day, $year)){
				$this->isValid = true;
				$this->errorMessage[] = "有効な申込日付（終了）を入力してください。";
			}
		}

	}

	// バリデーションが成功か失敗かを返す
	// false : 成功
	// true : 失敗
	public function isValid(){
		return $this->isValid;
	}

	// 検索条件文字列を作成
	// 戻り値: 検索文字列
	public function getSearchString(){
		App::import('Lib', 'Util');

		// 検索条件の生成
		$searchString = "";
		$andFlag = false;
		if($this->id !== ""){
			$tmp = Util::mysqlEscape($this->id);
			
			$searchString .= "id = $tmp";
			$andFlag = true;
		}
	 
		if($this->seiKanji !== ""){
			if($andFlag){
				$searchString .= " and ";
			}
			$tmp = Util::mysqlEscape($this->seiKanji);
			
			$searchString .= "sei_kanji Like '%{$tmp}%'";
			$andFlag = true;
		}
		
		if($this->meiKanji !== ""){
			if($andFlag){
				$searchString .= " and ";
			}
			$tmp = Util::mysqlEscape($this->meiKanji);

			$searchString .= "mei_kanji Like '%{$tmp}%'";
			$andFlag = true;
		}
		
		if($this->seiKana !== ""){
			if($andFlag){
				$searchString .= " and ";
			}
			$tmp = Util::mysqlEscape($this->seiKana);
			
			$searchString .= "sei_kana Like '%{$tmp}%'";
			$andFlag = true;
		}

		if($this->meiKana !== ""){
			if($andFlag){
				$searchString .= " and ";
			}
			$tmp = Util::mysqlEscape($this->meiKana);
			
			$searchString .= "mei_kana Like '%{$tmp}%'";
			$andFlag = true;
		}

		if($this->zip !== ""){
			if($andFlag){
				$searchString .= " and ";
			}
			$searchString .= "concat(zip1,zip2) = '{$this->zip}'";
			$andFlag = true;
		}

		if($this->email !== ""){
			if($andFlag){
				$searchString .= " and ";
			}
			$tmp = Util::mysqlEscape($this->email);
			
			$searchString .= "e_mail = '{$tmp}'";
			$andFlag = true;
		}

		if($this->fromDate !== ""){
			if($andFlag){
				$searchString .= " and ";
			}
			$searchString .= "request_date > '{$this->fromDate}'";
			$andFlag = true;
		}

		if($this->toDate !== ""){
			if($andFlag){
				$searchString .= " and ";
			}
			$tmpDate = date('Y/m/d', strtotime($this->toDate ." 1 day"));
			
			$searchString .= "request_date < '{$tmpDate}'";
			$andFlag = true;
		}

		return $searchString;
	}
}

?>