<?php

class StatusChangeData {
	public $id;
	public $oldStatus;
	public $oldStatusText;
	public $newStatus;
	public $newStatusText;
	public $comment;

	private $constStatus = array("" => "", 
								"0" => "正常", 
								"1" => "住所不明",
								"2" => "処理不可能",
								"3" => "発送停止",
								"9" => "その他"
								);
	
	public $isValid = false;
	public $errorMessage = array();

	// ステータスを文字列にコンバートする
	public function convertStatus($value){
		if(isset($this->constStatus[$value])){
			$str = $this->constStatus[$value];
		} else {
			throw new Exception("配列範囲外エラー");
		}

		return $str;
	}

	// バリデーションを行う
	public function valid(){
		App::import('Lib', 'Util');
		
		// コメント check
		if(strlen($this->comment) > 256){
			$this->isValid = true;
			$this->errorMessage[] = "コメントは256文字以内で入力してください。";
		}

		if(Util::includeSpecialCharacter($this->comment)){
			$this->isValid = true;
			$this->errorMessage[] = "コメントに機種依存文字は使えません。";
		}

	}

	// バリデーションが成功か失敗かを返す
	// false : 成功
	// true : 失敗
	public function isValid(){
		return $this->isValid;
	}

}

?>