<?php

class UserSearchCondition {
	public $id;
	
	public $isValid = false;
	public $errorMessage = array();
	
	// バリデーションを行う
	public function valid(){
		App::import('Lib', 'Util');

		// オペレータID check
		if(strlen($this->id) > 20){
			$this->isValid = true;
			$this->errorMessage[] = "オペレータIDは20文字以内で入力してください";
		}
		
		if($this->id !== "" && !Util::isAlphaNumeric($this->id)){
			$this->isValid = true;
			$this->errorMessage[] = "オペレータIDは半角英数字で入力してください";
		}


	}

	// バリデーションが成功か失敗かを返す
	// false : 成功
	// true : 失敗
	public function isValid(){
		return $this->isValid;
	}


	// 検索条件文字列を作成
	// 戻り値: 検索文字列
	public function getSearchString(){
		// 検索条件の生成
		$searchString = "";
		if($this->id !== ""){
			$searchString .= "id = $this->id";
		}
		return $searchString;
	}
}

?>