<?php

class Util {
	public static function zeroPadding($str, $num){
		return sprintf('%0' . $num .'d', $str);
	}

	public static function includeHarfCharacter($str){
		$pattern = '/[ -~｡-ﾟ]+/u';
		return preg_match($pattern, $str);
	}

	public static function isAlphaNumeric($str){
		$pattern = '/[0-9a-zA-Z]+/u';
		return preg_match($pattern, $str);
	}

	public static function includeZenAlphabet($str){
		$pattern = '/[ａ-ｚＡ-Ｚ]+/u';
		
		return preg_match($pattern, $str);
	}

	public static function includeZenNumeric($str){
		$pattern = '/[０-９]+/u';
		
		return preg_match($pattern, $str);
	}

	public static function includeSpecialCharacter($str){
		$pattern = '/[①②③④⑤⑥⑦⑧⑨⑩⑪⑫⑬⑭⑮⑯⑰⑱⑲⑳ⅠⅡⅢⅣⅤ≡∑∫∮√⊥∠∟⊿∵∩∪№㏍℡㊤㊥㊦㊧㊨㈱㈲㈹㍾㍽㍼㍻㍉㎜㎝㎞㎎㎏㏄㍉㌔㌢㍍㌘㌧㌃㌶㍑㍗㌍㌦㌣㌫㍊㌻ⅠⅡⅢⅣⅤⅥⅦⅧⅨⅩ]+/u';
		
		return preg_match($pattern, $str);
	}

	public static function isKatakana($str){
		$pattern = '/[ァ-ヶ|ー]+/u';
		
		return preg_match($pattern, $str);
	}

	public static function isNumeric($str){
		$pattern = '/[0-9]+/u';
		
		return preg_match($pattern, $str);
	}

	public static function isMail($str){
		$pattern = '/^[a-zA-Z_0-9]+([-+.][a-zA-Z_0-9]+)*@[a-zA-Z_0-9]+([-.][a-zA-Z_0-9]+)*\.[a-zA-Z_0-9]+([-.][a-zA-Z_0-9]+)*$/u';
		
		return preg_match($pattern, $str);
	}

	public static function validatePassword($str){
		$pattern1 = '/^[0-9a-zA-Z]{6,20}$/u';
		$pattern2 = '/[0-9]/u';
		$pattern3 = '/[a-z]/u';
		$pattern4 = '/[A-Z]/u';
		
		if(preg_match($pattern1, $str)){
			if(preg_match($pattern2, $str) && preg_match($pattern3, $str) && preg_match($pattern4, $str)){
				return true;
			}
		}
		return false;
	}

	public static function getMaskPassword($str, $mask = "*"){
		$len = strlen($str);
		$ret = "";

		for($i = 0; $i < $len; $i++){
			$ret .= $mask;
		}

		return $ret;
	}

	public static function mysqlEscape($str){
		$ret = str_replace("'", "''", $str);
		$ret = str_replace("\\", "\\\\", $ret);

		return $ret;
	}
}

?>