/*
 * Decompiled with CFR 0.152.
 */
package org.h2.util;

import java.sql.SQLException;

public abstract class HashBase {
    protected int mask;
    protected int len;
    protected int size;
    protected int deletedCount;
    protected int level;
    protected boolean zeroKey;
    private int maxSize;
    private int minSize;
    private int maxDeleted;
    private static final int MAX_LOAD = 90;

    protected abstract void rehash(int var1) throws SQLException;

    public HashBase() {
        this.reset(2);
    }

    public int size() {
        return this.size + (this.zeroKey ? 1 : 0);
    }

    protected void checkSizePut() throws SQLException {
        if (this.deletedCount > this.size) {
            this.rehash(this.level);
        }
        if (this.size + this.deletedCount >= this.maxSize) {
            this.rehash(this.level + 1);
        }
    }

    protected void checkSizeRemove() throws SQLException {
        if (this.size < this.minSize && this.level > 0) {
            this.rehash(this.level - 1);
        } else if (this.deletedCount > this.maxDeleted) {
            this.rehash(this.level);
        }
    }

    protected void reset(int newLevel) {
        this.minSize = this.size * 3 / 4;
        this.size = 0;
        this.level = newLevel;
        this.len = 2 << this.level;
        this.mask = this.len - 1;
        this.maxSize = (int)((long)(this.len * 90) / 100L);
        this.deletedCount = 0;
        this.maxDeleted = 20 + this.len / 2;
    }

    protected int getIndex(int hash) {
        return hash & this.mask;
    }
}

