/*
 * Decompiled with CFR 0.152.
 */
package org.h2.result;

import java.sql.SQLException;
import org.h2.constant.SysProperties;
import org.h2.engine.Database;
import org.h2.expression.Expression;
import org.h2.util.ObjectArray;
import org.h2.util.RandomUtils;
import org.h2.util.StringUtils;
import org.h2.value.Value;
import org.h2.value.ValueNull;

public class SortOrder {
    public static final int ASCENDING = 0;
    public static final int DESCENDING = 1;
    public static final int NULLS_FIRST = 2;
    public static final int NULLS_LAST = 4;
    private static final int DEFAULT_NULL_SORT = SysProperties.SORT_NULLS_HIGH ? 1 : -1;
    private Database database;
    private int len;
    private int[] indexes;
    private int[] sortTypes;

    public SortOrder(Database database, int[] index, int[] sortType) {
        this.database = database;
        this.indexes = index;
        this.sortTypes = sortType;
        this.len = index.length;
    }

    public String getSQL(Expression[] list, int visible) {
        StringBuffer buff = new StringBuffer();
        for (int i = 0; i < this.len; ++i) {
            int idx;
            if (i > 0) {
                buff.append(", ");
            }
            if ((idx = this.indexes[i]) < visible) {
                buff.append(idx + 1);
            } else {
                buff.append("=");
                buff.append(StringUtils.unEnclose(list[idx].getSQL()));
            }
            int type = this.sortTypes[i];
            if ((type & 1) != 0) {
                buff.append(" DESC");
            }
            if ((type & 2) != 0) {
                buff.append(" NULLS FIRST");
                continue;
            }
            if ((type & 4) == 0) continue;
            buff.append(" NULLS LAST");
        }
        return buff.toString();
    }

    public static int compareNull(boolean aNull, boolean bNull, int type) {
        if ((type & 2) != 0) {
            return aNull ? -1 : 1;
        }
        if ((type & 4) != 0) {
            return aNull ? 1 : -1;
        }
        int comp = aNull ? DEFAULT_NULL_SORT : -DEFAULT_NULL_SORT;
        return (type & 1) == 0 ? comp : -comp;
    }

    public int compare(Value[] a, Value[] b) throws SQLException {
        for (int i = 0; i < this.len; ++i) {
            boolean bNull;
            int idx = this.indexes[i];
            int type = this.sortTypes[i];
            Value ao = a[idx];
            Value bo = b[idx];
            boolean aNull = ao == ValueNull.INSTANCE;
            boolean bl = bNull = bo == ValueNull.INSTANCE;
            if (aNull || bNull) {
                if (aNull == bNull) continue;
                return SortOrder.compareNull(aNull, bNull, type);
            }
            int comp = this.database.compare(ao, bo);
            if (comp == 0) continue;
            return (type & 1) == 0 ? comp : -comp;
        }
        return 0;
    }

    public void sort(ObjectArray rows) throws SQLException {
        this.sort(rows, 0, rows.size() - 1);
    }

    private void swap(ObjectArray rows, int a, int b) {
        Object t = rows.get(a);
        rows.set(a, rows.get(b));
        rows.set(b, t);
    }

    private void sort(ObjectArray rows, int l, int r) throws SQLException {
        int j;
        int i;
        while (r - l > 10) {
            i = RandomUtils.nextInt(r - l - 4) + l + 2;
            if (this.compare((Value[])rows.get(l), (Value[])rows.get(r)) > 0) {
                this.swap(rows, l, r);
            }
            if (this.compare((Value[])rows.get(i), (Value[])rows.get(l)) < 0) {
                this.swap(rows, l, i);
            } else if (this.compare((Value[])rows.get(i), (Value[])rows.get(r)) > 0) {
                this.swap(rows, i, r);
            }
            j = r - 1;
            this.swap(rows, i, j);
            Value[] p = (Value[])rows.get(j);
            i = l;
            while (true) {
                if (this.compare((Value[])rows.get(++i), p) < 0) {
                    continue;
                }
                while (this.compare((Value[])rows.get(--j), p) > 0) {
                }
                if (i >= j) break;
                this.swap(rows, i, j);
            }
            this.swap(rows, i, r - 1);
            this.sort(rows, l, i - 1);
            l = i + 1;
        }
        for (i = l + 1; i <= r; ++i) {
            Value[] t = (Value[])rows.get(i);
            for (j = i - 1; j >= l && this.compare((Value[])rows.get(j), t) > 0; --j) {
                rows.set(j + 1, rows.get(j));
            }
            rows.set(j + 1, t);
        }
    }

    public int[] getIndexes() {
        return this.indexes;
    }

    public int[] getSortTypes() {
        return this.sortTypes;
    }
}

