/*
 * Copyright 2004-2008 the Seasar Foundation and the Others.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND,
 * either express or implied. See the License for the specific language
 * governing permissions and limitations under the License.
 */
package jp.yoyoyoyo.webform.action;

import javax.annotation.Resource;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpSession;

import org.seasar.extension.jdbc.JdbcManager;
import org.seasar.struts.annotation.Execute;
import org.seasar.struts.annotation.ActionForm;

import jp.yoyoyoyo.webform.dto.EntryDto;
import jp.yoyoyoyo.webform.dto.InsertRequestDto;
import jp.yoyoyoyo.webform.form.EntryForm;

public class EntryAction {

	@Resource
	@ActionForm
	protected EntryForm entryForm;
	
	@Resource
	protected HttpServletRequest request;
	
	@Resource
	protected HttpSession session;

	@Resource
	protected JdbcManager jdbcManager;
	
	// 確認画面表示用オブジェクト
	public EntryDto entryDto;
	
	// 完了画面表示用オブジェクト
	public String insertId;
	   
	
	// 入力画面表示
    @Execute(validator = false)
    public String entry(){
    	return "entry.jsp";
    }
     
    // 入力画面で次へボタンを押したときの処理
    @Execute(validator = true, input="entry.jsp")
    public String next(){
    	// 入力フォームに登録したデータを表示用オブジェクトに渡す
    	entryDto.seiKanji = entryForm.seiKanji;
    	entryDto.meiKanji = entryForm.meiKanji;
    	entryDto.seiKana = entryForm.seiKana;
    	entryDto.meiKana = entryForm.meiKana;
       	entryDto.birthDate  = entryForm.birthDate;
       	entryDto.gender  = entryForm.constGender.get(entryForm.gender);
       	entryDto.zip1  = entryForm.zip1;
       	entryDto.zip2  = entryForm.zip2;
       	entryDto.address1  = entryForm.address1;
       	entryDto.address2  = entryForm.address2;
       	entryDto.address3  = entryForm.address3;
       	entryDto.address4  = entryForm.address4;
       	entryDto.tel  = entryForm.tel1 + "-" + entryForm.tel2 + "-" + entryForm.tel3;
       	entryDto.eTel  = entryForm.eTel1 + "-" + entryForm.eTel2 + "-" + entryForm.eTel3;  	
      	entryDto.email  = entryForm.email1;
      	entryDto.occupation  = entryForm.constOccupation.get(entryForm.occupation);
      	
      	entryForm.ipAddress = request.getRemoteAddr();
      	entryForm.sessionId = session.getId();
      	
      	// セッションに保存する
      	session.setAttribute("entrydata", entryForm);
      	
       	return "confirm.jsp";
    }
       
    // 確認画面で戻るボタンを押したときの処理
    @Execute(validator = false)
    public String back(){
    	EntryForm tmp;
    	
    	tmp = (EntryForm)session.getAttribute("entrydata");
    	
      	// セッションが見つからないときは入力画面へ
    	if(tmp == null){
    		return "entry.jsp";
    	}
    	
    	// フォームに値をセットする
    	entryForm.seiKanji = tmp.seiKanji;
    	entryForm.meiKanji = tmp.meiKanji;
    	entryForm.seiKana = tmp.seiKana; 	
    	entryForm.meiKana = tmp.meiKana; 	
    	entryForm.birthDate = tmp.birthDate;
    	entryForm.gender = tmp.gender; 
    	entryForm.zip1 = tmp.zip1; 
    	entryForm.zip2 = tmp.zip2;
    	entryForm.address1 = tmp.address1;
    	entryForm.address2 = tmp.address2;
    	entryForm.address3 = tmp.address3;
    	entryForm.address4 = tmp.address4;
    	entryForm.tel1 = tmp.tel1;
    	entryForm.tel2 = tmp.tel2;
    	entryForm.tel3 = tmp.tel3;
    	entryForm.eTel1 = tmp.eTel1;
    	entryForm.eTel2 = tmp.eTel2;
    	entryForm.eTel3 = tmp.eTel3;
    	entryForm.email1 = tmp.email1;
    	entryForm.email2 = tmp.email2;
    	entryForm.occupation = tmp.occupation;
    	
    	return "entry.jsp";
    }
    
    // 確認画面で保存ボタンを押したときの処理
    @Execute(validator = false)
    public String save(){
    	EntryForm tmp;
    	InsertRequestDto requestDto = new InsertRequestDto();
    	
    	// セッションからオブジェクトの取り出し
    	tmp = (EntryForm)session.getAttribute("entrydata");
    	
    	// セッションが見つからないときは入力画面へ
    	if(tmp == null){
    		return "entry.jsp";
    	}
    	
    	// ストアド用パラメータに設定
    	requestDto.seiKanji = tmp.seiKanji;
    	requestDto.meiKanji = tmp.meiKanji;
    	requestDto.seiKana = tmp.seiKana;
    	requestDto.meiKana = tmp.meiKana;
    	requestDto.birthDate = tmp.birthDate; 
    	requestDto.gender = tmp.gender.intValue();
    	requestDto.genderText = tmp.constGender.get(tmp.gender);
    	requestDto.zip1 = tmp.zip1;
    	requestDto.zip2 = tmp.zip2;
    	requestDto.address1 = tmp.address1;
    	requestDto.address2 = tmp.address2;
    	requestDto.address3 = tmp.address3;
    	requestDto.address4 = tmp.address4;
    	requestDto.tel1 = tmp.tel1;
    	requestDto.tel2 = tmp.tel2;
    	requestDto.tel3 = tmp.tel3;
    	requestDto.eTel1 = tmp.eTel1;
    	requestDto.eTel2 = tmp.eTel2;
    	requestDto.eTel3 = tmp.eTel3;
    	requestDto.email = tmp.email1;
    	requestDto.occupation = tmp.occupation.intValue();
    	requestDto.occupationText = tmp.constOccupation.get(tmp.occupation);
    	requestDto.ipAddress = tmp.ipAddress;
    	requestDto.sessionId = tmp.sessionId;
    	
    	try{
    	   	// ストアド実行
        	jdbcManager.call("insert_request", requestDto).execute();
    	} catch (Exception e){
    		// セッションの破棄
        	session.invalidate();
        	// メインテナンス画面へ
    		return "maintenance.jsp";
    	}
 
    	    	
    	// 申込番号を設定
    	this.insertId = String.valueOf(requestDto.id); 
    
    	// セッションの破棄
    	session.invalidate();
    	
    	return "thankyou.jsp";
    }
    
}
