package jp.yoyoyoyo.webform.action;


import java.io.FileInputStream;

import javax.annotation.Resource;

import javax.servlet.ServletContext;
import javax.servlet.http.HttpServletRequest;
import javax.xml.parsers.SAXParserFactory;

import jp.yoyoyoyo.webform.form.PostalForm;

import org.seasar.struts.annotation.ActionForm;
import org.seasar.struts.annotation.Execute;
import org.seasar.struts.util.ServletContextUtil;
import org.xml.sax.Attributes;
import org.xml.sax.helpers.DefaultHandler;

import javax.xml.parsers.SAXParser;



public class PostalAction {
	
	@Resource
	@ActionForm
	protected PostalForm postalForm;
	
	@Resource
	protected HttpServletRequest request;
	
	@Execute(validator = false)
	public String postal(){
		postalForm.postalAddress1 = "";
		postalForm.postalAddress2 = "";
		postalForm.postalAddress3 = "";
		
		// Getパラメータの取得
		String postalCode = request.getParameter("c");
		// postal.xmlへのパス取得
		ServletContext context = ServletContextUtil.getServletContext();
		String path = context.getRealPath("/WEB-INF/view/postal/postal.xml");
		// XMLから該当郵便番号の住所を取得する処理
		SAXParserFactory spf = SAXParserFactory.newInstance();
		try{
			SAXParser parser = spf.newSAXParser();
			
			PostalHandler ph = new PostalHandler();
			
			ph.postalCode = postalCode;
			ph.searchString = "address1";
			
			parser.parse(new FileInputStream(path),ph);

	        postalForm.postalAddress1 = ph.result1;
	        postalForm.postalAddress2 = ph.result2;
	        postalForm.postalAddress3 = ph.result3;	
			
		} catch (Exception e){
			// エラーが発生したときは空文字をセットする
			postalForm.postalAddress1 = "";
		    postalForm.postalAddress2 = "";
		    postalForm.postalAddress3 = "";	
		}

		return "postal.jsp";
	}
}

class PostalHandler extends DefaultHandler{

	public String postalCode = "";
	
	public String searchString = "";
	
	public String result1 = "";
	public String result2 = "";
	public String result3 = "";

	private boolean pFlag = false;
	private boolean aFlag = false;
	private boolean a1Flag = false;
	private boolean a2Flag = false;
	private boolean a3Flag = false;
	
	public void startDocument() {
		
	}

	public void endDocument() {
		
	}

	public void startElement(String namespaceURI,
                               String localName,
                               String qName,
                               Attributes atts) {

        if(qName=="postalcode"){
        	pFlag = true;
        }else if (qName == "address1"){
        	a1Flag = true;
        }else if (qName == "address2"){
        	a2Flag = true;
        }else if (qName == "address3"){
        	a3Flag = true;
        }
	}

    public void endElement(String namespaceURI,
                             String localName,
                             String qName) {
        if(qName=="postalcode"){
        	pFlag = false;
        }else if (qName == "address1"){
        	a1Flag = false;
        }else if (qName == "address2"){
        	a2Flag = false;
        }else if (qName == "address3"){
        	a3Flag = false;
        }
    }

    public void characters(char[] ch, int start, int length) {
    	String text = new String(ch,start,length);
    	if(pFlag == true && postalCode.equals(text)){
      		aFlag = true;
    	}
    	if(aFlag == true && a1Flag == true){
    		this.result1 = text;
    	}
    	if(aFlag == true && a2Flag == true){
    		this.result2 = text;
    	}    	
    	if(aFlag == true && a3Flag == true){
    		this.result3 = text;
    		aFlag = false;
    	} 	
    }

}


