package jp.yoyoyoyo.webform.form;

import java.io.Serializable;
import java.util.HashMap;

import org.seasar.struts.annotation.DateType;
import org.seasar.struts.annotation.EmailType;
import org.seasar.struts.annotation.Mask;
import org.seasar.struts.annotation.Maxlength;
import org.seasar.struts.annotation.Msg;
import org.seasar.struts.annotation.Required;
import org.seasar.struts.annotation.Arg; 
import org.seasar.struts.annotation.Validwhen;

// 入力フォーム用データ
public class EntryForm implements Serializable {

	private static final long serialVersionUID = 1L;

	@Required(arg0 = @Arg(key = "姓（漢字）", resource = false))
	@Maxlength(maxlength = 20, msg=@Msg(key="姓（漢字）は２０文字以内で入力してください",resource = false))
	@Mask(mask = "^[^０-９ａ-ｚＡ-Ｚ -~｡-ﾟ①②③④⑤⑥⑦⑧⑨⑩⑪⑫⑬⑭⑮⑯⑰⑱⑲⑳ⅠⅡⅢⅣⅤ≡∑∫∮√⊥∠∟⊿∵∩∪№㏍℡㊤㊥㊦㊧㊨㈱㈲㈹㍾㍽㍼㍻㍉㎜㎝㎞㎎㎏㏄㍉㌔㌢㍍㌘㌧㌃㌶㍑㍗㌍㌦㌣㌫㍊㌻ⅠⅡⅢⅣⅤⅥⅦⅧⅨⅩ]+$", msg=@Msg(key="姓（漢字）に使用できない文字です（全角英数字・半角・機種依存文字）",resource = false))
	public String seiKanji;
	
	@Required(arg0 = @Arg(key = "名（漢字）", resource = false))
	@Maxlength(maxlength = 20, msg=@Msg(key="名（漢字）は２０文字以内で入力してください",resource = false))
	@Mask(mask = "^[^０-９ａ-ｚＡ-Ｚ -~｡-ﾟ①②③④⑤⑥⑦⑧⑨⑩⑪⑫⑬⑭⑮⑯⑰⑱⑲⑳ⅠⅡⅢⅣⅤ≡∑∫∮√⊥∠∟⊿∵∩∪№㏍℡㊤㊥㊦㊧㊨㈱㈲㈹㍾㍽㍼㍻㍉㎜㎝㎞㎎㎏㏄㍉㌔㌢㍍㌘㌧㌃㌶㍑㍗㌍㌦㌣㌫㍊㌻ⅠⅡⅢⅣⅤⅥⅦⅧⅨⅩ]+$", msg=@Msg(key="名（漢字）に使用できない文字です（全角英数字・半角・機種依存文字）",resource = false))	
	public String meiKanji;
	
	@Required(arg0 = @Arg(key = "姓（カナ）", resource = false))
	@Maxlength(maxlength = 20, msg=@Msg(key="姓（カナ）は２０文字以内で入力してください",resource = false))	
	@Mask(mask = "^[ァ-ヶ|ー]+$", msg=@Msg(key="姓（カナ）はカタカナで入力してください",resource = false))
	public String seiKana;
	
	@Required(arg0 = @Arg(key = "名（カナ）", resource = false))
	@Maxlength(maxlength = 20, msg=@Msg(key="名（カナ）は２０文字以内で入力してください",resource = false))
	@Mask(mask = "^[ァ-ヶ|ー]+$", msg=@Msg(key="名（カナ）はカタカナで入力してください",resource = false))
	public String meiKana;
	
	@Required(arg0 = @Arg(key = "生年月日", resource = false))
	@DateType(datePatternStrict="yyyyMMdd", msg=@Msg(key="生年月日はYYYYMMDD形式で入力してください",resource = false))
	public String birthDate;
	
	@Required(arg0 = @Arg(key = "性別", resource = false))
	public Integer gender;
	
	@Required(arg0 = @Arg(key = "郵便番号（前半３桁）", resource = false))
	@Mask(mask = "^[0-9]{3,3}+$", msg=@Msg(key="郵便番号（前半３桁）は３桁の数字で入力してください",resource = false))
	public String zip1;
	
	@Required(arg0 = @Arg(key = "郵便番号（後半４桁）", resource = false))
	@Mask(mask = "^[0-9]{4,4}+$", msg=@Msg(key="郵便番号（後半４桁）は４桁の数字で入力してください",resource = false))
	public String zip2;
	
	@Required(arg0 = @Arg(key = "都道府県", resource = false))
	@Maxlength(maxlength = 30, msg=@Msg(key="都道府県は３０文字以内で入力してください",resource = false))
	@Mask(mask = "^[^-~｡-ﾟ①②③④⑤⑥⑦⑧⑨⑩⑪⑫⑬⑭⑮⑯⑰⑱⑲⑳ⅠⅡⅢⅣⅤ≡∑∫∮√⊥∠∟⊿∵∩∪№㏍℡㊤㊥㊦㊧㊨㈱㈲㈹㍾㍽㍼㍻㍉㎜㎝㎞㎎㎏㏄㍉㌔㌢㍍㌘㌧㌃㌶㍑㍗㌍㌦㌣㌫㍊㌻ⅠⅡⅢⅣⅤⅥⅦⅧⅨⅩ]+$", msg=@Msg(key="都道府県に使用できない文字です（半角・機種依存文字）",resource = false))
	public String address1;
	
	@Required(arg0 = @Arg(key = "市区郡", resource = false))
	@Maxlength(maxlength = 30, msg=@Msg(key="市区郡は３０文字以内で入力してください",resource = false))
	@Mask(mask = "^[^-~｡-ﾟ①②③④⑤⑥⑦⑧⑨⑩⑪⑫⑬⑭⑮⑯⑰⑱⑲⑳ⅠⅡⅢⅣⅤ≡∑∫∮√⊥∠∟⊿∵∩∪№㏍℡㊤㊥㊦㊧㊨㈱㈲㈹㍾㍽㍼㍻㍉㎜㎝㎞㎎㎏㏄㍉㌔㌢㍍㌘㌧㌃㌶㍑㍗㌍㌦㌣㌫㍊㌻ⅠⅡⅢⅣⅤⅥⅦⅧⅨⅩ]+$", msg=@Msg(key="市区郡に使用できない文字です（半角・機種依存文字）",resource = false))
	public String address2;
	
	@Required(arg0 = @Arg(key = "町名・番地", resource = false))
	@Maxlength(maxlength = 40, msg=@Msg(key="町名・番地は４０文字以内で入力してください",resource = false))
	@Mask(mask = "^[^-~｡-ﾟ①②③④⑤⑥⑦⑧⑨⑩⑪⑫⑬⑭⑮⑯⑰⑱⑲⑳ⅠⅡⅢⅣⅤ≡∑∫∮√⊥∠∟⊿∵∩∪№㏍℡㊤㊥㊦㊧㊨㈱㈲㈹㍾㍽㍼㍻㍉㎜㎝㎞㎎㎏㏄㍉㌔㌢㍍㌘㌧㌃㌶㍑㍗㌍㌦㌣㌫㍊㌻ⅠⅡⅢⅣⅤⅥⅦⅧⅨⅩ]+$", msg=@Msg(key="町名・番地に使用できない文字です（半角・機種依存文字）",resource = false))
	public String address3;
	
	@Maxlength(maxlength = 40, msg=@Msg(key="アパート・マンション名は４０文字以内で入力してください",resource = false))
	@Mask(mask = "^[^-~｡-ﾟ①②③④⑤⑥⑦⑧⑨⑩⑪⑫⑬⑭⑮⑯⑰⑱⑲⑳ⅠⅡⅢⅣⅤ≡∑∫∮√⊥∠∟⊿∵∩∪№㏍℡㊤㊥㊦㊧㊨㈱㈲㈹㍾㍽㍼㍻㍉㎜㎝㎞㎎㎏㏄㍉㌔㌢㍍㌘㌧㌃㌶㍑㍗㌍㌦㌣㌫㍊㌻ⅠⅡⅢⅣⅤⅥⅦⅧⅨⅩ]+$", msg=@Msg(key="アパート・マンション名に使用できない文字です（半角・機種依存文字）",resource = false))
	public String address4;

	@Required(arg0 = @Arg(key = "電話番号（先頭）", resource = false))
	@Mask(mask = "^[0-9]{1,10}+$", msg=@Msg(key="電話番号（先頭）は１０桁以内の数字で入力してください",resource = false))
	public String tel1;
	@Required(arg0 = @Arg(key = "電話番号（中央）", resource = false))
	@Mask(mask = "^[0-9]{1,10}+$", msg=@Msg(key="電話番号（中央）は１０桁以内の数字で入力してください",resource = false))
	public String tel2;
	@Required(arg0 = @Arg(key = "電話番号（末尾）", resource = false))
	@Mask(mask = "^[0-9]{1,10}+$", msg=@Msg(key="電話番号（末尾）は１０桁以内の数字で入力してください",resource = false))
	public String tel3;
	@Required(arg0 = @Arg(key = "緊急連絡先（先頭）", resource = false))
	@Mask(mask = "^[0-9]{1,10}+$", msg=@Msg(key="緊急連絡先（先頭）は１０桁以内の数字で入力してください",resource = false))
	public String eTel1;
	@Required(arg0 = @Arg(key = "緊急連絡先（中央）", resource = false))
	@Mask(mask = "^[0-9]{1,10}+$", msg=@Msg(key="緊急連絡先（中央）は１０桁以内の数字で入力してください",resource = false))
	public String eTel2;
	@Required(arg0 = @Arg(key = "緊急連絡先（末尾）", resource = false))
	@Mask(mask = "^[0-9]{1,10}+$", msg=@Msg(key="緊急連絡先（末尾）は１０桁以内の数字で入力してください",resource = false))
	public String eTel3;
	
	@Required(arg0 = @Arg(key = "メールアドレス", resource = false))
	@EmailType(arg0 = @Arg(key = "メールアドレス", resource = false), msg=@Msg(key="メールアドレスの形式が間違っています",resource = false))
	@Maxlength(maxlength = 50, msg=@Msg(key="メールアドレスは５０文字以内で入力してください",resource = false))
	public String email1;
	
	@Validwhen(test="(email1 == email2)", msg=@Msg(key="メールアドレスとメールアドレス（確認）が異なります",resource = false))
	public String email2;
	
	@Required(arg0 = @Arg(key = "職業", resource = false))
	public Integer occupation;
	
	@SuppressWarnings("serial")
	public HashMap<Integer, String> constGender = new HashMap<Integer, String>(){
		{
			put(1, "男");
			put(2, "女");
		}
	};
	
	@SuppressWarnings("serial")
	public HashMap<Integer, String> constOccupation = new HashMap<Integer, String>(){
		{
			put(1, "会社員");
			put(2, "公務員");
			put(3, "会社役員");
			put(4, "自営業");
			put(5, "農林水産業");
			put(6, "自由業");
			put(7, "パートタイマー");
			put(8, "主婦");
			put(9, "その他");
			put(10, "無職");
		}
	};
	
	public String ipAddress;
	public String sessionId;
}