/*
 * Copyright 2004-2008 the Seasar Foundation and the Others.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND,
 * either express or implied. See the License for the specific language
 * governing permissions and limitations under the License.
 */
package jp.yoyoyoyo.webformmanager.action;

import java.security.MessageDigest;
import java.util.Calendar;
import java.util.Date;
import java.util.List;
import java.util.StringTokenizer;

import javax.annotation.Resource;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpSession;

import jp.yoyoyoyo.webformmanager.dto.ExecuteLoginDto;
import jp.yoyoyoyo.webformmanager.dto.LoginDataDto;
import jp.yoyoyoyo.webformmanager.entity.UserData;
import jp.yoyoyoyo.webformmanager.form.LoginForm;
import jp.yoyoyoyo.webformmanager.lib.CommonUtil;

import org.apache.struts.action.ActionMessage;
import org.apache.struts.action.ActionMessages;
import org.seasar.extension.jdbc.JdbcManager;
import org.seasar.struts.annotation.ActionForm;
import org.seasar.struts.annotation.Execute;
import org.seasar.struts.util.ActionMessagesUtil;

public class AccountAction {
	@Resource
	protected HttpServletRequest request;
	@Resource
	protected JdbcManager jdbcManager;
	@Resource
	protected HttpSession session;
	
	@Resource
	@ActionForm
	public LoginForm loginForm;
	
	public List<UserData> userData;
	
	// ログインページの表示
    @Execute(validator = false)
	public String login() {
    	
        return "login.jsp";
	}
    
    // ログインボタンを押したときの処理
    @Execute(validator = true, input="login.jsp")
    public String doLogin() {
    	// ユーザデータの取得
    	this.userData = this.jdbcManager.from(UserData.class)
    			.where("id = ?", loginForm.operatorId)
    			.getResultList();
		
    	// 入力パスワードをSHA-256で暗号化
		String encryptedPassword = "";
		byte[] binary = loginForm.password.getBytes();
		MessageDigest md;
		try{
			md = MessageDigest.getInstance("SHA-256");
			byte[] digest = md.digest(binary);
			
			encryptedPassword = CommonUtil.bytesToHexString(digest);
		}catch(Exception e){
			return "/maintenance/maintenance/";
		}
		
		// パスワードの有効期限のため120日前の日付を設定する
		Date d = new Date();
		Calendar cal = Calendar.getInstance();
		cal.setTime(d);
		cal.add(Calendar.DATE , -120);
		
		d = cal.getTime();
	
		if(this.userData.size() == 0){	// ログインデータが見つからないとき
			ActionMessages lMessages = new ActionMessages();
			lMessages.add(ActionMessages.GLOBAL_MESSAGE,new ActionMessage("オペレータIDまたはパスワードがエラーです", false));
			ActionMessagesUtil.saveErrors(request,lMessages);
		} else if(this.userData.get(0).lockFlag == true){	// ユーザがロックされているとき
			ActionMessages lMessages = new ActionMessages();
			lMessages.add(ActionMessages.GLOBAL_MESSAGE,new ActionMessage("オペレータID（" + loginForm.operatorId + "）はロックされています", false));
			ActionMessagesUtil.saveErrors(request,lMessages);
		}  else if(this.userData.get(0).disabled == true){	// ユーザが無効化されているとき
			ActionMessages lMessages = new ActionMessages();
			lMessages.add(ActionMessages.GLOBAL_MESSAGE,new ActionMessage("オペレータID（" + loginForm.operatorId + "）は無効化されています", false));
			ActionMessagesUtil.saveErrors(request,lMessages);
		} else if(!this.userData.get(0).password.equals(encryptedPassword)){ // 入力パスワードが間違えているとき
			ActionMessages lMessages = new ActionMessages();
			lMessages.add(ActionMessages.GLOBAL_MESSAGE,new ActionMessage("オペレータIDまたはパスワードがエラーです", false));
			ActionMessagesUtil.saveErrors(request,lMessages);

			// 失敗カウントをインクリメントし規定回数以上だったらロックカウントを設定
			int failedCount = this.userData.get(0).failedCount;
			failedCount++;
			boolean lockFlag = false;
			if(failedCount > 6){
				lockFlag = true;			
			}
			
			// ストアドに渡すDTOを設定
			ExecuteLoginDto dto = new ExecuteLoginDto();
			dto.id = loginForm.operatorId;
			dto.succesuful = false;
			dto.failedCount = failedCount;
			dto.lockFlag = lockFlag;
			dto.ipAddress =  request.getRemoteAddr();
           	dto.sessionId = session.getId();
			// ストアドを実行する
           	try{
           		jdbcManager.call("execute_login", dto).execute();
           	} catch(Exception e){
           		// エラーが発生したらメインテナンス画面へ
           		return "/maintenance/maintenance/";
           	}
		} else if(this.userData.get(0).initialPassword == true){	// 初期化されたパスワードのとき
			ActionMessages lMessages = new ActionMessages();
			lMessages.add(ActionMessages.GLOBAL_MESSAGE,new ActionMessage("初期化されたパスワードです。パスワードを更新してください", false));
			ActionMessagesUtil.saveErrors(request,lMessages);
		} else if(this.userData.get(0).lastPasswordChange.before(d)){	// パスワードの有効期限が過ぎているとき
			ActionMessages lMessages = new ActionMessages();
			lMessages.add(ActionMessages.GLOBAL_MESSAGE,new ActionMessage("パスワードの有効期限が過ぎています。パスワードを更新してください", false));
			ActionMessagesUtil.saveErrors(request,lMessages);
		} else { 	// ログインOK
			// ログイン情報を記録するためのDTOを設定
			ExecuteLoginDto dto = new ExecuteLoginDto();
			dto.id = loginForm.operatorId;
			dto.succesuful = true;
			dto.failedCount = 0;
			dto.lockFlag = false;
			dto.ipAddress =  request.getRemoteAddr();
           	dto.sessionId = session.getId();
           	
           	// ログイン情報を記録
           	try{
              	jdbcManager.call("execute_login", dto).execute();   		
           	} catch (Exception e){
           		// エラーが発生したときはメインテナンス画面へ
           		return "/maintenance/maintenance/";
           	}
 
           	// ログインオブジェクトの生成とパラメータの設定
           	LoginDataDto login = new LoginDataDto();
           	
           	login.operatorId = this.userData.get(0).id;
           	login.operatorName = this.userData.get(0).operatorName;
         	StringTokenizer st1 = new StringTokenizer(this.userData.get(0).role, ",");
        	
         	login.roleRead = false;
         	login.roleWrite = false;
         	login.roleCSVDownload = false;
         	login.roleUserManager = false;
        	
        	while(st1.hasMoreTokens()) {
        		String tmp = st1.nextToken();
        		if(tmp.equals("1")){
        			login.roleRead = true;
        		}
        		if(tmp.equals("2")){
        			login.roleWrite = true;
        		}
        		if(tmp.equals("3")){
        			login.roleCSVDownload = true;
        		}
        		if(tmp.equals("4")){
        			login.roleUserManager = true;
        		}
        	}
        	
        	// セッションにログイン情報を格納
        	session.setAttribute("loginData", login);
        	
        	// ロールの状態により書く画面へ遷移
        	if(login.roleRead == true || login.roleWrite == true){	// Read/Write権限
    			return "/status/status/";	// ステータス画面へ
        	} else if (login.roleCSVDownload == true){	// CSVDownload権限
        		return "/csvDownload/download/";	// CSVダウンロード画面へ
        	} else if (login.roleUserManager == true){	// UserManager権限
        		return "/user/userManager/";		// ユーザマネージャ画面へ
        	} else {	// それ以外
        		// メインテナンス画面へ遷移
        		return "/maintenance/maintenance/";
        	}
		}
		
		return "login.jsp";
 	}
}
