package jp.yoyoyoyo.webformmanager.action;

import java.security.MessageDigest;
import java.util.List;

import javax.annotation.Resource;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpSession;

import jp.yoyoyoyo.webformmanager.dto.ChangePasswordDto;
import jp.yoyoyoyo.webformmanager.entity.UserData;
import jp.yoyoyoyo.webformmanager.form.PasswordChangeForm;
import jp.yoyoyoyo.webformmanager.lib.CommonUtil;


import org.apache.struts.action.ActionMessage;
import org.apache.struts.action.ActionMessages;
import org.seasar.extension.jdbc.JdbcManager;
import org.seasar.struts.annotation.ActionForm;
import org.seasar.struts.annotation.Execute;
import org.seasar.struts.util.ActionMessagesUtil;

public class ChangePasswordAction {
	@Resource
	protected HttpServletRequest request;
	@Resource
	protected JdbcManager jdbcManager;
	@Resource
	protected HttpSession session;

	@Resource
	@ActionForm
	protected PasswordChangeForm passwordChangeForm;
	
	public ChangePasswordDto changePasswordDto;
	
	public String maskedPassword;
	
	public List<UserData> userData;
	
	// パスワード更新画面を表示
	@Execute(validator = false)
	public String changePassword() {		
		return "changePassword.jsp";
	}
	
	// パスワード更新画面で戻るボタンを押したとき
	@Execute(validator = false)
	public String back() {
		// ログイン画面へ戻る
		return "/account/login/";
	}
	
	// パスワード更新画面で次へボタンを押したとき
	@Execute(validate="validate", input="changePassword.jsp")
	public String next() {
		// ユーザデータの取得
	   	this.userData = this.jdbcManager.from(UserData.class)
    			.where("id = ?", passwordChangeForm.operatorId)
    			.getResultList();
	   	
	   	// 入力した現在のパスワードをSHA-256で暗号化
	   	String encryptedPassword = "";
		byte[] binary = passwordChangeForm.oldPassword.getBytes();
		MessageDigest md;
		try{
			md = MessageDigest.getInstance("SHA-256");
			byte[] digest = md.digest(binary);
			
			encryptedPassword = CommonUtil.bytesToHexString(digest);
		}catch(Exception e){
			// エラーが発生したときはメインテナンス画面へ
			return "/maintenance/maintenance/";
		}
	   	
	   	if(this.userData.size() == 0){	// ユーザが見つからなかったとき
			ActionMessages lMessages = new ActionMessages();
			lMessages.add(ActionMessages.GLOBAL_MESSAGE,new ActionMessage("オペレータIDが見つかりません", false));
			ActionMessagesUtil.saveErrors(request,lMessages);
			return "changePassword.jsp";
			
	   	} else if(!this.userData.get(0).password.equals(encryptedPassword)){	// 現在のパスワードが異なるとき
	   		ActionMessages lMessages = new ActionMessages();
			lMessages.add(ActionMessages.GLOBAL_MESSAGE,new ActionMessage("現在のパスワードが間違っています", false));
			ActionMessagesUtil.saveErrors(request,lMessages);
			return "changePassword.jsp";
	   	}
		
	   	// 入力情報をDTOに記録
		changePasswordDto.id = passwordChangeForm.operatorId;
		changePasswordDto.initialPasword = false;
		changePasswordDto.password = passwordChangeForm.newPassword;
		   	
		// セッションにユーザ更新のDTOを記録
    	session.setAttribute("changePasswordDto", changePasswordDto);
    	
    	// 確認画面ではパスワードはマスクする
    	this.maskedPassword = CommonUtil.getMaskPassword(passwordChangeForm.newPassword);
    	
    	return "changePasswordConfirm.jsp";
	}
	
	// パスワード更新の確認画面で戻るボタンを押したとき
	@Execute(validator = false)
	public String prev() {
		// セッションからDTOを取得
		changePasswordDto = (ChangePasswordDto)session.getAttribute("changePasswordDto");
    	
		// オペレータIDを復元
		passwordChangeForm.operatorId = changePasswordDto.id;
		
		return "changePassword.jsp";
	}
	
	// パスワード更新の確認画面で保存ボタンを押したとき
	@Execute(validator = false)
	public String save() {
		// セッションからパスワード更新のDTOを取得
		changePasswordDto = (ChangePasswordDto)session.getAttribute("changePasswordDto");
		
		// セッションが見つからないときはメインテナンス画面へ
		if(changePasswordDto == null){
			return "/maintenance/maintenance";
		}
		
		// 入力したパスワードをSHA-256で暗号化
		byte[] binary = changePasswordDto.password.getBytes();
		MessageDigest md;
		try{
			md = MessageDigest.getInstance("SHA-256");
			byte[] digest = md.digest(binary);
			
			changePasswordDto.password = CommonUtil.bytesToHexString(digest);
		}catch(Exception e){
			// エラーが発生したときはメインテナンス画面へ
			return "/maintenance/maintenance";
		}
		
		//　パスワードの更新
		try {
			jdbcManager.call("update_password", changePasswordDto).execute();
		} catch(Exception e){
			// エラーが発生したときはメインテナンス画面へ
			return "/maintenance/maintenance";
		}
    	
		// セッションのクリア
    	session.removeAttribute("changePasswordDto");
    	
    	// メッセージ画面を表示
    	return "message.jsp";
	}
}