/*
 * Copyright 2004-2008 the Seasar Foundation and the Others.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND,
 * either express or implied. See the License for the specific language
 * governing permissions and limitations under the License.
 */
package jp.yoyoyoyo.webformmanager.action;

import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.util.List;

import javax.annotation.Resource;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;

import jp.yoyoyoyo.webformmanager.dto.DownloadLogDto;
import jp.yoyoyoyo.webformmanager.dto.LoginDataDto;
import jp.yoyoyoyo.webformmanager.entity.RequestData;
import jp.yoyoyoyo.webformmanager.form.CsvDownloadForm;

import org.seasar.extension.jdbc.JdbcManager;
import org.seasar.struts.annotation.ActionForm;
import org.seasar.struts.annotation.Execute;

public class CsvDownloadAction {
	@Resource
	protected HttpServletRequest request;
	@Resource
	protected HttpServletResponse response;
	
	@Resource
	protected JdbcManager jdbcManager;
	@Resource
	protected HttpSession session;
	
	// statusChange
	@Resource
	@ActionForm
	protected CsvDownloadForm csvDownloadForm;
	
	public boolean roleRead;
	public boolean roleWrite;
	public boolean roleCSVDownload;
	public boolean roleUserManager;
	
	// CSVダウンロード画面の表示
    @Execute(validator = false)
	public String download() {
    	// ログイン情報をセッションから取得
    	LoginDataDto login = (LoginDataDto)session.getAttribute("loginData");
    	
    	// ログイン情報がないときはエラー
    	if(login == null){
    		return "/maintenance/maintenance/";
    	}
    	
    	// ロールがCSVダウンロードでないときはエラー
    	if(!login.roleCSVDownload){
    		return "/maintenance/maintenance/";
    	}
    	
    	// 画面表示のための設定
    	this.roleRead = login.roleRead;
    	this.roleWrite = login.roleWrite;
    	this.roleCSVDownload = login.roleCSVDownload;
    	this.roleUserManager = login.roleUserManager;
    	
    	return "download.jsp";
	}

    // CSVダウンロード画面でダウンロードボタンを押した時の処理
    @Execute(validator = false)
	public String downloadCsv() {
    	// セッションからログイン情報の取得
    	LoginDataDto login = (LoginDataDto)session.getAttribute("loginData");
    	
    	// ログイン情報がないときはエラー画面へ
      	if(login == null){
    		return "/maintenance/maintenance/";
    	}
    	
      	// CSVファイル名の設定
    	String fromDate = csvDownloadForm.fromDate;
    	String toDate = csvDownloadForm.toDate;
    	String csvFileName = "csv_" + fromDate.replaceAll("/", "") + "_" + toDate.replaceAll("/", "") + ".csv";
    	
    	// CSVダウンロード処理
    	response.setContentType("application/octet-stream"); 
    	response.setHeader("Content-Disposition", "attachment;filename=" + csvFileName); 
    	PrintWriter out; 
    	try {
        	out = new PrintWriter(new OutputStreamWriter(response.getOutputStream(), "UTF-8"));
           	
        	List<RequestData> dataList = this.jdbcManager.from(RequestData.class)
        			.where("request_date > ? and request_date < ?", fromDate, toDate)
        			.orderBy("request_date asc")
        			.getResultList();
        	int count = 0;
        	for(RequestData data : dataList){
        		out.print(data.id + ",");
           		out.print(data.seiKanji + ",");
           		out.print(data.meiKanji + ",");
           		out.print(data.seiKana + ",");
           		out.print(data.meiKana + ",");
           		out.print(data.birthDate + ",");
           		out.print(data.genderText + ",");
           		out.print(data.zip1 + ",");
           		out.print(data.zip2 + ",");
           		out.print(data.address1 + ",");
           		out.print(data.address2 + ",");
           		out.print(data.address3 + ",");
           		out.print(data.address4 + ",");
           		out.print(data.tel1 + ",");
           		out.print(data.tel2 + ",");
           		out.print(data.tel3 + ",");
           		out.print(data.eTel1 + ",");
           		out.print(data.eTel2 + ",");
           		out.print(data.eTel3 + ",");
           		out.print(data.email + ",");
           		out.print(data.occupationText + ",");
           		out.print(data.ipAddress + ",");
           		out.print(data.sessionId);
           		out.println();
           		count++;
         	}
        	
           	out.flush();
           	
           	//　ダウンロード履歴を記録
           	DownloadLogDto dto = new DownloadLogDto();
           	dto.operatorId = login.operatorId;
           	dto.downloadFilename = csvFileName;
           	dto.downloadCount = count;
           	dto.ipAddress =  request.getRemoteAddr();
           	dto.sessionId = session.getId();
          
           	try{
              	jdbcManager.call("insert_download_log", dto).execute();	
           	} catch (Exception e){
           		return "/maintenance/maintenance/";
           	}
 
    	
    	} catch (Exception e){
    		return "/maintenance/maintenance/";
    	}
   	
    	return null;
    }

}
