package jp.yoyoyoyo.webformmanager.action;

import java.util.List;

import javax.annotation.Resource;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpSession;

import jp.yoyoyoyo.webformmanager.dto.LoginDataDto;
import jp.yoyoyoyo.webformmanager.dto.StatusChangeDto;
import jp.yoyoyoyo.webformmanager.entity.RequestData;
import jp.yoyoyoyo.webformmanager.entity.StatusData;
import jp.yoyoyoyo.webformmanager.form.StatusChangeForm;

import org.seasar.extension.jdbc.JdbcManager;
import org.seasar.struts.annotation.ActionForm;
import org.seasar.struts.annotation.Execute;

public class DetailAction {
	@Resource
	protected HttpServletRequest request;
	@Resource
	protected JdbcManager jdbcManager;
	@Resource
	protected HttpSession session;

	// detail
	public RequestData detailList;
	
	public List<StatusData> statusList;
	
	
	// statusChange
	@Resource
	@ActionForm
	protected StatusChangeForm statusChangeForm;
	
	// statusChangeConfirm
	public StatusChangeDto statusChangeDto;

	public boolean roleRead;
	public boolean roleWrite;
	public boolean roleCSVDownload;
	public boolean roleUserManager;
	
	// 詳細画面の表示
    @Execute(validator = false)
	public String detail() {
    	// セッションからログイン情報を取得
    	LoginDataDto login = (LoginDataDto)session.getAttribute("loginData");
    	
    	// ログイン情報がないときはエラー
    	if(login == null){
    		return "/maintenance/maintenance/";
    	}
    	
    	// ReadおよびWrite権限がないときはエラー
    	if(!(login.roleRead || login.roleWrite)){
    		return "/maintenance/maintenance/";
    	}
    	
    	this.roleRead = login.roleRead;
    	this.roleWrite = login.roleWrite;
    	this.roleCSVDownload = login.roleCSVDownload;
    	this.roleUserManager = login.roleUserManager;
    	
    	// GetパラメータからIDを取得
    	String id = request.getParameter("id");
      	
    	// セッションに保存する
      	session.setAttribute("statusId", id);
      	
      	// 詳細の表示
      	int status = showDetail(id);
      	
    	// セッションに保存する
      	session.setAttribute("oldStatus", status);
    	
    	return "detail.jsp";
    }
	
    // 詳細画面で戻るボタンを押したとき
    @Execute(validator = false)
 	public String detailBack() {
    	return "/status/status/";
    }
    
    // 詳細画面でステータス更新ボタンを押したとき
    @Execute(validator = false)
 	public String statusChange() {
    	// セッションからログイン情報を取得
    	LoginDataDto login = (LoginDataDto)session.getAttribute("loginData");
    	
    	// ログインしたいないときはエラー
    	if(login == null){
    		return "/maintenance/maintenance/";
    	}
    	
    	// Write権限がないときはエラー
    	if(!login.roleWrite){
    		return "/maintenance/maintenance/";
    	}
    	
    	this.roleRead = login.roleRead;
    	this.roleWrite = login.roleWrite;
    	this.roleCSVDownload = login.roleCSVDownload;
    	this.roleUserManager = login.roleUserManager;
    	
    	// IDの取得
    	int id = Integer.parseInt((String)session.getAttribute("statusId"));
    	// 現在のステータスの取得
    	int status = Integer.parseInt(String.valueOf(session.getAttribute("oldStatus")));
    	
    	// ActionFormに設定する
    	statusChangeForm.id = id;
    	statusChangeForm.status = status;
    	statusChangeForm.comment = "";
    	
    	return "statusChange.jsp"; 
    }
 
    // ステータス更新画面で戻るボタンを押したとき
    @Execute(validator = false)
  	public String statusChangeBack() {
    	// セッションからログイン情報を取得する
    	LoginDataDto login = (LoginDataDto)session.getAttribute("loginData");
    	
    	// ログインしていないときはエラー
    	if(login == null){
    		return "/maintenance/maintenance/";
    	}
    	
    	// ReadおよびWrite権限がないときはエラー
    	if(!(login.roleRead || login.roleWrite)){
    		return "/maintenance/maintenance/";
    	}
    	
    	this.roleRead = login.roleRead;
    	this.roleWrite = login.roleWrite;
    	this.roleCSVDownload = login.roleCSVDownload;
    	this.roleUserManager = login.roleUserManager;
    	
    	// セッションからidの取得
    	String id = (String)session.getAttribute("statusId");
  	   	
    	// 詳細の表示
      	showDetail(id);
    	
    	return "detail.jsp";
    }
    
    // バリデーションエラー発生後の処理
    @Execute(validator = false)
    public String statusChange2(){
    	// セッションからログイン情報の取得
    	LoginDataDto login = (LoginDataDto)session.getAttribute("loginData");
    	
    	// ログインしていないときはエラー
    	if(login == null){
    		return "/maintenance/maintenance/";
    	}
    	
    	// Write権限でないときはエラー
    	if(!(login.roleWrite)){
    		return "/maintenance/maintenance/";
    	}
    	
    	this.roleRead = login.roleRead;
    	this.roleWrite = login.roleWrite;
    	this.roleCSVDownload = login.roleCSVDownload;
    	this.roleUserManager = login.roleUserManager; 	
    
    	// ActionFormに値の設定
    	statusChangeForm.id = Integer.parseInt((String)session.getAttribute("statusId"));
    	
    	return "statusChange.jsp";
    }
    
    // ステータス更新画面で次へボタンを押したとき
    @Execute(validator = true, input="statusChange2")
  	public String statusChangeNext() {
    	// セッションからログイン情報の取得
    	LoginDataDto login = (LoginDataDto)session.getAttribute("loginData");
    	
    	// ログインしていないときはエラー
    	if(login == null){
    		return "/maintenance/maintenance/";
    	}
    	
    	// Write権限がないときはエラー
    	if(!(login.roleWrite)){
    		return "/maintenance/maintenance/";
    	}
    	
    	this.roleRead = login.roleRead;
    	this.roleWrite = login.roleWrite;
    	this.roleCSVDownload = login.roleCSVDownload;
    	this.roleUserManager = login.roleUserManager;
    	
    	// ActionFormからDTOへ値のコピー
    	statusChangeDto.id = Integer.parseInt(String.valueOf(session.getAttribute("statusId")));
    	int oldStatus = Integer.parseInt(String.valueOf(session.getAttribute("oldStatus")));
    	statusChangeDto.oldStatus = oldStatus;
    	statusChangeDto.oldStatusText = statusChangeForm.constStatus.get(oldStatus);
    	statusChangeDto.newStatus = statusChangeForm.status;
    	statusChangeDto.newStatusText = statusChangeForm.constStatus.get(statusChangeForm.status);
    	statusChangeDto.comment = statusChangeForm.comment;
    	statusChangeDto.operatorId = login.operatorId;
    	
    	// セッションにDTOを保存
    	session.setAttribute("statusChangeDto", statusChangeDto);
    	
    	return "statusChangeConfirm.jsp";
    }
    
    // ステータス更新確認画面で戻るボタンを押したとき
    @Execute(validator = false)
    public String statusChangeConfirmBack() {
    	// セッションからログイン情報を取り出す
    	LoginDataDto login = (LoginDataDto)session.getAttribute("loginData");
    	
    	// ログインしていないときはエラー画面へ
    	if(login == null){
    		return "/maintenance/maintenance/";
    	}
    	
    	// Write権限がないときはエラー画面へ
    	if(!login.roleWrite){
    		return "/maintenance/maintenance/";
    	}
    	
    	this.roleRead = login.roleRead;
    	this.roleWrite = login.roleWrite;
    	this.roleCSVDownload = login.roleCSVDownload;
    	this.roleUserManager = login.roleUserManager;
    	
    	// セッション情報からActionFormに値を設定
    	statusChangeDto = (StatusChangeDto)session.getAttribute("statusChangeDto");
    	
    	statusChangeForm.id = statusChangeDto.id;
    	statusChangeForm.status = statusChangeDto.newStatus;
    	statusChangeForm.comment = statusChangeDto.comment;
    	
    	return "statusChange.jsp";
	}
    
    // ステータス更新確認画面で保存ボタンを押したとき
    @Execute(validator = false)
    public String statusChangeConfirmSave(){
    	// セッションからログイン情報を取り出す
    	LoginDataDto login = (LoginDataDto)session.getAttribute("loginData");
    	
    	// ログインしていないときはエラー
    	if(login == null){
    		return "/maintenance/maintenance/";
    	}
    	
    	// Write権限がないときはエラー
    	if(!login.roleWrite){
    		return "/maintenance/maintenance/";
    	}
    	
    	this.roleRead = login.roleRead;
    	this.roleWrite = login.roleWrite;
    	this.roleCSVDownload = login.roleCSVDownload;
    	this.roleUserManager = login.roleUserManager;
    	
    	// セッションからDTOの取得
    	statusChangeDto = (StatusChangeDto)session.getAttribute("statusChangeDto");
    	
    	// ステータス更新のストアドを実行
    	try{
    		jdbcManager.call("insert_status_history", statusChangeDto).execute();	
    	} catch(Exception e){
    		// エラーが発生したときはメインテナンス画面へ
    		return "/maintenance/maintenance/";
    	}
    	
    	// セッションからDTOのクリア
    	session.removeAttribute("statusChangeDto");
    	
    	return "/message/message/";
    }
    
    // 詳細表示用関数
    private int showDetail(String id){
       	// 申込データの取得
    	this.detailList = this.jdbcManager.from(RequestData.class)
    			.where("id = ?", id)
    			.orderBy("request_date desc")
    			.getResultList().get(0);
    
    	// ステータスの取得
    	this.statusList = this.jdbcManager.from(StatusData.class)
    			.where("id = ?", id)
    			.orderBy("create_date desc")
    			.getResultList();
    	
    	return this.detailList.status;
    }
}
