package jp.yoyoyoyo.webformmanager.action;

import java.security.MessageDigest;

import javax.annotation.Resource;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpSession;

import jp.yoyoyoyo.webformmanager.dto.EditPasswordDto;
import jp.yoyoyoyo.webformmanager.dto.LoginDataDto;
import jp.yoyoyoyo.webformmanager.form.PasswordEditForm;
import jp.yoyoyoyo.webformmanager.lib.CommonUtil;


import org.seasar.extension.jdbc.JdbcManager;
import org.seasar.struts.annotation.ActionForm;
import org.seasar.struts.annotation.Execute;

public class EditPasswordAction {
	@Resource
	protected HttpServletRequest request;
	@Resource
	protected JdbcManager jdbcManager;
	@Resource
	protected HttpSession session;

	@Resource
	@ActionForm
	protected PasswordEditForm passwordEditForm;
	
	public EditPasswordDto editPasswordDto;
	
	public String maskedPassword;
	
	public boolean roleRead;
	public boolean roleWrite;
	public boolean roleCSVDownload;
	public boolean roleUserManager;
	
	// パスワード更新画面の表示
	@Execute(validator = false)
	public String editPassword() {
		// セッションからログイン情報の取得
		LoginDataDto login = (LoginDataDto)session.getAttribute("loginData");
    	
		// ログインしていないときはエラー
    	if(login == null){
    		return "/maintenance/maintenance/";
    	}
    	
    	// UserManager権限がないときはエラー
    	if(!login.roleUserManager){
    		return "/maintenance/maintenance/";
    	}
    	
    	this.roleRead = login.roleRead;
    	this.roleWrite = login.roleWrite;
    	this.roleCSVDownload = login.roleCSVDownload;
    	this.roleUserManager = login.roleUserManager;
    	
    	// Getパラメータからidの取得
    	String id = request.getParameter("id");
		   
		// セッションに保存する
      	session.setAttribute("operatorId", id);
      	
      	// ActionFormにidの設定
    	passwordEditForm.id = id;
    		
		return "editPassword.jsp";
	}
	
	// パスワード更新画面で戻るボタンを押したとき
	@Execute(validator = false)
	public String back() {
		return "/user/userManager/";
	}
	
	// バリデーションエラーが発生したときの処理
	@Execute(validator = false)
	public String editPassword2() {
		// セッションからログイン情報を取得
		LoginDataDto login = (LoginDataDto)session.getAttribute("loginData");
    	
		// ログインしていないときはエラー
    	if(login == null){
    		return "/maintenance/maintenance/";
    	}
    	
    	// UserManager権限がないときはエラー
    	if(!login.roleUserManager){
    		return "/maintenance/maintenance/";
    	}
    	
    	this.roleRead = login.roleRead;
    	this.roleWrite = login.roleWrite;
    	this.roleCSVDownload = login.roleCSVDownload;
    	this.roleUserManager = login.roleUserManager;
    	
    	// ActionFormに値を設定
    	passwordEditForm.id = String.valueOf(session.getAttribute("operatorId"));
		
		return "editPassword.jsp";
	}
	
	// パスワード更新画面で次へボタンを押したとき
	@Execute(validate = "validate", input="editPassword2")
	public String next() {
		// セッションからログイン情報を取得
		LoginDataDto login = (LoginDataDto)session.getAttribute("loginData");
    	
		// ログインしていないときはエラー
    	if(login == null){
    		return "/maintenance/maintenance/";
    	}
    	
    	// UserManager権限がないときはエラー
    	if(!login.roleUserManager){
    		return "/maintenance/maintenance/";
    	}
    	
    	this.roleRead = login.roleRead;
    	this.roleWrite = login.roleWrite;
    	this.roleCSVDownload = login.roleCSVDownload;
    	this.roleUserManager = login.roleUserManager;
    	
    	// ActionFormからDTOに値のコピー
    	editPasswordDto.id = String.valueOf(session.getAttribute("operatorId"));
		editPasswordDto.initialPasword = true;
		editPasswordDto.password = passwordEditForm.password1;
		   	
		// セッションに保存
    	session.setAttribute("editPasswordDto", editPasswordDto);
    	
    	// パスワード表示はマスクする
    	maskedPassword = CommonUtil.getMaskPassword(passwordEditForm.password1);
    	
    	return "editPasswordConfirm.jsp";
	}
	
	// パスワード更新確認画面で戻るボタンを押したとき
	@Execute(validator = false)
	public String back2() {
		// セッションからログイン情報を取得
		LoginDataDto login = (LoginDataDto)session.getAttribute("loginData");
    	
		// ログインしていないときはエラー
    	if(login == null){
    		return "/maintenance/maintenance/";
    	}
    	
    	// UserManager権限がないときはエラー
    	if(!login.roleUserManager){
    		return "/maintenance/maintenance/";
    	}
    	
    	this.roleRead = login.roleRead;
    	this.roleWrite = login.roleWrite;
    	this.roleCSVDownload = login.roleCSVDownload;
    	this.roleUserManager = login.roleUserManager;
    	
    	// ActionFormに値を設定
		editPasswordDto = (EditPasswordDto)session.getAttribute("editPasswordDto");
    	
		passwordEditForm.id = editPasswordDto.id;
		
		return "editPassword.jsp";
	}
	
	// パスワード更新確認画面で保存ボタンを押したとき
	@Execute(validator = false)
	public String save() {
		// セッションからログイン情報を取得
		LoginDataDto login = (LoginDataDto)session.getAttribute("loginData");
    	
		// ログインしていないときはエラー
    	if(login == null){
    		return "/maintenance/maintenance/";
    	}
    	
    	// UserManager権限がないときはエラー
    	if(!login.roleUserManager){
    		return "/maintenance/maintenance/";
    	}
    	
    	this.roleRead = login.roleRead;
    	this.roleWrite = login.roleWrite;
    	this.roleCSVDownload = login.roleCSVDownload;
    	this.roleUserManager = login.roleUserManager;
    	
    	// セッションからDTOの取得
    	editPasswordDto = (EditPasswordDto)session.getAttribute("editPasswordDto");
		
    	// パスワードをSHA-256で暗号化
		byte[] binary = editPasswordDto.password.getBytes();
		MessageDigest md;
		try{
			md = MessageDigest.getInstance("SHA-256");
			byte[] digest = md.digest(binary);
			
			editPasswordDto.password = CommonUtil.bytesToHexString(digest);
		}catch(Exception e){
			// エラーが発生したときはメインテナンス画面へ
			return "/maintenance/maintenance/";
		}
				
		// パスワードを更新
		try {
			jdbcManager.call("update_password", editPasswordDto).execute();
		} catch (Exception e){
			// エラーが発生したときはメインテナンス画面へ
			return "/maintenance/maintenance/";
		}
    	
    	// セッションからDTOの削除
    	session.removeAttribute("editPasswordDto");
    	
    	return "/message/message/";
	}
}