package jp.yoyoyoyo.webformmanager.action;

import java.util.StringTokenizer;

import javax.annotation.Resource;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpSession;

import jp.yoyoyoyo.webformmanager.dto.EditUserDto;
import jp.yoyoyoyo.webformmanager.dto.LoginDataDto;
import jp.yoyoyoyo.webformmanager.entity.UserData;
import jp.yoyoyoyo.webformmanager.form.UserEditForm;


import org.seasar.extension.jdbc.JdbcManager;
import org.seasar.struts.annotation.ActionForm;
import org.seasar.struts.annotation.Execute;

public class EditUserAction {
	@Resource
	protected HttpServletRequest request;
	@Resource
	protected JdbcManager jdbcManager;
	@Resource
	protected HttpSession session;

	@Resource
	@ActionForm
	protected UserEditForm userEditForm;
	
	public UserData userData;
	
	public EditUserDto editUserDto;
	
	public boolean roleRead;
	public boolean roleWrite;
	public boolean roleCSVDownload;
	public boolean roleUserManager;
	
	// ユーザ更新画面を表示したとき
	@Execute(validator = false)
	public String editUser() {
		// セッションからログイン情報を取得
		LoginDataDto login = (LoginDataDto)session.getAttribute("loginData");
    	
		// ログインしていないときはエラー
    	if(login == null){
    		return "/maintenance/maintenance/";
    	}
    	
    	// UserManager権限がないときはエラー
    	if(!login.roleUserManager){
    		return "/maintenance/maintenance/";
    	}
    	
    	this.roleRead = login.roleRead;
    	this.roleWrite = login.roleWrite;
    	this.roleCSVDownload = login.roleCSVDownload;
    	this.roleUserManager = login.roleUserManager;
    	
    	// GETパラメータからidを取得
		String id = request.getParameter("id");
		   
		// セッションに保存する
      	session.setAttribute("operatorId", id);
      	
       	// 申込データの取得
    	this.userData = this.jdbcManager.from(UserData.class)
    			.where("id = ?", id)
    			.getResultList().get(0);
    	
    	// ActionFormに値を設定
    	userEditForm.id = id;
    	userEditForm.operatorName = this.userData.operatorName;
    	StringTokenizer st1 = new StringTokenizer(this.userData.role, ",");
    	
    	userEditForm.roleRead = false;
    	userEditForm.roleWrite = false;
    	userEditForm.roleCSVDownload = false;
    	userEditForm.roleUserManager = false;
    	
    	while(st1.hasMoreTokens()) {
    		String tmp = st1.nextToken();
    		if(tmp.equals("1")){
    			userEditForm.roleRead = true;
    		}
    		if(tmp.equals("2")){
    			userEditForm.roleWrite = true;
    		}
    		if(tmp.equals("3")){
    			userEditForm.roleCSVDownload = true;
    		}
    		if(tmp.equals("4")){
    			userEditForm.roleUserManager = true;
    		}
    	}
    	
    	userEditForm.lock = this.userData.lockFlag;
    	userEditForm.disabled = this.userData.disabled;
    	
		return "editUser.jsp";
	}
	
	// ユーザ更新画面で戻るボタンを押したとき
	@Execute(validator = false)
	public String back() {
		return "/user/userManager/";
	}
	
	// バリデーションエラーが発生したとき
	@Execute(validator = false)
	public String editUser2() {
		// セッションからログイン情報を取得
		LoginDataDto login = (LoginDataDto)session.getAttribute("loginData");
    	
		// ログインしていないときはエラー
    	if(login == null){
    		return "/maintenance/maintenance/";
    	}
    	
    	// UserManager権限がないときはエラー
    	if(!login.roleUserManager){
    		return "/maintenance/maintenance/";
    	}
    	
    	this.roleRead = login.roleRead;
    	this.roleWrite = login.roleWrite;
    	this.roleCSVDownload = login.roleCSVDownload;
    	this.roleUserManager = login.roleUserManager;
    	
    	// ActionFormに値をセット
    	userEditForm.id = String.valueOf(session.getAttribute("operatorId"));
		
		return "editUser.jsp";
	}
	
	// ユーザ更新画面で次へボタンを押したとき
	@Execute(validate = "validate", input="editUser2")
	public String next() {
		// セッションからログイン情報を取得する
		LoginDataDto login = (LoginDataDto)session.getAttribute("loginData");
    	
		// ログインしていないときはエラー
    	if(login == null){
    		return "/maintenance/maintenance/";
    	}
    	
    	// UserManager権限がないときはエラー
    	if(!login.roleUserManager){
    		return "/maintenance/maintenance/";
    	}
    	
    	this.roleRead = login.roleRead;
    	this.roleWrite = login.roleWrite;
    	this.roleCSVDownload = login.roleCSVDownload;
    	this.roleUserManager = login.roleUserManager;
    	
    	// ActionFormからDTOへ値をセット
    	editUserDto.id = String.valueOf(session.getAttribute("operatorId"));
		editUserDto.operatorName = userEditForm.operatorName;
		String tmp = "";
		String tmp2 = "";
		if(userEditForm.roleRead){
			tmp = tmp + "1,";
			tmp2 = tmp2 + "Read,";
		}
		if(userEditForm.roleWrite){
			tmp = tmp + "2,";
			tmp2 = tmp2 + "Write,";
		}	
		if(userEditForm.roleCSVDownload){
			tmp = tmp + "3,";
			tmp2 = tmp2 + "CSV Download,";
		}
		if(userEditForm.roleUserManager){
			tmp = tmp + "4,";
			tmp2 = tmp2 + "User Manager,";
		}
		
		tmp = tmp.substring(0, tmp.length() - 1);
		tmp2 = tmp2.substring(0, tmp2.length() - 1);
		
		editUserDto.role = tmp;
		editUserDto.roleText = tmp2;
		
		editUserDto.lock = userEditForm.lock;
		editUserDto.disabled = userEditForm.disabled;
		   	
		// セッションに値をセット
    	session.setAttribute("editUserDto", editUserDto);
    	
    	return "editUserConfirm.jsp";
	}
	
	// ユーザ更新確認画面から戻るボタンを押したとき
	@Execute(validator = false)
	public String back2() {
		// セッションからログイン情報を取得する
		LoginDataDto login = (LoginDataDto)session.getAttribute("loginData");
    	
		// ログインしていないときはエラー
    	if(login == null){
    		return "/maintenance/maintenance/";
    	}
    	
    	// UserManager権限がないときはエラー
    	if(!login.roleUserManager){
    		return "/maintenance/maintenance/";
    	}
    	
    	this.roleRead = login.roleRead;
    	this.roleWrite = login.roleWrite;
    	this.roleCSVDownload = login.roleCSVDownload;
    	this.roleUserManager = login.roleUserManager;
    	
    	// セッションからDTOの取得
		editUserDto = (EditUserDto)session.getAttribute("editUserDto");
    	
		// ActionFormに値をセット
		userEditForm.id = editUserDto.id;
		userEditForm.operatorName = editUserDto.operatorName;
		
		StringTokenizer st1 = new StringTokenizer(editUserDto.role, ",");
	   	userEditForm.roleRead = false;
    	userEditForm.roleWrite = false;
    	userEditForm.roleCSVDownload = false;
    	userEditForm.roleUserManager = false;
    	
    	while(st1.hasMoreTokens()) {
    		String tmp = st1.nextToken();
    		if(tmp.equals("1")){
    			userEditForm.roleRead = true;
    		}
    		if(tmp.equals("2")){
    			userEditForm.roleWrite = true;
    		}
    		if(tmp.equals("3")){
    			userEditForm.roleCSVDownload = true;
    		}
    		if(tmp.equals("4")){
    			userEditForm.roleUserManager = true;
    		}
    	}
    	
    	userEditForm.lock = editUserDto.lock;
    	userEditForm.disabled = editUserDto.disabled;
    	
		
		return "editUser.jsp";
	}
	
	// ユーザ更新確認画面から保存ボタンを押したとき
	@Execute(validator = false)
	public String save() {
		// セッションからログイン情報を取得
		LoginDataDto login = (LoginDataDto)session.getAttribute("loginData");
    	
		// ログインしていないときはエラー
    	if(login == null){
    		return "/maintenance/maintenance/";
    	}
    	
    	// UserManager権限がないときはエラー
    	if(!login.roleUserManager){
    		return "/maintenance/maintenance/";
    	}
    	
    	this.roleRead = login.roleRead;
    	this.roleWrite = login.roleWrite;
    	this.roleCSVDownload = login.roleCSVDownload;
    	this.roleUserManager = login.roleUserManager;
    	
    	// セッションからDTOの取得
    	editUserDto = (EditUserDto)session.getAttribute("editUserDto");
    	
    	// ユーザ情報を更新する
    	try{
    	 	jdbcManager.call("update_mst_user", editUserDto).execute(); 		
    	} catch(Exception e){
    		// エラーが発生したときはメインテナンス画面へ
    		return "/maintenance/maintenance/";
    	}
    	
    	// セッションからDTOの削除
    	session.removeAttribute("editUserDto");
    	
    	return "/message/message/";
	}
}