/*
 * Copyright 2004-2008 the Seasar Foundation and the Others.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND,
 * either express or implied. See the License for the specific language
 * governing permissions and limitations under the License.
 */
package jp.yoyoyoyo.webformmanager.action;

import java.util.List;

import javax.annotation.Resource;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpSession;

import jp.yoyoyoyo.webformmanager.dto.LoginDataDto;
import jp.yoyoyoyo.webformmanager.entity.LogDownloadData;
import jp.yoyoyoyo.webformmanager.form.LogDownloadForm;

import org.seasar.extension.jdbc.JdbcManager;
import org.seasar.framework.util.IntegerConversionUtil;
import org.seasar.struts.annotation.ActionForm;
import org.seasar.struts.annotation.Execute;

public class LogDownloadAction {
	@Resource
	protected HttpServletRequest request;
	@Resource
	protected JdbcManager jdbcManager;
	@Resource
	protected HttpSession session;
	
	// status
	@Resource
	@ActionForm
	protected LogDownloadForm logDownloadForm;
	
	public boolean hasPrev = false;
	
	public boolean hasNext = false;
	
	public long total;
	
	public List<LogDownloadData> dataList;
	
	private static final int DOWNLOAD_LOG_LIMIT = 50;

	public boolean roleRead;
	public boolean roleWrite;
	public boolean roleCSVDownload;
	public boolean roleUserManager;
	
	// ダウンロードログ画面の表示
    @Execute(validator = false)
	public String logDownload() {
    	// セッションからログイン情報の取得
    	LoginDataDto login = (LoginDataDto)session.getAttribute("loginData");
    	
    	// ログインしていないときはエラー
    	if(login == null){
    		return "/maintenance/maintenance/";
    	}
    	
    	// UserManager権限がないときはエラー
    	if(!login.roleUserManager){
    		return "/maintenance/maintenance/";
    	}
    	
    	this.roleRead = login.roleRead;
    	this.roleWrite = login.roleWrite;
    	this.roleCSVDownload = login.roleCSVDownload;
    	this.roleUserManager = login.roleUserManager;
    	
    	// ページ番号の取得
    	int page = IntegerConversionUtil.toPrimitiveInt(this.logDownloadForm.page);
    	
    	// 表示するデータの件数を取得
    	this.total = this.jdbcManager.from(LogDownloadData.class).where(this.logDownloadForm.getSearchString()).getCount();
    	
    	// 表示データの取得
    	this.dataList = this.jdbcManager.from(LogDownloadData.class)
    			.where(this.logDownloadForm.getSearchString())
    			.orderBy("download_date desc")
    			.limit(DOWNLOAD_LOG_LIMIT)
    			.offset(page * DOWNLOAD_LOG_LIMIT)
    			.getResultList();
    
    	// ページが0でないとき、前へリンクを表示
    	if(page != 0){
    		hasPrev = true;
    	}
    	
    	// ページが最終ページでないとき次へリンクを表示
    	if((page + 1) * DOWNLOAD_LOG_LIMIT < total){
    		hasNext = true;
    	}
    	
    	return "logDownload.jsp";
	}
    
    // バリデーションエラーが発生したｔ期の処理
    @Execute(validator = false)
	public String logDownload2() {
    	// セッションからログイン情報を取得する
    	LoginDataDto login = (LoginDataDto)session.getAttribute("loginData");
    	
    	// ログインエラーが発生したとき
    	if(login == null){
    		return "/maintenance/maintenance/";
    	}
    	
    	// UserManager権限がないとき
    	if(!login.roleUserManager){
    		return "/maintenance/maintenance/";
    	}
    	
    	this.roleRead = login.roleRead;
    	this.roleWrite = login.roleWrite;
    	this.roleCSVDownload = login.roleCSVDownload;
    	this.roleUserManager = login.roleUserManager;
    	
    	return "logDownload.jsp";
    }
    
    // ダウンロードログ画面で検索ボタンを押したとき
    @Execute(validator = true, input="logDownload2")
	public String search() {
    	// セッションからログイン情報を取得する
    	LoginDataDto login = (LoginDataDto)session.getAttribute("loginData");
    	
    	// ログインしていないとき
    	if(login == null){
    		return "/maintenance/maintenance/";
    	}
    	
    	// UserManager権限がないとき
    	if(!login.roleUserManager){
    		return "/maintenance/maintenance/";
    	}
    	
    	this.roleRead = login.roleRead;
    	this.roleWrite = login.roleWrite;
    	this.roleCSVDownload = login.roleCSVDownload;
    	this.roleUserManager = login.roleUserManager;
    	
    	// ページ番号の取得
    	int page = IntegerConversionUtil.toPrimitiveInt(this.logDownloadForm.page);
    	
      	// 表示するデータの件数を取得
    	this.total = this.jdbcManager.from(LogDownloadData.class).where(this.logDownloadForm.getSearchString()).getCount();
    	
    	// 表示データの取得
    	this.dataList = this.jdbcManager.from(LogDownloadData.class)
    			.where(this.logDownloadForm.getSearchString())
    			.orderBy("download_date desc")
    			.limit(DOWNLOAD_LOG_LIMIT)
    			.offset(page * DOWNLOAD_LOG_LIMIT)
    			.getResultList();
    	
    	// 先頭ページでないとき
    	if(page != 0){
    		hasPrev = true;
    	}
    	
    	// 最終ページでないとき
    	if((page + 1) * DOWNLOAD_LOG_LIMIT < total){
    		hasNext = true;
    	}
    	
    	return "logDownload.jsp";
	}
}
