/*
 * Copyright 2004-2008 the Seasar Foundation and the Others.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND,
 * either express or implied. See the License for the specific language
 * governing permissions and limitations under the License.
 */
package jp.yoyoyoyo.webformmanager.action;

import java.util.List;

import javax.annotation.Resource;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpSession;

import jp.yoyoyoyo.webformmanager.dto.LoginDataDto;
import jp.yoyoyoyo.webformmanager.entity.LogLoginData;
import jp.yoyoyoyo.webformmanager.form.LogLoginForm;

import org.seasar.extension.jdbc.JdbcManager;
import org.seasar.framework.util.IntegerConversionUtil;
import org.seasar.struts.annotation.ActionForm;
import org.seasar.struts.annotation.Execute;

public class LogLoginAction {
	@Resource
	protected HttpServletRequest request;
	@Resource
	protected JdbcManager jdbcManager;
	@Resource
	protected HttpSession session;
	
	// status
	@Resource
	@ActionForm
	protected LogLoginForm logLoginForm;
	
	public boolean hasPrev = false;
	
	public boolean hasNext = false;
	
	public long total;
	
	public List<LogLoginData> dataList;
	
	private static final int LOGIN_LOG_LIMIT = 50;

	public boolean roleRead;
	public boolean roleWrite;
	public boolean roleCSVDownload;
	public boolean roleUserManager;
	
	// ログインログページを表示したとき
    @Execute(validator = false)
	public String logLogin() {
    	// セッションからログイン情報を取得
    	LoginDataDto login = (LoginDataDto)session.getAttribute("loginData");
    	
    	// ログインしていないとき
    	if(login == null){
    		return "/maintenance/maintenance/";
    	}
    	
    	// UserManager権限がないとき
    	if(!login.roleUserManager){
    		return "/maintenance/maintenance/";
    	}
    	
    	this.roleRead = login.roleRead;
    	this.roleWrite = login.roleWrite;
    	this.roleCSVDownload = login.roleCSVDownload;
    	this.roleUserManager = login.roleUserManager;
    	
    	// ページ番号の取得
    	int page = IntegerConversionUtil.toPrimitiveInt(this.logLoginForm.page);
    	
    	// 検索データの件数を取得
    	this.total = this.jdbcManager.from(LogLoginData.class).where(this.logLoginForm.getSearchString()).getCount();
    	
    	// 検索データの取得
    	this.dataList = this.jdbcManager.from(LogLoginData.class)
    			.where(this.logLoginForm.getSearchString())
    			.orderBy("login_date desc")
    			.limit(LOGIN_LOG_LIMIT)
    			.offset(page * LOGIN_LOG_LIMIT)
    			.getResultList();
    	
    	// 先頭ページでないとき  	
    	if(page != 0){
    		hasPrev = true;
    	}
    	
    	// 最終ページでないとき
    	if((page + 1) * LOGIN_LOG_LIMIT < total){
    		hasNext = true;
    	}
    	
    	return "logLogin.jsp";
	}
    
    // バリデーションエラーが発生したとき
    @Execute(validator = false)
   	public String logLogin2() {
    	// セッションからログイン情報を取得
    	LoginDataDto login = (LoginDataDto)session.getAttribute("loginData");
    	
    	// ログインしていないとき
    	if(login == null){
    		return "/maintenance/maintenance/";
    	}
    	
    	// UserManager権限がないとき
    	if(!login.roleUserManager){
    		return "/maintenance/maintenance/";
    	}
    	
    	this.roleRead = login.roleRead;
    	this.roleWrite = login.roleWrite;
    	this.roleCSVDownload = login.roleCSVDownload;
    	this.roleUserManager = login.roleUserManager;
    	
    	return "logLogin.jsp";
    }
    
    // ログインログページで検索ボタンを押したとき
    @Execute(validator = true, input="logLogin2")
 	public String search() {
    	// セッションからログイン情報を取得
    	LoginDataDto login = (LoginDataDto)session.getAttribute("loginData");
    	
    	// ログインしていないとき
    	if(login == null){
    		return "/maintenance/maintenance/";
    	}
    	
    	// UserManager権限がないとき
    	if(!login.roleUserManager){
    		return "/maintenance/maintenance/";
    	}
    	
    	this.roleRead = login.roleRead;
    	this.roleWrite = login.roleWrite;
    	this.roleCSVDownload = login.roleCSVDownload;
    	this.roleUserManager = login.roleUserManager;
    	
       	// ページ番号の取得
    	int page = IntegerConversionUtil.toPrimitiveInt(this.logLoginForm.page);
    	
    	// 検索データの件数を取得
    	this.total = this.jdbcManager.from(LogLoginData.class).where(this.logLoginForm.getSearchString()).getCount();
    	
    	// 検索データの取得
    	this.dataList = this.jdbcManager.from(LogLoginData.class)
    			.where(this.logLoginForm.getSearchString())
    			.orderBy("login_date desc")
    			.limit(LOGIN_LOG_LIMIT)
    			.offset(page * LOGIN_LOG_LIMIT)
    			.getResultList();
    	
    	// 先頭ページでないとき
    	if(page != 0){
    		hasPrev = true;
    	}
    	
    	// 最終ページでないとき
    	if((page + 1) * LOGIN_LOG_LIMIT < total){
    		hasNext = true;
    	}
    	
    	return "logLogin.jsp";
    }
}
