package jp.yoyoyoyo.webformmanager.action;

import java.security.MessageDigest;
import java.util.List;
import java.util.StringTokenizer;

import javax.annotation.Resource;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpSession;

import jp.yoyoyoyo.webformmanager.dto.LoginDataDto;
import jp.yoyoyoyo.webformmanager.dto.NewUserDto;
import jp.yoyoyoyo.webformmanager.entity.UserData;
import jp.yoyoyoyo.webformmanager.form.NewUserForm;
import jp.yoyoyoyo.webformmanager.lib.CommonUtil;


import org.apache.struts.action.ActionMessage;
import org.apache.struts.action.ActionMessages;
import org.seasar.extension.jdbc.JdbcManager;
import org.seasar.struts.annotation.ActionForm;
import org.seasar.struts.annotation.Execute;
import org.seasar.struts.util.ActionMessagesUtil;

public class NewUserAction {
	@Resource
	protected HttpServletRequest request;
	@Resource
	protected JdbcManager jdbcManager;
	@Resource
	protected HttpSession session;

	@Resource
	@ActionForm
	protected NewUserForm newUserForm;
		
	public NewUserDto newUserDto;
	
	public String maskedPassword;
	
	public List<UserData> userData;
	
	public boolean roleRead;
	public boolean roleWrite;
	public boolean roleCSVDownload;
	public boolean roleUserManager;
	
	// 新規ユーザ画面を表示したとき
	@Execute(validator = false)
	public String newUser() {
		// セッションからログイン情報を取得する
    	LoginDataDto login = (LoginDataDto)session.getAttribute("loginData");
    	
    	// ログインしていないとき
    	if(login == null){
    		return "/maintenance/maintenance/";
    	}
    	
    	// UserManager権限がないとき
    	if(!login.roleUserManager){
    		return "/maintenance/maintenance/";
    	}
    	
    	this.roleRead = login.roleRead;
    	this.roleWrite = login.roleWrite;
    	this.roleCSVDownload = login.roleCSVDownload;
    	this.roleUserManager = login.roleUserManager;
    	
    	return "newUser.jsp";
	}
	
	// 新規ユーザ画面から戻るボタンを押したとき
	@Execute(validator = false)
	public String back() {
		return "/user/userManager/";
	}
	
	// バリデーションエラーが発生したとき
	@Execute(validator = false)
	public String newUser2() {
		// セッションからログイン情報を取得する
		LoginDataDto login = (LoginDataDto)session.getAttribute("loginData");
    	
		// ログインしていないとき
    	if(login == null){
    		return "/maintenance/maintenance/";
    	}
    	
    	// UserManager権限がないとき
    	if(!login.roleUserManager){
    		return "/maintenance/maintenance/";
    	}
    	
    	this.roleRead = login.roleRead;
    	this.roleWrite = login.roleWrite;
    	this.roleCSVDownload = login.roleCSVDownload;
    	this.roleUserManager = login.roleUserManager;
    	
    	return "newUser.jsp";
	}
	
	// 新規ユーザ画面で次へボタンを押したとき
	@Execute(validate = "validate", input="newUser2")
	public String next() {
		// セッションからログイン情報を取得する
    	LoginDataDto login = (LoginDataDto)session.getAttribute("loginData");
    	
    	// ログインしていないとき
    	if(login == null){
    		return "/maintenance/maintenance/";
    	}
    	
    	// UserManager権限がないとき
    	if(!login.roleUserManager){
    		return "/maintenance/maintenance/";
    	}
    	
    	this.roleRead = login.roleRead;
    	this.roleWrite = login.roleWrite;
    	this.roleCSVDownload = login.roleCSVDownload;
    	this.roleUserManager = login.roleUserManager;
    	
    	// ユーザー情報の取得
    	this.userData = this.jdbcManager.from(UserData.class)
    			.where("id = ?", newUserForm.id)
    			.getResultList();
    	
    	// ユーザがすでに存在しているときはエラーを表示
    	if(this.userData.size() != 0){
			ActionMessages lMessages = new ActionMessages();
			lMessages.add(ActionMessages.GLOBAL_MESSAGE,new ActionMessage("指定のオペレータIDはすでに登録されています", false));
			ActionMessagesUtil.saveErrors(request,lMessages);
			return "newUser.jsp";
    	}
    	
    	// ActionFormデータをDtoに設定
    	this.newUserDto.id = newUserForm.id;
		this.newUserDto.operatorName = newUserForm.operatorName;
	
		String tmp = "";
		String tmp2 = "";
		if(newUserForm.roleRead){
			tmp = tmp + "1,";
			tmp2 = tmp2 + "Read,";
		}
		if(newUserForm.roleWrite){
			tmp = tmp + "2,";
			tmp2 = tmp2 + "Write,";
		}	
		if(newUserForm.roleCSVDownload){
			tmp = tmp + "3,";
			tmp2 = tmp2 + "CSV Download,";
		}
		if(newUserForm.roleUserManager){
			tmp = tmp + "4,";
			tmp2 = tmp2 + "User Manager,";
		}
		
		tmp = tmp.substring(0, tmp.length() - 1);
		tmp2 = tmp2.substring(0, tmp2.length() - 1);
		
		this.newUserDto.role = tmp;
		this.newUserDto.roleText = tmp2;
		
		this.newUserDto.password = newUserForm.password1;
		   	
		// セッションにDTOを設定
    	session.setAttribute("newUserDto", this.newUserDto);
    	
    	// 表示パスワードはマスクする
    	maskedPassword = CommonUtil.getMaskPassword(newUserForm.password1);
    	
    	return "newUserConfirm.jsp";
	}
	
	// 新規ユーザ確認画面から戻るボタンを押したとき
	@Execute(validator = false)
	public String back2() {
		// セッションからログイン情報を取得する
    	LoginDataDto login = (LoginDataDto)session.getAttribute("loginData");
    	
    	// ログインしていないとき
    	if(login == null){
    		return "/maintenance/maintenance/";
    	}
    	
    	// UserManager権限がないとき
    	if(!login.roleUserManager){
    		return "/maintenance/maintenance/";
    	}
    	
    	this.roleRead = login.roleRead;
    	this.roleWrite = login.roleWrite;
    	this.roleCSVDownload = login.roleCSVDownload;
    	this.roleUserManager = login.roleUserManager;
    	
    	
    	// DTOからActionFormに値をセットする
		newUserDto = (NewUserDto)session.getAttribute("newUserDto");
    	
		newUserForm.id = newUserDto.id;
		newUserForm.operatorName = newUserDto.operatorName;
		
		StringTokenizer st1 = new StringTokenizer(newUserDto.role, ",");
		newUserForm.roleRead = false;
		newUserForm.roleWrite = false;
		newUserForm.roleCSVDownload = false;
		newUserForm.roleUserManager = false;
    	
    	while(st1.hasMoreTokens()) {
    		String tmp = st1.nextToken();
    		if(tmp.equals("1")){
    			newUserForm.roleRead = true;
    		}
    		if(tmp.equals("2")){
    			newUserForm.roleWrite = true;
    		}
    		if(tmp.equals("3")){
    			newUserForm.roleCSVDownload = true;
    		}
    		if(tmp.equals("4")){
    			newUserForm.roleUserManager = true;
    		}
    	}
    	
    	newUserForm.password1 ="";
    	newUserForm.password2 = "";
    	
		
		return "newUser.jsp";
	}
	
	// 新規ユーザ確認画面から保存ボタンを押したとき
	@Execute(validator = false)
	public String save() {
		// セッションからログイン情報を取得
    	LoginDataDto login = (LoginDataDto)session.getAttribute("loginData");
    	
    	// ログインしていないとき
    	if(login == null){
    		return "/maintenance/maintenance/";
    	}
    	
    	// UserManager権限がないとき
    	if(!login.roleUserManager){
    		return "/maintenance/maintenance/";
    	}
    	
    	this.roleRead = login.roleRead;
    	this.roleWrite = login.roleWrite;
    	this.roleCSVDownload = login.roleCSVDownload;
    	this.roleUserManager = login.roleUserManager;
    	
    	newUserDto = (NewUserDto)session.getAttribute("newUserDto");
    	
    	// パスワードをSHA-256で暗号化
		byte[] binary = newUserDto.password.getBytes();
		MessageDigest md;
		try{
			md = MessageDigest.getInstance("SHA-256");
			byte[] digest = md.digest(binary);
			
			newUserDto.password = CommonUtil.bytesToHexString(digest);
		}catch(Exception e){
			// エラーが発生したとき
			return "/maintenance/maintenance";
		}
		
		// ユーザ情報をデータベースに設定
		try{
			jdbcManager.call("insert_mst_user", newUserDto).execute();	
		} catch(Exception e){
			// エラーが発生したとき
			return "/maintenance/maintenance";
		}
		
		// セッションからDTOをクリア
    	session.removeAttribute("newUserDto");
    	
    	return "/message/message/";
	}
}