package jp.yoyoyoyo.webformmanager.action;

import java.util.List;

import javax.annotation.Resource;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpSession;

import jp.yoyoyoyo.webformmanager.dto.LoginDataDto;
import jp.yoyoyoyo.webformmanager.entity.RequestData;
import jp.yoyoyoyo.webformmanager.form.StatusForm;

import org.seasar.extension.jdbc.JdbcManager;
import org.seasar.framework.util.IntegerConversionUtil;
import org.seasar.struts.annotation.ActionForm;
import org.seasar.struts.annotation.Execute;

public class StatusAction {
	@Resource
	protected HttpServletRequest request;
	@Resource
	protected JdbcManager jdbcManager;
	@Resource
	protected HttpSession session;
	
	// status
	@Resource
	@ActionForm
	protected StatusForm statusForm;
	
	public boolean hasPrev = false;
	
	public boolean hasNext = false;
	
	public long total;
	
	public List<RequestData> dataList;
	
	private static final int STATUS_LIMIT = 50;
	

	public boolean roleRead;
	public boolean roleWrite;
	public boolean roleCSVDownload;
	public boolean roleUserManager;

	
	// ステータス画面で検索ボタンを押したとき
    @Execute(validator = true, input="status")
	public String search() {
  	
    	// セッションにActionFormを記録
    	session.setAttribute("searchConditionStatus", statusForm);
    	
        return this.status();
	}
    
    // ステータス画面を表示したとき
    @Execute(validator = false)
	public String status() {
    	// セッションからログイン情報を取得
    	LoginDataDto login = (LoginDataDto)session.getAttribute("loginData");
    	
    	// ログインしていないとき
    	if(login == null){
    		return "/maintenance/maintenance/";
    	}
    	
    	// ReadおよびWrite権限がないとき
    	if(!(login.roleRead || login.roleWrite)){
    		return "/maintenance/maintenance/";
    	}
    	
    	this.roleRead = login.roleRead;
    	this.roleWrite = login.roleWrite;
    	this.roleCSVDownload = login.roleCSVDownload;
    	this.roleUserManager = login.roleUserManager;
    	
    	// ページ情報の取得
    	int page = IntegerConversionUtil.toPrimitiveInt(this.statusForm.page);
    	
    	// セッションから検索条件を設定
    	StatusForm tmp = (StatusForm)session.getAttribute("searchConditionStatus");
    	
    	if(tmp != null){  		
      		this.statusForm.id  = tmp.id;
      		this.statusForm.seiKanji = tmp.seiKanji;
      		this.statusForm.meiKanji = tmp.meiKanji;
      		this.statusForm.seiKana = tmp.seiKana;
      		this.statusForm.meiKana = tmp.meiKana;
      		this.statusForm.zip = tmp.zip;
      		this.statusForm.email = tmp.email;
    		this.statusForm.fromDate = tmp.fromDate;
    		this.statusForm.toDate = tmp.toDate;   	
    	}
    	
    	// 検索データの件数を取得
    	this.total = this.jdbcManager.from(RequestData.class).where(statusForm.getSearchString()).getCount();
    	
    	// 検索データの取得
    	this.dataList = this.jdbcManager.from(RequestData.class)
    			.where(statusForm.getSearchString())
    			.orderBy("request_date desc")
    			.limit(STATUS_LIMIT)
    			.offset(page * STATUS_LIMIT)
    			.getResultList();
    	
    	
    	// スタートページでないとき
    	if(page != 0){
    		hasPrev = true;
    	}
    	
    	// 最終ページでないとき
    	if((page + 1) * STATUS_LIMIT < total){
    		hasNext = true;
    	}
    	
    	
        return "status.jsp";
	}
 
    // クリアボタンを押したとき
    @Execute(validator = false)
 	public String clear() {
    	statusForm.page = "0";
    	
    	statusForm.id = "";
    	statusForm.seiKanji = "";
    	statusForm.meiKanji = "";
    	statusForm.seiKana = "";
    	statusForm.meiKana = "";
    	statusForm.zip = "";
    	statusForm.email = "";
    	statusForm.fromDate = "";
    	statusForm.toDate = "";
    	
    	session.removeAttribute("searchConditionStatus");
    	
    	return this.status();
    }
    

}