package jp.yoyoyoyo.webformmanager.action;

import java.util.List;

import javax.annotation.Resource;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpSession;

import jp.yoyoyoyo.webformmanager.dto.LoginDataDto;
import jp.yoyoyoyo.webformmanager.entity.UserData;
import jp.yoyoyoyo.webformmanager.form.UserForm;

import org.seasar.extension.jdbc.JdbcManager;
import org.seasar.framework.util.IntegerConversionUtil;
import org.seasar.struts.annotation.ActionForm;
import org.seasar.struts.annotation.Execute;

public class UserAction {
	@Resource
	protected HttpServletRequest request;
	@Resource
	protected JdbcManager jdbcManager;
	@Resource
	protected HttpSession session;
	
	@Resource
	@ActionForm
	protected UserForm userForm;
	
	public boolean hasPrev = false;
	
	public boolean hasNext = false;
	
	public long total;
	
	public List<UserData> dataList;
	
	private static final int USER_COUNT_LIMIT = 50;
	
	public boolean roleRead;
	public boolean roleWrite;
	public boolean roleCSVDownload;
	public boolean roleUserManager;
	
	// ユーザ管理画面を表示したとき
    @Execute(validator = false)
	public String userManager() {
    	// セッションからログイン情報を取得する
    	LoginDataDto login = (LoginDataDto)session.getAttribute("loginData");
    	
    	// ログインしていないとき
    	if(login == null){
    		return "/maintenance/maintenance/";
    	}
    	
    	// UserManager権限がないとき
    	if(!login.roleUserManager){
    		return "/maintenance/maintenance/";
    	}
    	
    	this.roleRead = login.roleRead;
    	this.roleWrite = login.roleWrite;
    	this.roleCSVDownload = login.roleCSVDownload;
    	this.roleUserManager = login.roleUserManager;
    	
    	// ページ番号の取得
    	int page = IntegerConversionUtil.toPrimitiveInt(this.userForm.page);
    	
    	// 検索件数の取得
    	this.total = this.jdbcManager.from(UserData.class).where(userForm.getSearchString()).getCount();
    	
    	// 検索データの取得
    	this.dataList = this.jdbcManager.from(UserData.class)
    			.where(userForm.getSearchString())
    			.orderBy("id asc")
    			.limit(USER_COUNT_LIMIT)
    			.offset(page * USER_COUNT_LIMIT)
    			.getResultList();
    	
    	// スタートページでないとき
    	if(page != 0){
    		hasPrev = true;
    	}
    	
    	// 最終ページでないとき
    	if((page + 1) * USER_COUNT_LIMIT < total){
    		hasNext = true;
    	}
    	
    	return "userManager.jsp";
	}
    
    // 検索ボタンを押したとき
    @Execute(validator = false)
 	public String search() {
     	    	
     	return userManager();
 	}
    
    // 新規ユーザボタンを押したとき
    @Execute(validator = false)
  	public String newUser() {
    	return "/newUser/newUser/";
    }
}