package jp.yoyoyoyo.webformmanager.form;

import jp.yoyoyoyo.webformmanager.lib.CommonUtil;

import org.apache.struts.action.ActionMessage;
import org.apache.struts.action.ActionMessages;
import org.seasar.struts.annotation.Arg;
import org.seasar.struts.annotation.Mask;
import org.seasar.struts.annotation.Maxlength;
import org.seasar.struts.annotation.Msg;
import org.seasar.struts.annotation.Required;
import org.seasar.struts.annotation.Validwhen;

public class NewUserForm{
	
	@Required(arg0 = @Arg(key = "オペレータID", resource = false))
	@Maxlength(maxlength = 20, msg=@Msg(key="オペレータIDは２０文字以内で入力してください",resource = false))
	@Mask(mask = "^[0-9a-zA-Z]+$", msg=@Msg(key="オペレータIDは半角英数字で入力してください",resource = false))
	public String id;
	
	@Required(arg0 = @Arg(key = "オペレータ名", resource = false))
	@Maxlength(maxlength = 20, msg=@Msg(key="オペレータ名は２０文字以内で入力してください",resource = false))
	@Mask(mask = "^[^①②③④⑤⑥⑦⑧⑨⑩⑪⑫⑬⑭⑮⑯⑰⑱⑲⑳ⅠⅡⅢⅣⅤ≡∑∫∮√⊥∠∟⊿∵∩∪№㏍℡㊤㊥㊦㊧㊨㈱㈲㈹㍾㍽㍼㍻㍉㎜㎝㎞㎎㎏㏄㍉㌔㌢㍍㌘㌧㌃㌶㍑㍗㌍㌦㌣㌫㍊㌻ⅠⅡⅢⅣⅤⅥⅦⅧⅨⅩ]+$", msg=@Msg(key="オペレータ名に使用できない文字です（機種依存文字）",resource = false))	
	public String operatorName;
	public boolean roleRead;
	public boolean roleWrite;
	public boolean roleCSVDownload;
	public boolean roleUserManager;
	
	@Required(arg0 = @Arg(key = "パスワード", resource = false))
	@Maxlength(maxlength = 20, msg=@Msg(key="パスワードは２０文字以内で入力してください",resource = false))
	public String password1;
	
	@Validwhen(test="(password1 == password2)", msg=@Msg(key="パスワードとパスワード（確認）が異なります",resource = false))
	public String password2;

	public ActionMessages validate(){
		ActionMessages errors = new ActionMessages();
		
		if(!CommonUtil.validatePassword(password1)){
			errors.add("password", new ActionMessage("パスワードは半角英数字6文字-20文字で入力してください。また、英大文字、英小文字、数字の3種類の文字を含む必要があります", false));
		}
		
		if(!roleRead && !roleWrite && !roleCSVDownload && !roleUserManager){
			errors.add("role", new ActionMessage("ロールはひとつは選択してください", false));
		}
		
		return errors;
	}
}