package jp.yoyoyoyo.webformmanager.form;

import jp.yoyoyoyo.webformmanager.lib.CommonUtil;

import org.apache.struts.action.ActionMessage;
import org.apache.struts.action.ActionMessages;
import org.seasar.struts.annotation.Arg;
import org.seasar.struts.annotation.Maxlength;
import org.seasar.struts.annotation.Msg;
import org.seasar.struts.annotation.Required;
import org.seasar.struts.annotation.Validwhen;

public class PasswordChangeForm{
	@Required(arg0 = @Arg(key = "オペレータID", resource = false))
	@Maxlength(maxlength = 20, msg=@Msg(key="オペレータIDは２０文字以内で入力してください",resource = false))
	public String operatorId;
	
	@Required(arg0 = @Arg(key = "現在のパスワード", resource = false))
	@Maxlength(maxlength = 20, msg=@Msg(key="現在のパスワードは２０文字以内で入力してください",resource = false))
	public String oldPassword;
	
	@Required(arg0 = @Arg(key = "新しいパスワード", resource = false))
	@Maxlength(maxlength = 20, msg=@Msg(key="新しいパスワードは２０文字以内で入力してください",resource = false))
	public String newPassword;
	
	@Validwhen(test="(newPassword == newPassword2)", msg=@Msg(key="新しいパスワードと新しいパスワード（確認）が異なります",resource = false))
	public String newPassword2;
	
	public ActionMessages validate(){
		ActionMessages errors = new ActionMessages();
		
		if(!CommonUtil.validatePassword(newPassword)){
			errors.add("password", new ActionMessage("新しいパスワードは半角英数字6文字-20文字で入力してください。また、英大文字、英小文字、数字の3種類の文字を含む必要があります", false));
		}
		
		return errors;
	}
}