package jp.yoyoyoyo.webformmanager.form;

import jp.yoyoyoyo.webformmanager.lib.CommonUtil;

import org.apache.struts.action.ActionMessage;
import org.apache.struts.action.ActionMessages;
import org.seasar.struts.annotation.Arg;
import org.seasar.struts.annotation.Maxlength;
import org.seasar.struts.annotation.Msg;
import org.seasar.struts.annotation.Required;
import org.seasar.struts.annotation.Validwhen;

public class PasswordEditForm{
	public String id;
	
	@Required(arg0 = @Arg(key = "パスワード", resource = false))
	@Maxlength(maxlength = 20, msg=@Msg(key="パスワードは２０文字以内で入力してください",resource = false))
	public String password1;
	
	@Validwhen(test="(password1 == password2)", msg=@Msg(key="パスワードとパスワード（確認）が異なります",resource = false))
	public String password2;
	
	public ActionMessages validate(){
		ActionMessages errors = new ActionMessages();
		
		if(!CommonUtil.validatePassword(password1)){
			errors.add("password", new ActionMessage("パスワードは半角英数字6文字-20文字で入力してください。また、英大文字、英小文字、数字の3種類の文字を含む必要があります", false));
		}
		
		return errors;
	}
}