package jp.yoyoyoyo.webformmanager.form;

import java.io.Serializable;

import org.seasar.struts.annotation.Arg;
import org.seasar.struts.annotation.DateType;
import org.seasar.struts.annotation.EmailType;
import org.seasar.struts.annotation.IntegerType;
import org.seasar.struts.annotation.Mask;
import org.seasar.struts.annotation.Maxlength;
import org.seasar.struts.annotation.Msg;

public class StatusForm implements Serializable {
	/**
	 * 
	 */
	private static final long serialVersionUID = 1L;

	@IntegerType
	public String page;
	
	@Maxlength(maxlength = 20, msg=@Msg(key="申込番号は２０文字以内で入力してください",resource = false))
	@IntegerType(msg=@Msg(key="申込番号は数字で入力してください",resource =false))
	public String id;
	
	@Maxlength(maxlength = 20, msg=@Msg(key="姓（漢字）は２０文字以内で入力してください",resource = false))
	public String seiKanji;
	
	@Maxlength(maxlength = 20, msg=@Msg(key="名（漢字）は２０文字以内で入力してください",resource = false))
	public String meiKanji;
	
	@Maxlength(maxlength = 20, msg=@Msg(key="姓（カナ）は２０文字以内で入力してください",resource = false))
	@Mask(mask = "^[ァ-ヶ|ー]+$", msg=@Msg(key="姓（カナ）はカタカナで入力してください",resource = false))
	public String seiKana;
	
	@Maxlength(maxlength = 20, msg=@Msg(key="名（カナ）は２０文字以内で入力してください",resource = false))
	@Mask(mask = "^[ァ-ヶ|ー]+$", msg=@Msg(key="名（カナ）はカタカナで入力してください",resource = false))
	public String meiKana;
	
	@Maxlength(maxlength = 7, msg=@Msg(key="郵便番号は7文字以内で入力してください",resource = false))
	@Mask(mask = "^[0-9]{7,7}$", msg=@Msg(key="郵便番号は数字７桁で入力してください",resource = false))
	public String zip;
	
	@EmailType(arg0 = @Arg(key = "メールアドレス", resource = false), msg=@Msg(key="メールアドレスの形式が間違っています",resource = false))
	@Maxlength(maxlength = 50, msg=@Msg(key="メールアドレスは５０文字以内で入力してください",resource = false))
	public String email;
	
	@DateType(datePatternStrict="yyyy/MM/dd", msg=@Msg(key="開始日付はYYYY/MM/DD形式で入力してください",resource = false))
	public String fromDate;
	
	@DateType(datePatternStrict="yyyy/MM/dd", msg=@Msg(key="終了日付はYYYY/MM/DD形式で入力してください",resource = false))
	public String toDate;
	
	public String getSearchString(){
		String where = "1 = 1";
		
		if(!(id == null)){
			if(!id.equals("")){
				where += " and ";
				where += "id = '" + id + "'";
			}			
		}
		
		if(!(seiKanji == null)){
			if(!seiKanji.equals("")){
				where += " and ";
				where += "sei_kanji = '" + seiKanji + "'";
			}			
		}
		
		if(!(meiKanji == null)){
			if(!meiKanji.equals("")){
				where += " and ";
				where += "mei_kanji = '" + meiKanji + "'";
			}			
		}
		
		if(!(seiKana == null)){
			if(!seiKana.equals("")){
				where += " and ";
				where += "sei_kana = '" + seiKana + "'";
			}			
		}
		
		if(!(meiKana == null)){
			if(!meiKana.equals("")){
				where += " and ";
				where += "mei_kana = '" + meiKana + "'";
			}			
		}

		if(!(zip == null)){
			if(!zip.equals("")){
				where += " and ";
				where += "concat(zip1,zip2) = '" + zip + "'";
			}			
		}
		
		if(!(email == null)){
			if(!email.equals("")){
				where += " and ";
				where += "e_mail = '" + email + "'";
			}			
		}
		
		if(!(fromDate == null)){
			if(!fromDate.equals("")){
				where += " and ";
				where += "request_date > '" + fromDate + "'";
			}
		}
		
		if(!(toDate == null)){
			if(!toDate.equals("")){
				where += " and ";
				where += "request_date < '" + toDate + "'";
			}			
		}

		
		return where;
	}
}