package jp.yoyoyoyo.webformmanager.form;

import org.apache.struts.action.ActionMessage;
import org.apache.struts.action.ActionMessages;
import org.seasar.struts.annotation.Arg;
import org.seasar.struts.annotation.Mask;
import org.seasar.struts.annotation.Maxlength;
import org.seasar.struts.annotation.Msg;
import org.seasar.struts.annotation.Required;

public class UserEditForm{
	public String id;
	
	@Required(arg0 = @Arg(key = "オペレータ名", resource = false))
	@Maxlength(maxlength = 20, msg=@Msg(key="オペレータ名は２０文字以内で入力してください",resource = false))
	@Mask(mask = "^[^①②③④⑤⑥⑦⑧⑨⑩⑪⑫⑬⑭⑮⑯⑰⑱⑲⑳ⅠⅡⅢⅣⅤ≡∑∫∮√⊥∠∟⊿∵∩∪№㏍℡㊤㊥㊦㊧㊨㈱㈲㈹㍾㍽㍼㍻㍉㎜㎝㎞㎎㎏㏄㍉㌔㌢㍍㌘㌧㌃㌶㍑㍗㌍㌦㌣㌫㍊㌻ⅠⅡⅢⅣⅤⅥⅦⅧⅨⅩ]+$", msg=@Msg(key="オペレータ名に使用できない文字です（機種依存文字）",resource = false))	
	public String operatorName;
	public boolean roleRead;
	public boolean roleWrite;
	public boolean roleCSVDownload;
	public boolean roleUserManager;
	public boolean lock;
	public boolean disabled;

	public ActionMessages validate(){
		ActionMessages errors = new ActionMessages();
		
		if(!roleRead && !roleWrite && !roleCSVDownload && !roleUserManager){
			errors.add("role", new ActionMessage("ロールはひとつは選択してください", false));
		}
		
		return errors;
	}
}