package jp.yoyoyoyo.webformmanager.lib;

import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class CommonUtil{
	public static String bytesToHexString(byte[] fromByte) { 
		StringBuilder hexStrBuilder = new StringBuilder();
		for (int i = 0; i < fromByte.length; i++) {
			// 16進数表記で1桁数値だった場合、2桁目を0で埋める 
			if ((fromByte[i] & 0xff) < 0x10) {
				hexStrBuilder.append("0");            
			}
			hexStrBuilder.append(Integer.toHexString(0xff & fromByte[i]));
		}
		
		return hexStrBuilder.toString();
	}
	
	public static byte[] HexStringToBytes(String fromHexStr) {
		//16進数表記では2文字で1バイトを表現するため、
		//Byte型配列に変換する際には、配列の長さは1/2で良い
		byte[] toByte = new byte[fromHexStr.length() / 2];
		//16進数表記文字列を、2文字ずつByte型へ変換していく 
		for (int i = 0; i < toByte.length; i++) {
			toByte[i] = (byte) Integer.parseInt(fromHexStr.substring(i * 2, (i + 1) * 2), 16);
			}        
		return toByte;    
	}
	
	public static boolean validatePassword(String value){
		Pattern pattern1 =  Pattern.compile("^[0-9a-zA-Z]{6,20}$");
		Matcher matcher1 = pattern1.matcher(value);
		
		Pattern pattern2 =  Pattern.compile("[0-9]");
		Matcher matcher2 = pattern2.matcher(value);
		
		Pattern pattern3 =  Pattern.compile("[a-z]");
		Matcher matcher3 = pattern3.matcher(value);
		
		Pattern pattern4 =  Pattern.compile("[A-Z]");
		Matcher matcher4 = pattern4.matcher(value);
				
		boolean b1 = matcher1.find();
		boolean b2 = matcher2.find();
		boolean b3 = matcher3.find();
		boolean b4 = matcher4.find();	
		
		if(b1){
			if(b2 && b3 && b4){
				return true;
			}
		}
		
		return false;
	}
	
	public static String getMaskPassword(String value){
		int len = value.length();
		String ret = "";
		
		for(int i = 0; i < len; i++){
			ret += "*";
		}
		
		return ret;
		
	}
}